/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.content.Intent;
import androidx.annotation.NonNull;
import no.nordicsemi.android.dfu.BaseDfuImpl;
import no.nordicsemi.android.dfu.DfuBaseService;

abstract class BaseButtonlessDfuImpl
extends BaseDfuImpl {
    private final ButtonlessBluetoothCallback mBluetoothCallback = new ButtonlessBluetoothCallback();

    BaseButtonlessDfuImpl(@NonNull Intent intent, @NonNull DfuBaseService service) {
        super(intent, service);
    }

    @Override
    public BaseDfuImpl.BaseBluetoothGattCallback getGattCallback() {
        return this.mBluetoothCallback;
    }

    void finalize(@NonNull Intent intent, boolean forceRefresh, boolean scanForBootloader) {
        boolean restoreBond;
        boolean keepBond = intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_KEEP_BOND", false);
        this.mService.refreshDeviceCache(this.mGatt, forceRefresh || !keepBond);
        this.mService.close(this.mGatt);
        if (this.mGatt.getDevice().getBondState() == 12 && ((restoreBond = intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_RESTORE_BOND", false)) || !keepBond)) {
            this.removeBond();
            this.mService.waitFor(2000);
        }
        this.logi("Restarting to bootloader mode");
        Intent newIntent = new Intent();
        newIntent.fillIn(intent, 24);
        this.restartService(newIntent, scanForBootloader);
    }

    protected class ButtonlessBluetoothCallback
    extends BaseDfuImpl.BaseBluetoothGattCallback {
        protected ButtonlessBluetoothCallback() {
            super(BaseButtonlessDfuImpl.this);
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            BaseButtonlessDfuImpl.this.mService.sendLogBroadcast(5, "Notification received from " + characteristic.getUuid() + ", value (0x): " + this.parse(characteristic));
            BaseButtonlessDfuImpl.this.mReceivedData = characteristic.getValue();
            BaseButtonlessDfuImpl.this.notifyLock();
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            BaseButtonlessDfuImpl.this.mRequestCompleted = true;
            BaseButtonlessDfuImpl.this.notifyLock();
        }
    }
}

