/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.content.Intent;
import androidx.annotation.NonNull;
import java.util.Locale;
import no.nordicsemi.android.dfu.BaseButtonlessDfuImpl;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.RemoteDfuException;
import no.nordicsemi.android.dfu.internal.exception.UnknownResponseException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;
import no.nordicsemi.android.error.SecureDfuError;

abstract class ButtonlessDfuImpl
extends BaseButtonlessDfuImpl {
    private static final int DFU_STATUS_SUCCESS = 1;
    private static final int OP_CODE_ENTER_BOOTLOADER_KEY = 1;
    private static final int OP_CODE_RESPONSE_CODE_KEY = 32;
    private static final byte[] OP_CODE_ENTER_BOOTLOADER = new byte[]{1};

    ButtonlessDfuImpl(@NonNull Intent intent, @NonNull DfuBaseService service) {
        super(intent, service);
    }

    protected abstract int getResponseType();

    protected abstract BluetoothGattCharacteristic getButtonlessDfuCharacteristic();

    protected abstract boolean shouldScanForBootloader();

    @Override
    public void performDfu(@NonNull Intent intent) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        this.mProgressInfo.setProgress(-2);
        this.mService.waitFor(1000L);
        BluetoothGatt gatt = this.mGatt;
        this.mService.sendLogBroadcast(15, "Application with buttonless update found");
        this.mService.sendLogBroadcast(1, "Jumping to the DFU Bootloader...");
        BluetoothGattCharacteristic characteristic = this.getButtonlessDfuCharacteristic();
        int type = this.getResponseType();
        this.enableCCCD(characteristic, this.getResponseType());
        this.mService.sendLogBroadcast(10, (type == 2 ? "Indications" : "Notifications") + " enabled");
        this.mService.waitFor(1000L);
        try {
            byte[] response;
            this.mProgressInfo.setProgress(-3);
            this.logi("Sending Enter Bootloader (Op Code = 1)");
            this.writeOpCode(characteristic, OP_CODE_ENTER_BOOTLOADER, true);
            this.mService.sendLogBroadcast(10, "Enter bootloader sent (Op Code = 1)");
            try {
                response = this.readNotificationResponse();
            }
            catch (DeviceDisconnectedException e) {
                response = this.mReceivedData;
            }
            if (response != null) {
                int status = this.getStatusCode(response, 1);
                this.logi("Response received (Op Code = " + response[1] + ", Status = " + status + ")");
                this.mService.sendLogBroadcast(10, "Response received (Op Code = " + response[1] + ", Status = " + status + ")");
                if (status != 1) {
                    throw new RemoteDfuException("Device returned error after sending Enter Bootloader", status);
                }
                this.mService.waitUntilDisconnected();
            } else {
                this.logi("Device disconnected before receiving notification");
            }
            this.mService.sendLogBroadcast(5, "Disconnected by the remote device");
            this.finalize(intent, false, this.shouldScanForBootloader());
        }
        catch (UnknownResponseException e) {
            int error = 4104;
            this.loge(e.getMessage());
            this.mService.sendLogBroadcast(20, e.getMessage());
            this.mService.terminateConnection(gatt, 4104);
        }
        catch (RemoteDfuException e) {
            int error = 0x800 | e.getErrorNumber();
            this.loge(e.getMessage());
            this.mService.sendLogBroadcast(20, String.format(Locale.US, "Remote DFU error: %s", SecureDfuError.parseButtonlessError(error)));
            this.mService.terminateConnection(gatt, error | 0x2000);
        }
    }

    private int getStatusCode(byte[] response, int request) throws UnknownResponseException {
        if (response == null || response.length < 3 || response[0] != 32 || response[1] != request || response[2] != 1 && response[2] != 2 && response[2] != 4) {
            throw new UnknownResponseException("Invalid response received", response, 32, request);
        }
        return response[2];
    }
}

