/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Intent;
import android.os.Build;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.UUID;
import java.util.zip.CRC32;
import no.nordicsemi.android.dfu.BaseCustomDfuImpl;
import no.nordicsemi.android.dfu.BaseDfuImpl;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.FileType;
import no.nordicsemi.android.dfu.internal.ArchiveInputStream;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.RemoteDfuException;
import no.nordicsemi.android.dfu.internal.exception.RemoteDfuExtendedErrorException;
import no.nordicsemi.android.dfu.internal.exception.UnknownResponseException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;
import no.nordicsemi.android.error.SecureDfuError;

class SecureDfuImpl
extends BaseCustomDfuImpl {
    static final UUID DEFAULT_DFU_SERVICE_UUID = new UUID(279658205548544L, -9223371485494954757L);
    static final UUID DEFAULT_DFU_CONTROL_POINT_UUID = new UUID(-8157989241631715488L, -6937650605005804976L);
    static final UUID DEFAULT_DFU_PACKET_UUID = new UUID(-8157989237336748192L, -6937650605005804976L);
    static UUID DFU_SERVICE_UUID = DEFAULT_DFU_SERVICE_UUID;
    static UUID DFU_CONTROL_POINT_UUID = DEFAULT_DFU_CONTROL_POINT_UUID;
    static UUID DFU_PACKET_UUID = DEFAULT_DFU_PACKET_UUID;
    private static final int DFU_STATUS_SUCCESS = 1;
    private static final int MAX_ATTEMPTS = 3;
    private static final int OBJECT_COMMAND = 1;
    private static final int OBJECT_DATA = 2;
    private static final int OP_CODE_CREATE_KEY = 1;
    private static final int OP_CODE_PACKET_RECEIPT_NOTIF_REQ_KEY = 2;
    private static final int OP_CODE_CALCULATE_CHECKSUM_KEY = 3;
    private static final int OP_CODE_EXECUTE_KEY = 4;
    private static final int OP_CODE_SELECT_OBJECT_KEY = 6;
    private static final int OP_CODE_RESPONSE_CODE_KEY = 96;
    private static final byte[] OP_CODE_CREATE_COMMAND = new byte[]{1, 1, 0, 0, 0, 0};
    private static final byte[] OP_CODE_CREATE_DATA = new byte[]{1, 2, 0, 0, 0, 0};
    private static final byte[] OP_CODE_PACKET_RECEIPT_NOTIF_REQ = new byte[]{2, 0, 0};
    private static final byte[] OP_CODE_CALCULATE_CHECKSUM = new byte[]{3};
    private static final byte[] OP_CODE_EXECUTE = new byte[]{4};
    private static final byte[] OP_CODE_SELECT_OBJECT = new byte[]{6, 0};
    private BluetoothGattCharacteristic mControlPointCharacteristic;
    private BluetoothGattCharacteristic mPacketCharacteristic;
    private final SecureBluetoothCallback mBluetoothCallback = new SecureBluetoothCallback();

    SecureDfuImpl(@NonNull Intent intent, @NonNull DfuBaseService service) {
        super(intent, service);
    }

    @Override
    public boolean isClientCompatible(@NonNull Intent intent, @NonNull BluetoothGatt gatt) {
        BluetoothGattService dfuService = gatt.getService(DFU_SERVICE_UUID);
        if (dfuService == null) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = dfuService.getCharacteristic(DFU_CONTROL_POINT_UUID);
        if (characteristic == null || characteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG) == null) {
            return false;
        }
        this.mControlPointCharacteristic = characteristic;
        this.mPacketCharacteristic = dfuService.getCharacteristic(DFU_PACKET_UUID);
        return this.mPacketCharacteristic != null;
    }

    @Override
    public boolean initialize(@NonNull Intent intent, @NonNull BluetoothGatt gatt, @FileType int fileType, @NonNull InputStream firmwareStream, @Nullable InputStream initPacketStream) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        if (initPacketStream == null) {
            this.mService.sendLogBroadcast(20, "The Init packet is required by this version DFU Bootloader");
            this.mService.terminateConnection(gatt, 4107);
            return false;
        }
        return super.initialize(intent, gatt, fileType, firmwareStream, initPacketStream);
    }

    @Override
    public BaseDfuImpl.BaseBluetoothGattCallback getGattCallback() {
        return this.mBluetoothCallback;
    }

    @Override
    protected UUID getControlPointCharacteristicUUID() {
        return DFU_CONTROL_POINT_UUID;
    }

    @Override
    protected UUID getPacketCharacteristicUUID() {
        return DFU_PACKET_UUID;
    }

    @Override
    protected UUID getDfuServiceUUID() {
        return DFU_SERVICE_UUID;
    }

    @Override
    public void performDfu(@NonNull Intent intent) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        this.logw("Secure DFU bootloader found");
        this.mProgressInfo.setProgress(-2);
        this.mService.waitFor(1000L);
        BluetoothGatt gatt = this.mGatt;
        if (intent.hasExtra("no.nordicsemi.android.dfu.extra.EXTRA_MTU") && Build.VERSION.SDK_INT >= 21) {
            int requiredMtu = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_MTU", 517);
            this.logi("Requesting MTU = " + requiredMtu);
            this.requestMtu(requiredMtu);
        }
        try {
            boolean allowResume;
            this.enableCCCD(this.mControlPointCharacteristic, 1);
            this.mService.sendLogBroadcast(10, "Notifications enabled");
            this.mService.waitFor(1000L);
            boolean bl = allowResume = !intent.hasExtra("no.nordicsemi.android.dfu.extra.EXTRA_DISABLE_RESUME") || !intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_DISABLE_RESUME", false);
            if (!allowResume) {
                this.logi("Resume feature disabled. Performing fresh DFU");
            }
            try {
                this.sendInitPacket(gatt, allowResume);
            }
            catch (RemoteDfuException e) {
                if (!this.mProgressInfo.isLastPart()) {
                    this.mRemoteErrorOccurred = false;
                    this.logw("Sending SD+BL failed. Trying to send App only");
                    this.mService.sendLogBroadcast(15, "Invalid system components. Trying to send application");
                    this.mFileType = 4;
                    ArchiveInputStream zhis = (ArchiveInputStream)this.mFirmwareStream;
                    zhis.setContentType(this.mFileType);
                    byte[] applicationInit = zhis.getApplicationInit();
                    this.mInitPacketStream = new ByteArrayInputStream(applicationInit);
                    this.mInitPacketSizeInBytes = applicationInit.length;
                    this.mImageSizeInBytes = zhis.applicationImageSize();
                    this.mProgressInfo.init(this.mImageSizeInBytes, 2, 2);
                    this.sendInitPacket(gatt, false);
                }
                throw e;
            }
            this.sendFirmware(gatt);
            this.mProgressInfo.setProgress(-5);
            this.mService.waitUntilDisconnected();
            this.mService.sendLogBroadcast(5, "Disconnected by the remote device");
            this.finalize(intent, false);
        }
        catch (UploadAbortedException e) {
            throw e;
        }
        catch (UnknownResponseException e) {
            int error = 4104;
            this.loge(e.getMessage());
            this.mService.sendLogBroadcast(20, e.getMessage());
            this.mService.terminateConnection(gatt, 4104);
        }
        catch (RemoteDfuException e) {
            int error = 0x200 | e.getErrorNumber();
            this.loge(e.getMessage() + ": " + SecureDfuError.parse(error));
            this.mService.sendLogBroadcast(20, String.format(Locale.US, "Remote DFU error: %s", SecureDfuError.parse(error)));
            if (e instanceof RemoteDfuExtendedErrorException) {
                RemoteDfuExtendedErrorException ee = (RemoteDfuExtendedErrorException)e;
                int extendedError = 0x400 | ee.getExtendedErrorNumber();
                this.loge("Extended Error details: " + SecureDfuError.parseExtendedError(extendedError));
                this.mService.sendLogBroadcast(20, "Details: " + SecureDfuError.parseExtendedError(extendedError) + " (Code = " + ee.getExtendedErrorNumber() + ")");
                this.mService.terminateConnection(gatt, extendedError | 0x2000);
            }
            this.mService.terminateConnection(gatt, error | 0x2000);
        }
    }

    private void sendInitPacket(@NonNull BluetoothGatt gatt, boolean allowResume) throws RemoteDfuException, DeviceDisconnectedException, DfuException, UploadAbortedException, UnknownResponseException {
        int crc;
        CRC32 crc32 = new CRC32();
        this.logi("Setting object to Command (Op Code = 6, Type = 1)");
        ObjectInfo info = this.selectObject(1);
        this.logi(String.format(Locale.US, "Command object info received (Max size = %d, Offset = %d, CRC = %08X)", info.maxSize, info.offset, info.CRC32));
        this.mService.sendLogBroadcast(10, String.format(Locale.US, "Command object info received (Max size = %d, Offset = %d, CRC = %08X)", info.maxSize, info.offset, info.CRC32));
        if (this.mInitPacketSizeInBytes > info.maxSize) {
            // empty if block
        }
        boolean skipSendingInitPacket = false;
        boolean resumeSendingInitPacket = false;
        if (allowResume && info.offset > 0 && info.offset <= this.mInitPacketSizeInBytes) {
            try {
                byte[] buffer = new byte[info.offset];
                this.mInitPacketStream.read(buffer);
                crc32.update(buffer);
                crc = (int)(crc32.getValue() & 0xFFFFFFFFL);
                if (info.CRC32 == crc) {
                    this.logi("Init packet CRC is the same");
                    if (info.offset == this.mInitPacketSizeInBytes) {
                        this.logi("-> Whole Init packet was sent before");
                        skipSendingInitPacket = true;
                        this.mService.sendLogBroadcast(10, "Received CRC match Init packet");
                    } else {
                        this.logi("-> " + info.offset + " bytes of Init packet were sent before");
                        resumeSendingInitPacket = true;
                        this.mService.sendLogBroadcast(10, "Resuming sending Init packet...");
                    }
                } else {
                    this.mInitPacketStream.reset();
                    crc32.reset();
                    info.offset = 0;
                }
            }
            catch (IOException e) {
                this.loge("Error while reading " + info.offset + " bytes from the init packet stream", e);
                try {
                    this.mInitPacketStream.reset();
                    crc32.reset();
                    info.offset = 0;
                }
                catch (IOException e1) {
                    this.loge("Error while resetting the init packet stream", e1);
                    this.mService.terminateConnection(gatt, 4100);
                    return;
                }
            }
        }
        if (!skipSendingInitPacket) {
            this.setPacketReceiptNotifications(0);
            this.mService.sendLogBroadcast(10, "Packet Receipt Notif disabled (Op Code = 2, Value = 0)");
            int attempt = 1;
            while (attempt <= 3) {
                if (!resumeSendingInitPacket) {
                    this.logi("Creating Init packet object (Op Code = 1, Type = 1, Size = " + this.mInitPacketSizeInBytes + ")");
                    this.writeCreateRequest(1, this.mInitPacketSizeInBytes);
                    this.mService.sendLogBroadcast(10, "Command object created");
                }
                try {
                    this.logi("Sending " + (this.mInitPacketSizeInBytes - info.offset) + " bytes of init packet...");
                    this.writeInitData(this.mPacketCharacteristic, crc32);
                }
                catch (DeviceDisconnectedException e) {
                    this.loge("Disconnected while sending init packet");
                    throw e;
                }
                crc = (int)(crc32.getValue() & 0xFFFFFFFFL);
                this.mService.sendLogBroadcast(10, String.format(Locale.US, "Command object sent (CRC = %08X)", crc));
                this.logi("Sending Calculate Checksum command (Op Code = 3)");
                ObjectChecksum checksum = this.readChecksum();
                this.mService.sendLogBroadcast(10, String.format(Locale.US, "Checksum received (Offset = %d, CRC = %08X)", checksum.offset, checksum.CRC32));
                this.logi(String.format(Locale.US, "Checksum received (Offset = %d, CRC = %08X)", checksum.offset, checksum.CRC32));
                if (crc == checksum.CRC32) break;
                if (attempt < 3) {
                    this.logi("CRC does not match! Retrying...(" + ++attempt + "/" + 3 + ")");
                    this.mService.sendLogBroadcast(15, "CRC does not match! Retrying...(" + attempt + "/" + 3 + ")");
                    try {
                        resumeSendingInitPacket = false;
                        info.offset = 0;
                        info.CRC32 = 0;
                        this.mInitPacketStream.reset();
                        crc32.reset();
                        continue;
                    }
                    catch (IOException e) {
                        this.loge("Error while resetting the init packet stream", e);
                        this.mService.terminateConnection(gatt, 4100);
                        return;
                    }
                }
                this.loge("CRC does not match!");
                this.mService.sendLogBroadcast(20, "CRC does not match!");
                this.mService.terminateConnection(gatt, 4109);
                return;
            }
        }
        this.logi("Executing init packet (Op Code = 4)");
        this.writeExecute();
        this.mService.sendLogBroadcast(10, "Command object executed");
    }

    private void sendFirmware(BluetoothGatt gatt) throws RemoteDfuException, DeviceDisconnectedException, DfuException, UploadAbortedException, UnknownResponseException {
        int numberOfPacketsBeforeNotification = this.mPacketsBeforeNotification;
        if (numberOfPacketsBeforeNotification > 0) {
            this.setPacketReceiptNotifications(numberOfPacketsBeforeNotification);
            this.mService.sendLogBroadcast(10, "Packet Receipt Notif Req (Op Code = 2) sent (Value = " + numberOfPacketsBeforeNotification + ")");
        }
        this.logi("Setting object to Data (Op Code = 6, Type = 2)");
        ObjectInfo info = this.selectObject(2);
        this.logi(String.format(Locale.US, "Data object info received (Max size = %d, Offset = %d, CRC = %08X)", info.maxSize, info.offset, info.CRC32));
        this.mService.sendLogBroadcast(10, String.format(Locale.US, "Data object info received (Max size = %d, Offset = %d, CRC = %08X)", info.maxSize, info.offset, info.CRC32));
        this.mProgressInfo.setMaxObjectSizeInBytes(info.maxSize);
        int chunkCount = (this.mImageSizeInBytes + info.maxSize - 1) / info.maxSize;
        int currentChunk = 0;
        boolean resumeSendingData = false;
        if (info.offset > 0) {
            try {
                currentChunk = info.offset / info.maxSize;
                int bytesSentAndExecuted = info.maxSize * currentChunk;
                int bytesSentNotExecuted = info.offset - bytesSentAndExecuted;
                if (bytesSentNotExecuted == 0) {
                    bytesSentAndExecuted -= info.maxSize;
                    bytesSentNotExecuted = info.maxSize;
                }
                if (bytesSentAndExecuted > 0) {
                    this.mFirmwareStream.read(new byte[bytesSentAndExecuted]);
                    this.mFirmwareStream.mark(info.maxSize);
                }
                this.mFirmwareStream.read(new byte[bytesSentNotExecuted]);
                int crc = (int)(((ArchiveInputStream)this.mFirmwareStream).getCrc32() & 0xFFFFFFFFL);
                if (crc == info.CRC32) {
                    this.logi(info.offset + " bytes of data sent before, CRC match");
                    this.mService.sendLogBroadcast(10, info.offset + " bytes of data sent before, CRC match");
                    this.mProgressInfo.setBytesSent(info.offset);
                    this.mProgressInfo.setBytesReceived(info.offset);
                    if (bytesSentNotExecuted == info.maxSize && info.offset < this.mImageSizeInBytes) {
                        this.logi("Executing data object (Op Code = 4)");
                        this.writeExecute();
                        this.mService.sendLogBroadcast(10, "Data object executed");
                    }
                    resumeSendingData = true;
                }
                this.logi(info.offset + " bytes sent before, CRC does not match");
                this.mService.sendLogBroadcast(15, info.offset + " bytes sent before, CRC does not match");
                this.mProgressInfo.setBytesSent(bytesSentAndExecuted);
                this.mProgressInfo.setBytesReceived(bytesSentAndExecuted);
                info.offset -= bytesSentNotExecuted;
                info.CRC32 = 0;
                this.mFirmwareStream.reset();
                this.logi("Resuming from byte " + info.offset + "...");
                this.mService.sendLogBroadcast(10, "Resuming from byte " + info.offset + "...");
            }
            catch (IOException e) {
                this.loge("Error while reading firmware stream", e);
                this.mService.terminateConnection(gatt, 4100);
                return;
            }
        } else {
            this.mProgressInfo.setBytesSent(0);
        }
        long initialDelay = 400L;
        long startTime = SystemClock.elapsedRealtime() + 400L;
        if (info.offset < this.mImageSizeInBytes) {
            int attempt = 1;
            while (this.mProgressInfo.getAvailableObjectSizeIsBytes() > 0) {
                int crc;
                if (!resumeSendingData) {
                    int availableObjectSizeInBytes = this.mProgressInfo.getAvailableObjectSizeIsBytes();
                    this.logi("Creating Data object (Op Code = 1, Type = 2, Size = " + availableObjectSizeInBytes + ") (" + (currentChunk + 1) + "/" + chunkCount + ")");
                    this.writeCreateRequest(2, availableObjectSizeInBytes);
                    this.mService.sendLogBroadcast(10, "Data object (" + (currentChunk + 1) + "/" + chunkCount + ") created");
                    if (currentChunk == 0) {
                        this.mService.waitFor(400L);
                    }
                    this.mService.sendLogBroadcast(10, "Uploading firmware...");
                } else {
                    this.mService.sendLogBroadcast(10, "Resuming uploading firmware...");
                    resumeSendingData = false;
                }
                try {
                    this.logi("Uploading firmware...");
                    this.uploadFirmwareImage(this.mPacketCharacteristic);
                }
                catch (DeviceDisconnectedException e) {
                    this.loge("Disconnected while sending data");
                    throw e;
                }
                this.logi("Sending Calculate Checksum command (Op Code = 3)");
                ObjectChecksum checksum = this.readChecksum();
                this.logi(String.format(Locale.US, "Checksum received (Offset = %d, CRC = %08X)", checksum.offset, checksum.CRC32));
                this.mService.sendLogBroadcast(10, String.format(Locale.US, "Checksum received (Offset = %d, CRC = %08X)", checksum.offset, checksum.CRC32));
                int bytesLost = this.mProgressInfo.getBytesSent() - checksum.offset;
                if (bytesLost > 0) {
                    this.logw(bytesLost + " bytes were lost!");
                    this.mService.sendLogBroadcast(15, bytesLost + " bytes were lost");
                    try {
                        this.mFirmwareStream.reset();
                        this.mFirmwareStream.read(new byte[info.maxSize - bytesLost]);
                        this.mProgressInfo.setBytesSent(checksum.offset);
                    }
                    catch (IOException e) {
                        this.loge("Error while reading firmware stream", e);
                        this.mService.terminateConnection(gatt, 4100);
                        return;
                    }
                    boolean newPrn = true;
                    if (this.mPacketsBeforeNotification == 0 || this.mPacketsBeforeNotification > 1) {
                        this.mPacketsBeforeNotification = 1;
                        numberOfPacketsBeforeNotification = 1;
                        this.setPacketReceiptNotifications(numberOfPacketsBeforeNotification);
                        this.mService.sendLogBroadcast(10, "Packet Receipt Notif Req (Op Code = 2) sent (Value = 1)");
                    }
                }
                if ((crc = (int)(((ArchiveInputStream)this.mFirmwareStream).getCrc32() & 0xFFFFFFFFL)) == checksum.CRC32) {
                    if (bytesLost > 0) {
                        resumeSendingData = true;
                        continue;
                    }
                    this.logi("Executing data object (Op Code = 4)");
                    this.writeExecute(this.mProgressInfo.isComplete());
                    this.mService.sendLogBroadcast(10, "Data object executed");
                    ++currentChunk;
                    attempt = 1;
                    this.mFirmwareStream.mark(0);
                    continue;
                }
                String crcFailMessage = String.format(Locale.US, "CRC does not match! Expected %08X but found %08X.", crc, checksum.CRC32);
                if (attempt < 3) {
                    crcFailMessage = crcFailMessage + String.format(Locale.US, " Retrying...(%d/%d)", ++attempt, 3);
                    this.logi(crcFailMessage);
                    this.mService.sendLogBroadcast(15, crcFailMessage);
                    try {
                        this.mFirmwareStream.reset();
                        this.mProgressInfo.setBytesSent(((ArchiveInputStream)this.mFirmwareStream).getBytesRead());
                        continue;
                    }
                    catch (IOException e) {
                        this.loge("Error while resetting the firmware stream", e);
                        this.mService.terminateConnection(gatt, 4100);
                        return;
                    }
                }
                this.loge(crcFailMessage);
                this.mService.sendLogBroadcast(20, crcFailMessage);
                this.mService.terminateConnection(gatt, 4109);
                return;
            }
        } else {
            this.logi("Executing data object (Op Code = 4)");
            this.writeExecute(true);
            this.mService.sendLogBroadcast(10, "Data object executed");
        }
        long endTime = SystemClock.elapsedRealtime();
        this.logi("Transfer of " + (this.mProgressInfo.getBytesSent() - info.offset) + " bytes has taken " + (endTime - startTime) + " ms");
        this.mService.sendLogBroadcast(10, "Upload completed in " + (endTime - startTime) + " ms");
    }

    private int getStatusCode(byte[] response, int request) throws UnknownResponseException {
        if (response == null || response.length < 3 || response[0] != 96 || response[1] != request || response[2] != 1 && response[2] != 2 && response[2] != 3 && response[2] != 4 && response[2] != 5 && response[2] != 7 && response[2] != 8 && response[2] != 10 && response[2] != 11) {
            throw new UnknownResponseException("Invalid response received", response, 96, request);
        }
        return response[2];
    }

    private void setNumberOfPackets(@NonNull byte[] data, int value) {
        data[1] = (byte)(value & 0xFF);
        data[2] = (byte)(value >> 8 & 0xFF);
    }

    private void setObjectSize(@NonNull byte[] data, int value) {
        data[2] = (byte)(value & 0xFF);
        data[3] = (byte)(value >> 8 & 0xFF);
        data[4] = (byte)(value >> 16 & 0xFF);
        data[5] = (byte)(value >> 24 & 0xFF);
    }

    private void setPacketReceiptNotifications(int number) throws DfuException, DeviceDisconnectedException, UploadAbortedException, UnknownResponseException, RemoteDfuException {
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to read Checksum: device disconnected");
        }
        this.logi("Sending the number of packets before notifications (Op Code = 2, Value = " + number + ")");
        this.setNumberOfPackets(OP_CODE_PACKET_RECEIPT_NOTIF_REQ, number);
        this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_PACKET_RECEIPT_NOTIF_REQ);
        byte[] response = this.readNotificationResponse();
        int status = this.getStatusCode(response, 2);
        if (status == 11) {
            throw new RemoteDfuExtendedErrorException("Sending the number of packets failed", response[3]);
        }
        if (status != 1) {
            throw new RemoteDfuException("Sending the number of packets failed", status);
        }
    }

    private void writeOpCode(@NonNull BluetoothGattCharacteristic characteristic, @NonNull byte[] value) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        this.writeOpCode(characteristic, value, false);
    }

    private void writeCreateRequest(int type, int size) throws DeviceDisconnectedException, DfuException, UploadAbortedException, RemoteDfuException, UnknownResponseException {
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to create object: device disconnected");
        }
        byte[] data = type == 1 ? OP_CODE_CREATE_COMMAND : OP_CODE_CREATE_DATA;
        this.setObjectSize(data, size);
        this.writeOpCode(this.mControlPointCharacteristic, data);
        byte[] response = this.readNotificationResponse();
        int status = this.getStatusCode(response, 1);
        if (status == 11) {
            throw new RemoteDfuExtendedErrorException("Creating Command object failed", response[3]);
        }
        if (status != 1) {
            throw new RemoteDfuException("Creating Command object failed", status);
        }
    }

    private ObjectInfo selectObject(int type) throws DeviceDisconnectedException, DfuException, UploadAbortedException, RemoteDfuException, UnknownResponseException {
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to read object info: device disconnected");
        }
        SecureDfuImpl.OP_CODE_SELECT_OBJECT[1] = (byte)type;
        this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_SELECT_OBJECT);
        byte[] response = this.readNotificationResponse();
        int status = this.getStatusCode(response, 6);
        if (status == 11) {
            throw new RemoteDfuExtendedErrorException("Selecting object failed", response[3]);
        }
        if (status != 1) {
            throw new RemoteDfuException("Selecting object failed", status);
        }
        ObjectInfo info = new ObjectInfo();
        info.maxSize = this.unsignedBytesToInt(response, 3);
        info.offset = this.unsignedBytesToInt(response, 7);
        info.CRC32 = this.unsignedBytesToInt(response, 11);
        return info;
    }

    private ObjectChecksum readChecksum() throws DeviceDisconnectedException, DfuException, UploadAbortedException, RemoteDfuException, UnknownResponseException {
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to read Checksum: device disconnected");
        }
        this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_CALCULATE_CHECKSUM);
        byte[] response = this.readNotificationResponse();
        int status = this.getStatusCode(response, 3);
        if (status == 11) {
            throw new RemoteDfuExtendedErrorException("Receiving Checksum failed", response[3]);
        }
        if (status != 1) {
            throw new RemoteDfuException("Receiving Checksum failed", status);
        }
        ObjectChecksum checksum = new ObjectChecksum();
        checksum.offset = this.unsignedBytesToInt(response, 3);
        checksum.CRC32 = this.unsignedBytesToInt(response, 7);
        return checksum;
    }

    private int unsignedBytesToInt(@NonNull byte[] array, int offset) {
        return (array[offset] & 0xFF) + ((array[offset + 1] & 0xFF) << 8) + ((array[offset + 2] & 0xFF) << 16) + ((array[offset + 3] & 0xFF) << 24);
    }

    private void writeExecute() throws DfuException, DeviceDisconnectedException, UploadAbortedException, UnknownResponseException, RemoteDfuException {
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to read Checksum: device disconnected");
        }
        this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_EXECUTE);
        byte[] response = this.readNotificationResponse();
        int status = this.getStatusCode(response, 4);
        if (status == 11) {
            throw new RemoteDfuExtendedErrorException("Executing object failed", response[3]);
        }
        if (status != 1) {
            throw new RemoteDfuException("Executing object failed", status);
        }
    }

    private void writeExecute(boolean allowRetry) throws DfuException, DeviceDisconnectedException, UploadAbortedException, UnknownResponseException, RemoteDfuException {
        try {
            this.writeExecute();
        }
        catch (RemoteDfuException e) {
            if (allowRetry && e.getErrorNumber() == 5) {
                this.logw(e.getMessage() + ": " + SecureDfuError.parse(517));
                if (this.mFileType == 1) {
                    this.logw("Are you sure your new SoftDevice is API compatible with the updated one? If not, update the bootloader as well");
                }
                this.mService.sendLogBroadcast(15, String.format(Locale.US, "Remote DFU error: %s. SD busy? Retrying...", SecureDfuError.parse(517)));
                this.logi("SD busy? Retrying...");
                this.logi("Executing data object (Op Code = 4)");
                this.writeExecute();
            }
            throw e;
        }
    }

    private class ObjectChecksum {
        int offset;
        int CRC32;

        private ObjectChecksum() {
        }
    }

    private class ObjectInfo
    extends ObjectChecksum {
        int maxSize;

        private ObjectInfo() {
        }
    }

    protected class SecureBluetoothCallback
    extends BaseCustomDfuImpl.BaseCustomBluetoothCallback {
        protected SecureBluetoothCallback() {
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            if (characteristic.getValue() == null || characteristic.getValue().length < 3) {
                SecureDfuImpl.this.loge("Empty response: " + this.parse(characteristic));
                SecureDfuImpl.this.mError = 4104;
                SecureDfuImpl.this.notifyLock();
                return;
            }
            int responseType = characteristic.getIntValue(17, 0);
            if (responseType == 96) {
                int requestType = characteristic.getIntValue(17, 1);
                switch (requestType) {
                    case 3: {
                        int offset = characteristic.getIntValue(20, 3);
                        int remoteCrc = characteristic.getIntValue(20, 7);
                        int localCrc = (int)(((ArchiveInputStream)SecureDfuImpl.this.mFirmwareStream).getCrc32() & 0xFFFFFFFFL);
                        if (localCrc == remoteCrc) {
                            SecureDfuImpl.this.mProgressInfo.setBytesReceived(offset);
                        } else if (SecureDfuImpl.this.mFirmwareUploadInProgress) {
                            SecureDfuImpl.this.mFirmwareUploadInProgress = false;
                            SecureDfuImpl.this.notifyLock();
                            return;
                        }
                        this.handlePacketReceiptNotification(gatt, characteristic);
                        break;
                    }
                    default: {
                        if (SecureDfuImpl.this.mRemoteErrorOccurred) break;
                        int status = characteristic.getIntValue(17, 2);
                        if (status != 1) {
                            SecureDfuImpl.this.mRemoteErrorOccurred = true;
                        }
                        this.handleNotification(gatt, characteristic);
                        break;
                    }
                }
            } else {
                SecureDfuImpl.this.loge("Invalid response: " + this.parse(characteristic));
                SecureDfuImpl.this.mError = 4104;
            }
            SecureDfuImpl.this.notifyLock();
        }
    }
}

