/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu.internal.scanner;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import java.util.Locale;
import no.nordicsemi.android.dfu.internal.scanner.BootloaderScanner;

@TargetApi(value=21)
public class BootloaderScannerLollipop
extends ScanCallback
implements BootloaderScanner {
    private final Object mLock = new Object();
    private String mDeviceAddress;
    private String mDeviceAddressIncremented;
    private String mBootloaderAddress;
    private boolean mFound;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String searchFor(String deviceAddress) {
        String firstBytes = deviceAddress.substring(0, 15);
        String lastByte = deviceAddress.substring(15);
        String lastByteIncremented = String.format(Locale.US, "%02X", Integer.valueOf(lastByte, 16) + 1 & 0xFF);
        this.mDeviceAddress = deviceAddress;
        this.mDeviceAddressIncremented = firstBytes + lastByteIncremented;
        this.mBootloaderAddress = null;
        this.mFound = false;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (BootloaderScannerLollipop.this.mFound) {
                    return;
                }
                BootloaderScannerLollipop.this.mBootloaderAddress = null;
                BootloaderScannerLollipop.this.mFound = true;
                Object object = BootloaderScannerLollipop.this.mLock;
                synchronized (object) {
                    BootloaderScannerLollipop.this.mLock.notifyAll();
                }
            }
        }, "Scanner timer").start();
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null || adapter.getState() != 12) {
            return null;
        }
        BluetoothLeScanner scanner = adapter.getBluetoothLeScanner();
        if (scanner == null) {
            return null;
        }
        ScanSettings settings = new ScanSettings.Builder().setScanMode(2).build();
        scanner.startScan(null, settings, (ScanCallback)this);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mFound) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        scanner.stopScan((ScanCallback)this);
        return this.mBootloaderAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScanResult(int callbackType, ScanResult result) {
        String address = result.getDevice().getAddress();
        if (this.mDeviceAddress.equals(address) || this.mDeviceAddressIncremented.equals(address)) {
            this.mBootloaderAddress = address;
            this.mFound = true;
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notifyAll();
            }
        }
    }
}

