/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu.internal.scanner;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import no.nordicsemi.android.dfu.DfuDeviceSelector;
import no.nordicsemi.android.dfu.internal.scanner.BootloaderScanner;

@SuppressLint(value={"MissingPermission"})
public class BootloaderScannerJB
implements BootloaderScanner,
BluetoothAdapter.LeScanCallback {
    private final Object mLock = new Object();
    private final String mDeviceAddress;
    private final String mDeviceAddressIncremented;
    private DfuDeviceSelector mSelector;
    private String mBootloaderAddress;
    private boolean mFound;

    BootloaderScannerJB(String deviceAddress, String deviceAddressIncremented) {
        this.mDeviceAddress = deviceAddress;
        this.mDeviceAddressIncremented = deviceAddressIncremented;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String searchUsing(@NonNull DfuDeviceSelector selector, long timeout) {
        this.mSelector = selector;
        this.mBootloaderAddress = null;
        this.mFound = false;
        new Thread(() -> {
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.mFound) {
                return;
            }
            this.mBootloaderAddress = null;
            this.mFound = true;
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notifyAll();
            }
        }, "Scanner timer").start();
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null || adapter.getState() != 12) {
            return null;
        }
        adapter.startLeScan((BluetoothAdapter.LeScanCallback)this);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mFound) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        adapter.stopLeScan((BluetoothAdapter.LeScanCallback)this);
        return this.mBootloaderAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeScan(@NonNull BluetoothDevice device, int rssi, byte[] scanRecord) {
        String address = device.getAddress();
        if (!this.mFound && this.mSelector.matches(device, rssi, scanRecord, this.mDeviceAddress, this.mDeviceAddressIncremented)) {
            this.mBootloaderAddress = address;
            this.mFound = true;
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notifyAll();
            }
        }
    }
}

