/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.UUID;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.DfuCallback;
import no.nordicsemi.android.dfu.DfuProgressInfo;
import no.nordicsemi.android.dfu.DfuService;
import no.nordicsemi.android.dfu.internal.ArchiveInputStream;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;
import no.nordicsemi.android.dfu.internal.scanner.BootloaderScannerFactory;

@SuppressLint(value={"MissingPermission"})
abstract class BaseDfuImpl
implements DfuService {
    private static final String TAG = "DfuImpl";
    static final UUID GENERIC_ATTRIBUTE_SERVICE_UUID = new UUID(0x180100001000L, -9223371485494954757L);
    static final UUID SERVICE_CHANGED_UUID = new UUID(46200963207168L, -9223371485494954757L);
    static final UUID CLIENT_CHARACTERISTIC_CONFIG = new UUID(45088566677504L, -9223371485494954757L);
    static final int NOTIFICATIONS = 1;
    static final int INDICATIONS = 2;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final int MAX_PACKET_SIZE_DEFAULT = 20;
    final Object mLock = new Object();
    InputStream mFirmwareStream;
    InputStream mInitPacketStream;
    BluetoothGatt mGatt;
    int mFileType;
    boolean mPaused;
    boolean mAborted;
    boolean mConnected;
    boolean mRequestCompleted;
    boolean mResetRequestSent;
    int mError;
    byte[] mReceivedData = null;
    byte[] mBuffer = new byte[20];
    DfuBaseService mService;
    DfuProgressInfo mProgressInfo;
    int mImageSizeInBytes;
    int mInitPacketSizeInBytes;
    private int mCurrentMtu;

    BaseDfuImpl(@NonNull Intent intent, @NonNull DfuBaseService service) {
        this.mService = service;
        this.mProgressInfo = service.mProgressInfo;
        this.mConnected = true;
    }

    @Override
    public void release() {
        this.mService = null;
    }

    @Override
    public void pause() {
        this.mPaused = true;
    }

    @Override
    public void resume() {
        this.mPaused = false;
        this.notifyLock();
    }

    @Override
    public void abort() {
        this.mPaused = false;
        this.mAborted = true;
        this.notifyLock();
    }

    @Override
    public void onBondStateChanged(int state) {
        this.mRequestCompleted = true;
        this.notifyLock();
    }

    @Override
    public boolean initialize(@NonNull Intent intent, @NonNull BluetoothGatt gatt, int fileType, @NonNull InputStream firmwareStream, @Nullable InputStream initPacketStream) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        BluetoothGattCharacteristic serviceChangedCharacteristic;
        BluetoothGattService genericAttributeService;
        this.mGatt = gatt;
        this.mFileType = fileType;
        this.mFirmwareStream = firmwareStream;
        this.mInitPacketStream = initPacketStream;
        int currentPart = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_PART_CURRENT", 1);
        int totalParts = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_PARTS_TOTAL", 1);
        this.mCurrentMtu = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_CURRENT_MTU", 23);
        if (fileType > 4) {
            this.logw("DFU target does not support (SD/BL)+App update, splitting into 2 parts");
            this.mService.sendLogBroadcast(15, "Sending system components");
            this.mFileType &= 0xFFFFFFFB;
            totalParts = 2;
            ArchiveInputStream zhis = (ArchiveInputStream)this.mFirmwareStream;
            zhis.setContentType(this.mFileType);
        }
        if (currentPart == 2) {
            this.mService.sendLogBroadcast(15, "Sending application");
        }
        int size = 0;
        try {
            if (initPacketStream != null) {
                if (initPacketStream.markSupported()) {
                    initPacketStream.reset();
                }
                size = initPacketStream.available();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mInitPacketSizeInBytes = size;
        try {
            if (firmwareStream.markSupported()) {
                if (firmwareStream instanceof ArchiveInputStream) {
                    ((ArchiveInputStream)firmwareStream).fullReset();
                } else {
                    firmwareStream.reset();
                }
            }
            size = firmwareStream.available();
        }
        catch (Exception e) {
            size = 0;
        }
        this.mImageSizeInBytes = size;
        this.mProgressInfo.init(size, currentPart, totalParts);
        if (gatt.getDevice().getBondState() == 12 && (genericAttributeService = gatt.getService(GENERIC_ATTRIBUTE_SERVICE_UUID)) != null && (serviceChangedCharacteristic = genericAttributeService.getCharacteristic(SERVICE_CHANGED_UUID)) != null) {
            boolean serviceChangedIndicationsEnabled = this.isServiceChangedCCCDEnabled();
            if (!serviceChangedIndicationsEnabled) {
                this.enableCCCD(serviceChangedCharacteristic, 2);
            }
            this.logi("Service Changed indications enabled");
            this.mService.sendLogBroadcast(10, "Service Changed indications enabled");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyLock() {
        Object object = this.mLock;
        synchronized (object) {
            this.mLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitIfPaused() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableCCCD(@NonNull BluetoothGattCharacteristic characteristic, int type) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        String debugString;
        BluetoothGatt gatt = this.mGatt;
        String string2 = debugString = type == 1 ? "notifications" : "indications";
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to set " + debugString + " state: device disconnected");
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        this.mRequestCompleted = false;
        this.mReceivedData = null;
        this.mError = 0;
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG);
        this.logi("Enabling " + debugString + "...");
        this.mService.sendLogBroadcast(1, "Enabling " + debugString + " for " + characteristic.getUuid());
        this.mService.sendLogBroadcast(0, "gatt.setCharacteristicNotification(" + characteristic.getUuid() + ", true)");
        gatt.setCharacteristicNotification(characteristic, true);
        this.mService.sendLogBroadcast(0, "gatt.writeDescriptor(" + descriptor.getUuid() + (type == 1 ? ", value=0x01-00)" : ", value=0x02-00)"));
        if (Build.VERSION.SDK_INT >= 33) {
            gatt.writeDescriptor(descriptor, type == 1 ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
        } else {
            descriptor.setValue(type == 1 ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
            gatt.writeDescriptor(descriptor);
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mRequestCompleted && this.mConnected && this.mError == 0 || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to set " + debugString + " state: device disconnected");
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to set " + debugString + " state", this.mError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServiceChangedCCCDEnabled() throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to read Service Changed CCCD: device disconnected");
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        BluetoothGatt gatt = this.mGatt;
        BluetoothGattService genericAttributeService = gatt.getService(GENERIC_ATTRIBUTE_SERVICE_UUID);
        if (genericAttributeService == null) {
            return false;
        }
        BluetoothGattCharacteristic serviceChangedCharacteristic = genericAttributeService.getCharacteristic(SERVICE_CHANGED_UUID);
        if (serviceChangedCharacteristic == null) {
            return false;
        }
        BluetoothGattDescriptor descriptor = serviceChangedCharacteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG);
        if (descriptor == null) {
            return false;
        }
        this.mRequestCompleted = false;
        this.mReceivedData = null;
        this.mError = 0;
        this.logi("Reading Service Changed CCCD value...");
        this.mService.sendLogBroadcast(1, "Reading Service Changed CCCD value...");
        this.mService.sendLogBroadcast(0, "gatt.readDescriptor(" + descriptor.getUuid() + ")");
        gatt.readDescriptor(descriptor);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mRequestCompleted && this.mConnected && this.mError == 0 || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to read Service Changed CCCD: device disconnected");
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to read Service Changed CCCD", this.mError);
        }
        byte[] value = this.mReceivedData;
        return value != null && value.length == 2 && value[0] == BluetoothGattDescriptor.ENABLE_INDICATION_VALUE[0] && value[1] == BluetoothGattDescriptor.ENABLE_INDICATION_VALUE[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeOpCode(@NonNull BluetoothGattCharacteristic characteristic, @NonNull byte[] value, boolean reset) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        this.mReceivedData = null;
        this.mError = 0;
        this.mRequestCompleted = false;
        this.mResetRequestSent = reset;
        this.mService.sendLogBroadcast(1, "Writing to characteristic " + characteristic.getUuid() + ", value (0x): " + this.parse(value));
        if (Build.VERSION.SDK_INT >= 33) {
            this.mService.sendLogBroadcast(0, "gatt.writeCharacteristic(" + characteristic.getUuid() + ", value=0x" + this.parse(value) + ", WRITE_TYPE_DEFAULT)");
            this.mGatt.writeCharacteristic(characteristic, value, 2);
        } else {
            characteristic.setWriteType(2);
            characteristic.setValue(value);
            this.mService.sendLogBroadcast(0, "gatt.writeCharacteristic(" + characteristic.getUuid() + ")");
            this.mGatt.writeCharacteristic(characteristic);
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mRequestCompleted && this.mConnected && this.mError == 0 || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (!this.mResetRequestSent && !this.mConnected) {
            throw new DeviceDisconnectedException("Unable to write Op Code " + value[0] + ": device disconnected");
        }
        if (!this.mResetRequestSent && this.mError != 0) {
            throw new DfuException("Unable to write Op Code " + value[0], this.mError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createBond() {
        boolean result;
        BluetoothDevice device = this.mGatt.getDevice();
        this.mRequestCompleted = false;
        this.mService.sendLogBroadcast(1, "Starting pairing...");
        if (Build.VERSION.SDK_INT >= 19) {
            this.mService.sendLogBroadcast(0, "gatt.getDevice().createBond()");
            result = device.createBond();
        } else {
            result = this.createBondApi18(device);
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (result && !this.mRequestCompleted && !this.mAborted) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        return result;
    }

    private boolean createBondApi18(@NonNull BluetoothDevice device) {
        try {
            Method createBond = device.getClass().getMethod("createBond", new Class[0]);
            this.mService.sendLogBroadcast(0, "gatt.getDevice().createBond() (hidden)");
            return (Boolean)createBond.invoke((Object)device, new Object[0]);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while creating bond", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeBond() {
        BluetoothDevice device = this.mGatt.getDevice();
        if (device.getBondState() == 10) {
            return true;
        }
        this.mService.sendLogBroadcast(1, "Removing bond information...");
        boolean result = false;
        try {
            Method removeBond = device.getClass().getMethod("removeBond", new Class[0]);
            this.mRequestCompleted = false;
            this.mService.sendLogBroadcast(0, "gatt.getDevice().removeBond() (hidden)");
            result = (Boolean)removeBond.invoke((Object)device, new Object[0]);
            try {
                Object object = this.mLock;
                synchronized (object) {
                    while (!this.mRequestCompleted && !this.mAborted) {
                        this.mLock.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                this.loge("Sleeping interrupted", e);
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while removing bond information", (Throwable)e);
        }
        return result;
    }

    boolean isBonded() {
        BluetoothDevice device = this.mGatt.getDevice();
        return device.getBondState() == 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=21)
    void requestMtu(@IntRange(from=0L, to=517L) int mtu) throws DeviceDisconnectedException, UploadAbortedException {
        if (Build.HARDWARE.equals("ums512_25c10")) {
            if (mtu == 516) {
                this.logw("MTU request forced");
            } else {
                this.logw("MTU request disabled for this device. See https://github.com/NordicSemiconductor/Android-DFU-Library/issues/339");
                return;
            }
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        this.mRequestCompleted = false;
        this.mService.sendLogBroadcast(1, "Requesting new MTU...");
        this.mService.sendLogBroadcast(0, "gatt.requestMtu(" + mtu + ")");
        if (!this.mGatt.requestMtu(mtu)) {
            return;
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mRequestCompleted && this.mConnected && this.mError == 0 || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to read Service Changed CCCD: device disconnected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readNotificationResponse() throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (this.mReceivedData == null && this.mConnected && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to write Op Code: device disconnected");
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to write Op Code", this.mError);
        }
        return this.mReceivedData;
    }

    void restartService(@NonNull Intent intent, boolean scanForBootloader) {
        String newAddress = null;
        if (scanForBootloader) {
            long delay = intent.getLongExtra("no.nordicsemi.android.dfu.extra.EXTRA_SCAN_DELAY", 0L);
            long timeout = intent.getLongExtra("no.nordicsemi.android.dfu.extra.EXTRA_SCAN_TIMEOUT", 5000L);
            this.mService.sendLogBroadcast(1, "Scanning for the DFU Bootloader... (timeout " + timeout + " ms)");
            if (delay > 0L) {
                this.mService.waitFor(delay);
            }
            newAddress = BootloaderScannerFactory.getScanner(this.mGatt.getDevice().getAddress()).searchUsing(this.mService.getDeviceSelector(), timeout);
            this.logi("Scanning for new address finished with: " + newAddress);
            if (newAddress != null) {
                this.mService.sendLogBroadcast(5, "DFU Bootloader found with address " + newAddress);
            } else {
                this.mService.sendLogBroadcast(5, "DFU Bootloader not found. Trying the same address...");
            }
        }
        if (newAddress != null) {
            intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_ADDRESS", newAddress);
        }
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_DFU_ATTEMPT", 0);
        this.mService.startService(intent);
    }

    protected String parse(@Nullable byte[] data) {
        if (data == null) {
            return "";
        }
        int length = data.length;
        if (length == 0) {
            return "";
        }
        char[] out = new char[length * 3 - 1];
        for (int j = 0; j < length; ++j) {
            int v = data[j] & 0xFF;
            out[j * 3] = HEX_ARRAY[v >>> 4];
            out[j * 3 + 1] = HEX_ARRAY[v & 0xF];
            if (j == length - 1) continue;
            out[j * 3 + 2] = 45;
        }
        return new String(out);
    }

    void loge(String message) {
        Log.e((String)TAG, (String)message);
    }

    void loge(String message, Throwable e) {
        Log.e((String)TAG, (String)message, (Throwable)e);
    }

    void logw(String message) {
        if (DfuBaseService.DEBUG) {
            Log.w((String)TAG, (String)message);
        }
    }

    void logi(String message) {
        if (DfuBaseService.DEBUG) {
            Log.i((String)TAG, (String)message);
        }
    }

    protected class BaseBluetoothGattCallback
    extends DfuCallback.DfuGattCallback {
        protected BaseBluetoothGattCallback() {
        }

        @Override
        public void onDisconnected() {
            BaseDfuImpl.this.mConnected = false;
            BaseDfuImpl.this.notifyLock();
        }

        public void onCharacteristicChanged(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic, @NonNull byte[] value) {
        }

        public void onCharacteristicRead(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic, @NonNull byte[] value, int status) {
            if (status == 0) {
                BaseDfuImpl.this.mService.sendLogBroadcast(5, "Read Response received from " + characteristic.getUuid() + ", value (0x): " + this.parse(value));
                BaseDfuImpl.this.mReceivedData = value;
                BaseDfuImpl.this.mRequestCompleted = true;
            } else {
                BaseDfuImpl.this.loge("Characteristic read error: " + status);
                BaseDfuImpl.this.mError = 0x4000 | status;
            }
            BaseDfuImpl.this.notifyLock();
        }

        public void onDescriptorRead(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattDescriptor descriptor, int status, @NonNull byte[] value) {
            if (status == 0) {
                UUID uuid = descriptor.getUuid();
                UUID parentUuid = descriptor.getCharacteristic().getUuid();
                BaseDfuImpl.this.mReceivedData = value;
                if (CLIENT_CHARACTERISTIC_CONFIG.equals(uuid)) {
                    BaseDfuImpl.this.mService.sendLogBroadcast(5, "Read Response received from descr." + parentUuid + ", value (0x): " + this.parse(value));
                    if (SERVICE_CHANGED_UUID.equals(parentUuid)) {
                        BaseDfuImpl.this.mRequestCompleted = true;
                    } else {
                        BaseDfuImpl.this.loge("Unknown descriptor read");
                    }
                }
            } else {
                BaseDfuImpl.this.loge("Descriptor read error: " + status);
                BaseDfuImpl.this.mError = 0x4000 | status;
            }
            BaseDfuImpl.this.notifyLock();
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (status == 0) {
                UUID uuid = descriptor.getUuid();
                UUID parentUuid = descriptor.getCharacteristic().getUuid();
                if (CLIENT_CHARACTERISTIC_CONFIG.equals(uuid)) {
                    BaseDfuImpl.this.mService.sendLogBroadcast(5, "Data written to descr." + parentUuid);
                    if (SERVICE_CHANGED_UUID.equals(parentUuid)) {
                        BaseDfuImpl.this.mService.sendLogBroadcast(1, "Indications enabled for " + parentUuid);
                    } else {
                        BaseDfuImpl.this.mService.sendLogBroadcast(1, "Notifications enabled for " + parentUuid);
                    }
                }
                BaseDfuImpl.this.mRequestCompleted = true;
            } else {
                BaseDfuImpl.this.loge("Descriptor write error: " + status);
                BaseDfuImpl.this.mError = 0x4000 | status;
            }
            BaseDfuImpl.this.notifyLock();
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            if (status == 0) {
                BaseDfuImpl.this.mService.sendLogBroadcast(5, "MTU changed to: " + mtu);
                if (mtu - 3 > BaseDfuImpl.this.mBuffer.length) {
                    BaseDfuImpl.this.mBuffer = new byte[mtu - 3];
                }
                BaseDfuImpl.this.logi("MTU changed to: " + mtu);
            } else {
                BaseDfuImpl.this.logw("Changing MTU failed: " + status + " (mtu: " + mtu + ")");
                if (status == 4 && BaseDfuImpl.this.mCurrentMtu > 23 && BaseDfuImpl.this.mCurrentMtu - 3 > BaseDfuImpl.this.mBuffer.length) {
                    BaseDfuImpl.this.mBuffer = new byte[BaseDfuImpl.this.mCurrentMtu - 3];
                    BaseDfuImpl.this.logi("MTU restored to: " + BaseDfuImpl.this.mCurrentMtu);
                }
            }
            BaseDfuImpl.this.mRequestCompleted = true;
            BaseDfuImpl.this.notifyLock();
        }

        public void onPhyUpdate(BluetoothGatt gatt, int txPhy, int rxPhy, int status) {
            if (status == 0) {
                BaseDfuImpl.this.mService.sendLogBroadcast(5, "PHY updated (TX: " + this.phyToString(txPhy) + ", RX: " + this.phyToString(rxPhy) + ")");
                BaseDfuImpl.this.logi("PHY updated (TX: " + this.phyToString(txPhy) + ", RX: " + this.phyToString(rxPhy) + ")");
            } else {
                BaseDfuImpl.this.logw("Updating PHY failed: " + status + " (txPhy: " + txPhy + ", rxPhy: " + rxPhy + ")");
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            this.onCharacteristicChanged(gatt, characteristic, characteristic.getValue());
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            this.onCharacteristicRead(gatt, characteristic, characteristic.getValue(), status);
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            this.onDescriptorRead(gatt, descriptor, status, descriptor.getValue());
        }

        protected int getInt(@NonNull byte[] value, int offset) {
            return value[offset] & 0xFF | (value[offset + 1] & 0xFF) << 8 | (value[offset + 2] & 0xFF) << 16 | (value[offset + 3] & 0xFF) << 24;
        }

        protected String parse(byte[] data) {
            if (data == null) {
                return "";
            }
            int length = data.length;
            if (length == 0) {
                return "";
            }
            char[] out = new char[length * 3 - 1];
            for (int j = 0; j < length; ++j) {
                int v = data[j] & 0xFF;
                out[j * 3] = HEX_ARRAY[v >>> 4];
                out[j * 3 + 1] = HEX_ARRAY[v & 0xF];
                if (j == length - 1) continue;
                out[j * 3 + 2] = 45;
            }
            return new String(out);
        }

        private String phyToString(int phy) {
            return switch (phy) {
                case 1 -> "LE 1M";
                case 2 -> "LE 2M";
                case 3 -> "LE Coded";
                default -> "UNKNOWN (" + phy + ")";
            };
        }
    }
}

