/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.IntentService;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import no.nordicsemi.android.dfu.DfuCallback;
import no.nordicsemi.android.dfu.DfuDefaultDeviceSelector;
import no.nordicsemi.android.dfu.DfuDeviceSelector;
import no.nordicsemi.android.dfu.DfuProgressInfo;
import no.nordicsemi.android.dfu.R;
import no.nordicsemi.android.dfu.internal.ArchiveInputStream;
import no.nordicsemi.android.dfu.internal.HexInputStream;

@SuppressLint(value={"MissingPermission"})
public abstract class DfuBaseService
extends IntentService
implements DfuProgressInfo.ProgressListener {
    private static final String TAG = "DfuBaseService";
    static boolean DEBUG = false;
    public static final int NOTIFICATION_ID = 283;
    public static final String NOTIFICATION_CHANNEL_DFU = "dfu";
    public static final String EXTRA_DEVICE_ADDRESS = "no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_ADDRESS";
    public static final String EXTRA_DEVICE_NAME = "no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_NAME";
    public static final String EXTRA_DISABLE_NOTIFICATION = "no.nordicsemi.android.dfu.extra.EXTRA_DISABLE_NOTIFICATION";
    public static final String EXTRA_FOREGROUND_SERVICE = "no.nordicsemi.android.dfu.extra.EXTRA_FOREGROUND_SERVICE";
    private static final String EXTRA_RECONNECTION_ATTEMPT = "no.nordicsemi.android.dfu.extra.EXTRA_RECONNECTION_ATTEMPT";
    static final String EXTRA_DFU_ATTEMPT = "no.nordicsemi.android.dfu.extra.EXTRA_DFU_ATTEMPT";
    public static final String EXTRA_MAX_DFU_ATTEMPTS = "no.nordicsemi.android.dfu.extra.EXTRA_MAX_DFU_ATTEMPTS";
    public static final String EXTRA_RESTORE_BOND = "no.nordicsemi.android.dfu.extra.EXTRA_RESTORE_BOND";
    public static final String EXTRA_KEEP_BOND = "no.nordicsemi.android.dfu.extra.EXTRA_KEEP_BOND";
    public static final String EXTRA_FORCE_DFU = "no.nordicsemi.android.dfu.extra.EXTRA_FORCE_DFU";
    public static final String EXTRA_FORCE_SCANNING_FOR_BOOTLOADER_IN_LEGACY_DFU = "no.nordicsemi.android.dfu.extra.EXTRA_FORCE_SCANNING_FOR_BOOTLOADER_IN_LEGACY_DFU";
    public static final String EXTRA_DISABLE_RESUME = "no.nordicsemi.android.dfu.extra.EXTRA_DISABLE_RESUME";
    public static final String EXTRA_MBR_SIZE = "no.nordicsemi.android.dfu.extra.EXTRA_MBR_SIZE";
    public static final String EXTRA_MTU = "no.nordicsemi.android.dfu.extra.EXTRA_MTU";
    public static final String EXTRA_CURRENT_MTU = "no.nordicsemi.android.dfu.extra.EXTRA_CURRENT_MTU";
    public static final String EXTRA_UNSAFE_EXPERIMENTAL_BUTTONLESS_DFU = "no.nordicsemi.android.dfu.extra.EXTRA_UNSAFE_EXPERIMENTAL_BUTTONLESS_DFU";
    public static final String EXTRA_DATA_OBJECT_DELAY = "no.nordicsemi.android.dfu.extra.EXTRA_DATA_OBJECT_DELAY";
    public static final String EXTRA_PACKET_RECEIPT_NOTIFICATIONS_ENABLED = "no.nordicsemi.android.dfu.extra.EXTRA_PRN_ENABLED";
    public static final String EXTRA_PACKET_RECEIPT_NOTIFICATIONS_VALUE = "no.nordicsemi.android.dfu.extra.EXTRA_PRN_VALUE";
    public static final String EXTRA_FILE_PATH = "no.nordicsemi.android.dfu.extra.EXTRA_FILE_PATH";
    public static final String EXTRA_FILE_URI = "no.nordicsemi.android.dfu.extra.EXTRA_FILE_URI";
    public static final String EXTRA_FILE_RES_ID = "no.nordicsemi.android.dfu.extra.EXTRA_FILE_RES_ID";
    public static final String EXTRA_INIT_FILE_PATH = "no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_PATH";
    public static final String EXTRA_INIT_FILE_URI = "no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_URI";
    public static final String EXTRA_INIT_FILE_RES_ID = "no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_RES_ID";
    public static final String EXTRA_FILE_MIME_TYPE = "no.nordicsemi.android.dfu.extra.EXTRA_MIME_TYPE";
    public static final String MIME_TYPE_OCTET_STREAM = "application/octet-stream";
    public static final String MIME_TYPE_ZIP = "application/zip";
    public static final String EXTRA_FILE_TYPE = "no.nordicsemi.android.dfu.extra.EXTRA_FILE_TYPE";
    public static final int TYPE_SOFT_DEVICE = 1;
    public static final int TYPE_BOOTLOADER = 2;
    public static final int TYPE_APPLICATION = 4;
    public static final int TYPE_AUTO = 0;
    public static final String EXTRA_DATA = "no.nordicsemi.android.dfu.extra.EXTRA_DATA";
    public static final String EXTRA_PROGRESS = "no.nordicsemi.android.dfu.extra.EXTRA_PROGRESS";
    public static final String EXTRA_PART_CURRENT = "no.nordicsemi.android.dfu.extra.EXTRA_PART_CURRENT";
    public static final String EXTRA_PARTS_TOTAL = "no.nordicsemi.android.dfu.extra.EXTRA_PARTS_TOTAL";
    public static final String EXTRA_SPEED_B_PER_MS = "no.nordicsemi.android.dfu.extra.EXTRA_SPEED_B_PER_MS";
    public static final String EXTRA_AVG_SPEED_B_PER_MS = "no.nordicsemi.android.dfu.extra.EXTRA_AVG_SPEED_B_PER_MS";
    public static final String BROADCAST_PROGRESS = "no.nordicsemi.android.dfu.broadcast.BROADCAST_PROGRESS";
    public static final int PROGRESS_CONNECTING = -1;
    public static final int PROGRESS_STARTING = -2;
    public static final int PROGRESS_ENABLING_DFU_MODE = -3;
    public static final int PROGRESS_VALIDATING = -4;
    public static final int PROGRESS_DISCONNECTING = -5;
    public static final int PROGRESS_COMPLETED = -6;
    public static final int PROGRESS_ABORTED = -7;
    public static final String BROADCAST_ERROR = "no.nordicsemi.android.dfu.broadcast.BROADCAST_ERROR";
    public static final String EXTRA_ERROR_TYPE = "no.nordicsemi.android.dfu.extra.EXTRA_ERROR_TYPE";
    public static final int ERROR_TYPE_OTHER = 0;
    public static final int ERROR_TYPE_COMMUNICATION_STATE = 1;
    public static final int ERROR_TYPE_COMMUNICATION = 2;
    public static final int ERROR_TYPE_DFU_REMOTE = 3;
    public static final int ERROR_MASK = 4096;
    public static final int ERROR_DEVICE_DISCONNECTED = 4096;
    public static final int ERROR_FILE_NOT_FOUND = 4097;
    public static final int ERROR_FILE_ERROR = 4098;
    public static final int ERROR_FILE_INVALID = 4099;
    public static final int ERROR_FILE_IO_EXCEPTION = 4100;
    public static final int ERROR_SERVICE_DISCOVERY_NOT_STARTED = 4101;
    public static final int ERROR_SERVICE_NOT_FOUND = 4102;
    public static final int ERROR_INVALID_RESPONSE = 4104;
    public static final int ERROR_FILE_TYPE_UNSUPPORTED = 4105;
    public static final int ERROR_BLUETOOTH_DISABLED = 4106;
    public static final int ERROR_INIT_PACKET_REQUIRED = 4107;
    public static final int ERROR_FILE_SIZE_INVALID = 4108;
    public static final int ERROR_CRC_ERROR = 4109;
    public static final int ERROR_DEVICE_NOT_BONDED = 4110;
    public static final int ERROR_PROGRESS_LOST = 4111;
    public static final int ERROR_REMOTE_MASK = 8192;
    public static final int ERROR_REMOTE_TYPE_LEGACY = 256;
    public static final int ERROR_REMOTE_TYPE_SECURE = 512;
    public static final int ERROR_REMOTE_TYPE_SECURE_EXTENDED = 1024;
    public static final int ERROR_REMOTE_TYPE_SECURE_BUTTONLESS = 2048;
    public static final int ERROR_CONNECTION_MASK = 16384;
    public static final int ERROR_CONNECTION_STATE_MASK = 32768;
    public static final String BROADCAST_LOG = "no.nordicsemi.android.dfu.broadcast.BROADCAST_LOG";
    public static final String EXTRA_LOG_MESSAGE = "no.nordicsemi.android.dfu.extra.EXTRA_LOG_INFO";
    public static final String EXTRA_LOG_LEVEL = "no.nordicsemi.android.dfu.extra.EXTRA_LOG_LEVEL";
    public static final int LOG_LEVEL_DEBUG = 0;
    public static final int LOG_LEVEL_VERBOSE = 1;
    public static final int LOG_LEVEL_INFO = 5;
    public static final int LOG_LEVEL_APPLICATION = 10;
    public static final int LOG_LEVEL_WARNING = 15;
    public static final int LOG_LEVEL_ERROR = 20;
    public static final String BROADCAST_ACTION = "no.nordicsemi.android.dfu.broadcast.BROADCAST_ACTION";
    public static final String EXTRA_ACTION = "no.nordicsemi.android.dfu.extra.EXTRA_ACTION";
    public static final int ACTION_PAUSE = 0;
    public static final int ACTION_RESUME = 1;
    public static final int ACTION_ABORT = 2;
    public static final String EXTRA_SCAN_DELAY = "no.nordicsemi.android.dfu.extra.EXTRA_SCAN_DELAY";
    public static final String EXTRA_SCAN_TIMEOUT = "no.nordicsemi.android.dfu.extra.EXTRA_SCAN_TIMEOUT";
    public static final String EXTRA_CUSTOM_UUIDS_FOR_LEGACY_DFU = "no.nordicsemi.android.dfu.extra.EXTRA_CUSTOM_UUIDS_FOR_LEGACY_DFU";
    public static final String EXTRA_CUSTOM_UUIDS_FOR_SECURE_DFU = "no.nordicsemi.android.dfu.extra.EXTRA_CUSTOM_UUIDS_FOR_SECURE_DFU";
    public static final String EXTRA_CUSTOM_UUIDS_FOR_EXPERIMENTAL_BUTTONLESS_DFU = "no.nordicsemi.android.dfu.extra.EXTRA_CUSTOM_UUIDS_FOR_EXPERIMENTAL_BUTTONLESS_DFU";
    public static final String EXTRA_CUSTOM_UUIDS_FOR_BUTTONLESS_DFU_WITHOUT_BOND_SHARING = "no.nordicsemi.android.dfu.extra.EXTRA_CUSTOM_UUIDS_FOR_BUTTONLESS_DFU_WITHOUT_BOND_SHARING";
    public static final String EXTRA_CUSTOM_UUIDS_FOR_BUTTONLESS_DFU_WITH_BOND_SHARING = "no.nordicsemi.android.dfu.extra.EXTRA_CUSTOM_UUIDS_FOR_BUTTONLESS_DFU_WITH_BOND_SHARING";
    private final Object mLock = new Object();
    private BluetoothAdapter mBluetoothAdapter;
    private String mDeviceAddress;
    private String mDeviceName;
    private boolean mDisableNotification;
    protected int mConnectionState;
    protected static final int STATE_DISCONNECTED = 0;
    protected static final int STATE_CONNECTING = -1;
    protected static final int STATE_CONNECTED = -2;
    protected static final int STATE_CONNECTED_AND_READY = -3;
    protected static final int STATE_DISCONNECTING = -4;
    protected static final int STATE_CLOSED = -5;
    private int mError;
    private int mLastProgress = -1;
    DfuProgressInfo mProgressInfo;
    private long mLastNotificationTime;
    private boolean mAborted;
    private DfuCallback mDfuServiceImpl;
    private InputStream mFirmwareInputStream;
    private InputStream mInitFileInputStream;
    private final BroadcastReceiver mDfuActionReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int action = intent.getIntExtra(DfuBaseService.EXTRA_ACTION, 0);
            DfuBaseService.this.logi("User action received: " + action);
            switch (action) {
                case 0: {
                    DfuBaseService.this.sendLogBroadcast(15, "[Broadcast] Pause action received");
                    if (DfuBaseService.this.mDfuServiceImpl == null) break;
                    DfuBaseService.this.mDfuServiceImpl.pause();
                    break;
                }
                case 1: {
                    DfuBaseService.this.sendLogBroadcast(15, "[Broadcast] Resume action received");
                    if (DfuBaseService.this.mDfuServiceImpl == null) break;
                    DfuBaseService.this.mDfuServiceImpl.resume();
                    break;
                }
                case 2: {
                    DfuBaseService.this.sendLogBroadcast(15, "[Broadcast] Abort action received");
                    DfuBaseService.this.mAborted = true;
                    if (DfuBaseService.this.mDfuServiceImpl == null) break;
                    DfuBaseService.this.mDfuServiceImpl.abort();
                }
            }
        }
    };
    private final BroadcastReceiver mBluetoothStateBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 10);
            int previousState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", 12);
            DfuBaseService.this.logw("Action received: android.bluetooth.adapter.action.STATE_CHANGED [state: " + state + ", previous state: " + previousState + "]");
            if (previousState == 12 && (state == 13 || state == 10)) {
                DfuBaseService.this.sendLogBroadcast(15, "Bluetooth adapter disabled");
                DfuBaseService.this.mConnectionState = 0;
                if (DfuBaseService.this.mDfuServiceImpl != null) {
                    DfuBaseService.this.mDfuServiceImpl.getGattCallback().onDisconnected();
                }
                Object object = DfuBaseService.this.mLock;
                synchronized (object) {
                    DfuBaseService.this.mLock.notifyAll();
                }
            }
        }
    };
    private final BroadcastReceiver mBondStateBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (device == null || !device.getAddress().equals(DfuBaseService.this.mDeviceAddress)) {
                return;
            }
            int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
            if (bondState == 11) {
                return;
            }
            if (DfuBaseService.this.mDfuServiceImpl != null) {
                DfuBaseService.this.mDfuServiceImpl.onBondStateChanged(bondState);
            }
        }
    };
    private final BroadcastReceiver mConnectionStateBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (device == null || !device.getAddress().equals(DfuBaseService.this.mDeviceAddress)) {
                return;
            }
            String action = intent.getAction();
            DfuBaseService.this.logi("Action received: " + action);
            DfuBaseService.this.sendLogBroadcast(0, "[Broadcast] Action received: " + action);
        }
    };
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            if (status == 0) {
                if (newState == 2) {
                    DfuBaseService.this.logi("Connected to GATT server");
                    DfuBaseService.this.sendLogBroadcast(5, "Connected to " + DfuBaseService.this.mDeviceAddress);
                    DfuBaseService.this.mConnectionState = -2;
                    if (gatt.getDevice().getBondState() == 12) {
                        DfuBaseService.this.logi("Waiting 1600 ms for a possible Service Changed indication...");
                        DfuBaseService.this.waitFor(1600L);
                    }
                    DfuBaseService.this.sendLogBroadcast(1, "Discovering services...");
                    DfuBaseService.this.sendLogBroadcast(0, "gatt.discoverServices()");
                    boolean success = gatt.discoverServices();
                    DfuBaseService.this.logi("Attempting to start service discovery... " + (success ? "succeed" : "failed"));
                    if (success) return;
                    DfuBaseService.this.mError = 4101;
                } else if (newState == 0) {
                    DfuBaseService.this.logi("Disconnected from GATT server");
                    DfuBaseService.this.mConnectionState = 0;
                    if (DfuBaseService.this.mDfuServiceImpl != null) {
                        DfuBaseService.this.mDfuServiceImpl.getGattCallback().onDisconnected();
                    }
                }
            } else {
                if (status == 8 || status == 19) {
                    DfuBaseService.this.logw("Target device disconnected with status: " + status);
                } else {
                    DfuBaseService.this.loge("Connection state change error: " + status + " newState: " + newState);
                }
                DfuBaseService.this.mError = 0x8000 | status;
                if (newState == 0) {
                    DfuBaseService.this.mConnectionState = 0;
                    if (DfuBaseService.this.mDfuServiceImpl != null) {
                        DfuBaseService.this.mDfuServiceImpl.getGattCallback().onDisconnected();
                    }
                }
            }
            Object object = DfuBaseService.this.mLock;
            synchronized (object) {
                DfuBaseService.this.mLock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status == 0) {
                DfuBaseService.this.logi("Services discovered");
                DfuBaseService.this.mConnectionState = -3;
            } else {
                DfuBaseService.this.loge("Service discovery error: " + status);
                DfuBaseService.this.mError = 0x4000 | status;
            }
            Object object = DfuBaseService.this.mLock;
            synchronized (object) {
                DfuBaseService.this.mLock.notifyAll();
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (DfuBaseService.this.mDfuServiceImpl != null) {
                DfuBaseService.this.mDfuServiceImpl.getGattCallback().onCharacteristicWrite(gatt, characteristic, status);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (DfuBaseService.this.mDfuServiceImpl != null) {
                DfuBaseService.this.mDfuServiceImpl.getGattCallback().onCharacteristicRead(gatt, characteristic, status);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            if (DfuBaseService.this.mDfuServiceImpl != null) {
                DfuBaseService.this.mDfuServiceImpl.getGattCallback().onCharacteristicChanged(gatt, characteristic);
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (DfuBaseService.this.mDfuServiceImpl != null) {
                DfuBaseService.this.mDfuServiceImpl.getGattCallback().onDescriptorWrite(gatt, descriptor, status);
            }
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (DfuBaseService.this.mDfuServiceImpl != null) {
                DfuBaseService.this.mDfuServiceImpl.getGattCallback().onDescriptorRead(gatt, descriptor, status);
            }
        }

        @SuppressLint(value={"NewApi"})
        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            if (DfuBaseService.this.mDfuServiceImpl != null) {
                DfuBaseService.this.mDfuServiceImpl.getGattCallback().onMtuChanged(gatt, mtu, status);
            }
        }

        @SuppressLint(value={"NewApi"})
        public void onPhyUpdate(BluetoothGatt gatt, int txPhy, int rxPhy, int status) {
            if (DfuBaseService.this.mDfuServiceImpl != null) {
                DfuBaseService.this.mDfuServiceImpl.getGattCallback().onPhyUpdate(gatt, txPhy, rxPhy, status);
            }
        }
    };

    public DfuBaseService() {
        super(TAG);
    }

    private static IntentFilter makeDfuActionIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(BROADCAST_ACTION);
        return intentFilter;
    }

    public void onCreate() {
        super.onCreate();
        DEBUG = this.isDebug();
        this.logi("DFU service created. Version: 2.3.1");
        this.initialize();
        LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)this);
        IntentFilter actionFilter = DfuBaseService.makeDfuActionIntentFilter();
        manager.registerReceiver(this.mDfuActionReceiver, actionFilter);
        ContextCompat.registerReceiver((Context)this, (BroadcastReceiver)this.mDfuActionReceiver, (IntentFilter)actionFilter, (int)4);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        filter.addAction("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
        filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        ContextCompat.registerReceiver((Context)this, (BroadcastReceiver)this.mConnectionStateBroadcastReceiver, (IntentFilter)filter, (int)2);
        IntentFilter bondFilter = new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED");
        ContextCompat.registerReceiver((Context)this, (BroadcastReceiver)this.mBondStateBroadcastReceiver, (IntentFilter)bondFilter, (int)2);
        IntentFilter stateFilter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        ContextCompat.registerReceiver((Context)this, (BroadcastReceiver)this.mBluetoothStateBroadcastReceiver, (IntentFilter)stateFilter, (int)2);
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        if (manager != null) {
            manager.cancel(283);
        }
        this.stopSelf();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mDfuServiceImpl != null) {
            this.mDfuServiceImpl.abort();
        }
        LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)this);
        manager.unregisterReceiver(this.mDfuActionReceiver);
        this.unregisterReceiver(this.mDfuActionReceiver);
        this.unregisterReceiver(this.mConnectionStateBroadcastReceiver);
        this.unregisterReceiver(this.mBondStateBroadcastReceiver);
        this.unregisterReceiver(this.mBluetoothStateBroadcastReceiver);
        try {
            if (this.mFirmwareInputStream != null) {
                this.mFirmwareInputStream.close();
            }
            if (this.mInitFileInputStream != null) {
                this.mInitFileInputStream.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.mFirmwareInputStream = null;
            this.mInitFileInputStream = null;
        }
        this.logi("DFU service destroyed");
    }

    /*
     * Exception decompiling
     */
    protected void onHandleIntent(@Nullable Intent intent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream openInputStream(@NonNull String filePath, String mimeType, int mbrSize, int types) throws IOException {
        FileInputStream is = new FileInputStream(filePath);
        if (MIME_TYPE_ZIP.equals(mimeType)) {
            return new ArchiveInputStream(is, mbrSize, types);
        }
        if (filePath.toLowerCase(Locale.US).endsWith("hex")) {
            return new HexInputStream(is, mbrSize);
        }
        return is;
    }

    private InputStream openInputStream(@NonNull Uri stream, String mimeType, int mbrSize, int types) throws IOException {
        InputStream is;
        InputStream inputStream = is = stream.toString().startsWith("file:///android_asset/") ? this.getAssets().open(stream.getPath().substring(15)) : this.getContentResolver().openInputStream(stream);
        assert (is != null);
        if (MIME_TYPE_ZIP.equals(mimeType)) {
            return new ArchiveInputStream(is, mbrSize, types);
        }
        String[] projection = new String[]{"_display_name"};
        try (Cursor cursor = this.getContentResolver().query(stream, projection, null, null, null);){
            String fileName;
            if (cursor != null && cursor.moveToNext() && (fileName = cursor.getString(0)).toLowerCase(Locale.US).endsWith("hex")) {
                HexInputStream hexInputStream = new HexInputStream(is, mbrSize);
                return hexInputStream;
            }
        }
        return is;
    }

    private InputStream openInputStream(int resId, String mimeType, int mbrSize, int types) throws IOException {
        InputStream is = this.getResources().openRawResource(resId);
        if (MIME_TYPE_ZIP.equals(mimeType)) {
            return new ArchiveInputStream(is, mbrSize, types);
        }
        is.mark(2);
        int firstByte = is.read();
        is.reset();
        if (firstByte == 58) {
            return new HexInputStream(is, mbrSize);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BluetoothGatt connect(@NonNull String address) {
        BluetoothGatt gatt;
        if (!this.mBluetoothAdapter.isEnabled()) {
            return null;
        }
        this.mConnectionState = -1;
        this.logi("Connecting to the device...");
        BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(address);
        if (Build.VERSION.SDK_INT >= 26) {
            this.sendLogBroadcast(0, "gatt = device.connectGatt(autoConnect = false, TRANSPORT_LE, preferredPhy = LE_1M | LE_2M)");
            gatt = device.connectGatt((Context)this, false, this.mGattCallback, 2, 3);
        } else if (Build.VERSION.SDK_INT >= 23) {
            this.sendLogBroadcast(0, "gatt = device.connectGatt(autoConnect = false, TRANSPORT_LE)");
            gatt = device.connectGatt((Context)this, false, this.mGattCallback, 2);
        } else {
            this.sendLogBroadcast(0, "gatt = device.connectGatt(autoConnect = false)");
            gatt = device.connectGatt((Context)this, false, this.mGattCallback);
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!(this.mConnectionState != -1 && this.mConnectionState != -2 || this.mError != 0 || this.mAborted)) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        return gatt;
    }

    protected void terminateConnection(@NonNull BluetoothGatt gatt, int error) {
        if (this.mConnectionState != 0) {
            this.disconnect(gatt);
        }
        this.refreshDeviceCache(gatt, false);
        this.close(gatt);
        this.waitFor(600L);
        if (error != 0) {
            this.report(error);
        }
    }

    protected void disconnect(@NonNull BluetoothGatt gatt) {
        if (this.mConnectionState == 0) {
            return;
        }
        this.sendLogBroadcast(1, "Disconnecting...");
        this.mProgressInfo.setProgress(-5);
        this.logi("Disconnecting from the device...");
        this.sendLogBroadcast(0, "gatt.disconnect()");
        gatt.disconnect();
        this.waitUntilDisconnected();
        this.sendLogBroadcast(5, "Disconnected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilDisconnected() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (this.mConnectionState != 0 && this.mError == 0) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitFor(long millis) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.sendLogBroadcast(0, "wait(" + millis + ")");
                this.mLock.wait(millis);
            }
            catch (InterruptedException e) {
                this.loge("Sleeping interrupted", e);
            }
        }
    }

    protected void close(@NonNull BluetoothGatt gatt) {
        this.logi("Cleaning up...");
        this.sendLogBroadcast(0, "gatt.disconnect()");
        gatt.disconnect();
        this.sendLogBroadcast(0, "gatt.close()");
        gatt.close();
        this.mConnectionState = -5;
    }

    protected void refreshDeviceCache(@NonNull BluetoothGatt gatt, boolean force) {
        if (force || gatt.getDevice().getBondState() == 10) {
            this.sendLogBroadcast(0, "gatt.refresh() (hidden)");
            try {
                Method refresh = gatt.getClass().getMethod("refresh", new Class[0]);
                boolean success = (Boolean)refresh.invoke((Object)gatt, new Object[0]);
                this.logi("Refreshing result: " + success);
            }
            catch (Exception e) {
                this.loge("An exception occurred while refreshing device", e);
                this.sendLogBroadcast(15, "Refreshing failed");
            }
        }
    }

    @Override
    public void updateProgressNotification() {
        DfuProgressInfo info = this.mProgressInfo;
        int progress = info.getProgress();
        if (this.mLastProgress == progress) {
            return;
        }
        this.mLastProgress = progress;
        this.sendProgressBroadcast(info);
        if (this.mDisableNotification) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        if (now - this.mLastNotificationTime < 250L && -6 != progress && -7 != progress) {
            return;
        }
        this.mLastNotificationTime = now;
        String deviceAddress = this.mDeviceAddress;
        String deviceName = this.mDeviceName != null ? this.mDeviceName : this.getString(R.string.dfu_unknown_name);
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, NOTIFICATION_CHANNEL_DFU).setSmallIcon(0x1080088).setOnlyAlertOnce(true);
        builder.setColor(-7829368);
        switch (progress) {
            case -1: {
                builder.setOngoing(true).setContentTitle((CharSequence)this.getString(R.string.dfu_status_connecting)).setContentText((CharSequence)this.getString(R.string.dfu_status_connecting_msg, new Object[]{deviceName})).setProgress(100, 0, true);
                break;
            }
            case -2: {
                builder.setOngoing(true).setContentTitle((CharSequence)this.getString(R.string.dfu_status_starting)).setContentText((CharSequence)this.getString(R.string.dfu_status_starting_msg)).setProgress(100, 0, true);
                break;
            }
            case -3: {
                builder.setOngoing(true).setContentTitle((CharSequence)this.getString(R.string.dfu_status_switching_to_dfu)).setContentText((CharSequence)this.getString(R.string.dfu_status_switching_to_dfu_msg)).setProgress(100, 0, true);
                break;
            }
            case -4: {
                builder.setOngoing(true).setContentTitle((CharSequence)this.getString(R.string.dfu_status_validating)).setContentText((CharSequence)this.getString(R.string.dfu_status_validating_msg)).setProgress(100, 0, true);
                break;
            }
            case -5: {
                builder.setOngoing(true).setContentTitle((CharSequence)this.getString(R.string.dfu_status_disconnecting)).setContentText((CharSequence)this.getString(R.string.dfu_status_disconnecting_msg, new Object[]{deviceName})).setProgress(100, 0, true);
                break;
            }
            case -6: {
                builder.setOngoing(false).setContentTitle((CharSequence)this.getString(R.string.dfu_status_completed)).setSmallIcon(17301641).setContentText((CharSequence)this.getString(R.string.dfu_status_completed_msg)).setAutoCancel(true).setColor(-16730086);
                break;
            }
            case -7: {
                builder.setOngoing(false).setContentTitle((CharSequence)this.getString(R.string.dfu_status_aborted)).setSmallIcon(17301641).setContentText((CharSequence)this.getString(R.string.dfu_status_aborted_msg)).setAutoCancel(true);
                break;
            }
            default: {
                String title = info.getTotalParts() == 1 ? this.getString(R.string.dfu_status_uploading) : this.getString(R.string.dfu_status_uploading_part, new Object[]{info.getCurrentPart(), info.getTotalParts()});
                String text = this.getString(R.string.dfu_status_uploading_msg, new Object[]{deviceName});
                builder.setOngoing(true).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setProgress(100, progress, false);
            }
        }
        Intent intent = new Intent((Context)this, this.getNotificationTarget());
        intent.addFlags(0x10000000);
        intent.putExtra(EXTRA_DEVICE_ADDRESS, deviceAddress);
        intent.putExtra(EXTRA_DEVICE_NAME, deviceName);
        intent.putExtra(EXTRA_PROGRESS, progress);
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)flags);
        builder.setContentIntent(pendingIntent);
        this.updateProgressNotification(builder, progress);
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        if (manager != null) {
            manager.notify(283, builder.build());
        }
    }

    protected void updateProgressNotification(@NonNull NotificationCompat.Builder builder, int progress) {
        if (progress != -7 && progress != -6) {
            Intent abortIntent = new Intent(BROADCAST_ACTION);
            abortIntent.putExtra(EXTRA_ACTION, 2);
            int flags = 0x8000000;
            if (Build.VERSION.SDK_INT >= 23) {
                flags |= 0x4000000;
            }
            PendingIntent pendingAbortIntent = PendingIntent.getBroadcast((Context)this, (int)1, (Intent)abortIntent, (int)flags);
            builder.addAction(R.drawable.ic_action_notify_cancel, (CharSequence)this.getString(R.string.dfu_action_abort), pendingAbortIntent);
        }
    }

    private void report(int error) {
        this.sendErrorBroadcast(error);
        if (this.mDisableNotification) {
            return;
        }
        String deviceAddress = this.mDeviceAddress;
        String deviceName = this.mDeviceName != null ? this.mDeviceName : this.getString(R.string.dfu_unknown_name);
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, NOTIFICATION_CHANNEL_DFU).setSmallIcon(0x1080088).setOnlyAlertOnce(true).setColor(-65536).setOngoing(false).setContentTitle((CharSequence)this.getString(R.string.dfu_status_error)).setSmallIcon(17301641).setContentText((CharSequence)this.getString(R.string.dfu_status_error_msg)).setAutoCancel(true);
        Intent intent = new Intent((Context)this, this.getNotificationTarget());
        intent.addFlags(0x10000000);
        intent.putExtra(EXTRA_DEVICE_ADDRESS, deviceAddress);
        intent.putExtra(EXTRA_DEVICE_NAME, deviceName);
        intent.putExtra(EXTRA_PROGRESS, error);
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)flags);
        builder.setContentIntent(pendingIntent);
        this.updateErrorNotification(builder);
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        if (manager != null) {
            manager.notify(283, builder.build());
        }
    }

    protected void updateErrorNotification(@NonNull NotificationCompat.Builder builder) {
    }

    private void startForeground() {
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, NOTIFICATION_CHANNEL_DFU).setSmallIcon(0x1080088).setContentTitle((CharSequence)this.getString(R.string.dfu_status_foreground_title)).setContentText((CharSequence)this.getString(R.string.dfu_status_foreground_content)).setColor(-7829368).setPriority(-1).setOngoing(true);
        Class<? extends Activity> clazz = this.getNotificationTarget();
        if (clazz != null) {
            Intent targetIntent = new Intent((Context)this, clazz);
            targetIntent.addFlags(0x10000000);
            targetIntent.putExtra(EXTRA_DEVICE_ADDRESS, this.mDeviceAddress);
            targetIntent.putExtra(EXTRA_DEVICE_NAME, this.mDeviceName);
            int flags = 0x8000000;
            if (Build.VERSION.SDK_INT >= 23) {
                flags |= 0x4000000;
            }
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)targetIntent, (int)flags);
            builder.setContentIntent(pendingIntent);
        } else {
            this.logw("getNotificationTarget() should not return null if the service is to be started as a foreground service");
        }
        this.updateForegroundNotification(builder);
        this.startForeground(283, builder.build());
    }

    protected void updateForegroundNotification(@NonNull NotificationCompat.Builder builder) {
    }

    @Nullable
    protected abstract Class<? extends Activity> getNotificationTarget();

    @NonNull
    protected DfuDeviceSelector getDeviceSelector() {
        return new DfuDefaultDeviceSelector();
    }

    protected boolean isDebug() {
        return false;
    }

    private void sendProgressBroadcast(DfuProgressInfo info) {
        Intent broadcast = new Intent(BROADCAST_PROGRESS);
        broadcast.putExtra(EXTRA_DATA, info.getProgress());
        broadcast.putExtra(EXTRA_DEVICE_ADDRESS, this.mDeviceAddress);
        broadcast.putExtra(EXTRA_PART_CURRENT, info.getCurrentPart());
        broadcast.putExtra(EXTRA_PARTS_TOTAL, info.getTotalParts());
        broadcast.putExtra(EXTRA_SPEED_B_PER_MS, info.getSpeed());
        broadcast.putExtra(EXTRA_AVG_SPEED_B_PER_MS, info.getAverageSpeed());
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(broadcast);
    }

    private void sendErrorBroadcast(int error) {
        Intent broadcast = new Intent(BROADCAST_ERROR);
        if ((error & 0x4000) > 0) {
            broadcast.putExtra(EXTRA_DATA, error & 0xFFFFBFFF);
            broadcast.putExtra(EXTRA_ERROR_TYPE, 2);
        } else if ((error & 0x8000) > 0) {
            broadcast.putExtra(EXTRA_DATA, error & 0xFFFF7FFF);
            broadcast.putExtra(EXTRA_ERROR_TYPE, 1);
        } else if ((error & 0x2000) > 0) {
            broadcast.putExtra(EXTRA_DATA, error & 0xFFFFDFFF);
            broadcast.putExtra(EXTRA_ERROR_TYPE, 3);
        } else {
            broadcast.putExtra(EXTRA_DATA, error);
            broadcast.putExtra(EXTRA_ERROR_TYPE, 0);
        }
        broadcast.putExtra(EXTRA_DEVICE_ADDRESS, this.mDeviceAddress);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(broadcast);
    }

    void sendLogBroadcast(int level, String message) {
        String fullMessage = "[DFU] " + message;
        Intent broadcast = new Intent(BROADCAST_LOG);
        broadcast.putExtra(EXTRA_LOG_MESSAGE, fullMessage);
        broadcast.putExtra(EXTRA_LOG_LEVEL, level);
        broadcast.putExtra(EXTRA_DEVICE_ADDRESS, this.mDeviceAddress);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(broadcast);
    }

    private boolean initialize() {
        BluetoothManager bluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
        if (bluetoothManager == null) {
            this.loge("Unable to initialize BluetoothManager.");
            return false;
        }
        this.mBluetoothAdapter = bluetoothManager.getAdapter();
        if (this.mBluetoothAdapter == null) {
            this.loge("Unable to obtain a BluetoothAdapter.");
            return false;
        }
        return true;
    }

    private void loge(String message) {
        Log.e((String)TAG, (String)message);
    }

    private void loge(String message, Throwable e) {
        Log.e((String)TAG, (String)message, (Throwable)e);
    }

    private void logw(String message) {
        if (DEBUG) {
            Log.w((String)TAG, (String)message);
        }
    }

    private void logi(String message) {
        if (DEBUG) {
            Log.i((String)TAG, (String)message);
        }
    }
}

