/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.error;

public final class SecureDfuError {
    public static final int OP_CODE_NOT_SUPPORTED = 2;
    public static final int INVALID_PARAM = 3;
    public static final int INSUFFICIENT_RESOURCES = 4;
    public static final int INVALID_OBJECT = 5;
    public static final int UNSUPPORTED_TYPE = 7;
    public static final int OPERATION_NOT_PERMITTED = 8;
    public static final int OPERATION_FAILED = 10;
    public static final int EXTENDED_ERROR = 11;
    public static final int EXT_ERROR_WRONG_COMMAND_FORMAT = 2;
    public static final int EXT_ERROR_UNKNOWN_COMMAND = 3;
    public static final int EXT_ERROR_INIT_COMMAND_INVALID = 4;
    public static final int EXT_ERROR_FW_VERSION_FAILURE = 5;
    public static final int EXT_ERROR_HW_VERSION_FAILURE = 6;
    public static final int EXT_ERROR_SD_VERSION_FAILURE = 7;
    public static final int EXT_ERROR_SIGNATURE_MISSING = 8;
    public static final int EXT_ERROR_WRONG_HASH_TYPE = 9;
    public static final int EXT_ERROR_HASH_FAILED = 10;
    public static final int EXT_ERROR_WRONG_SIGNATURE_TYPE = 11;
    public static final int EXT_ERROR_VERIFICATION_FAILED = 12;
    public static final int EXT_ERROR_INSUFFICIENT_SPACE = 13;
    public static final int BUTTONLESS_ERROR_OP_CODE_NOT_SUPPORTED = 2;
    public static final int BUTTONLESS_ERROR_OPERATION_FAILED = 4;

    public static String parse(int error) {
        return switch (error) {
            case 514 -> "OP CODE NOT SUPPORTED";
            case 515 -> "INVALID PARAM";
            case 516 -> "INSUFFICIENT RESOURCES";
            case 517 -> "INVALID OBJECT";
            case 519 -> "UNSUPPORTED TYPE";
            case 520 -> "OPERATION NOT PERMITTED";
            case 522 -> "OPERATION FAILED";
            case 523 -> "EXTENDED ERROR";
            default -> "UNKNOWN (" + error + ")";
        };
    }

    public static String parseExtendedError(int error) {
        return switch (error) {
            case 1026 -> "Wrong command format";
            case 1027 -> "Unknown command";
            case 1028 -> "Init command invalid";
            case 1029 -> "FW version failure";
            case 1030 -> "HW version failure";
            case 1031 -> "SD version failure";
            case 1032 -> "Signature mismatch";
            case 1033 -> "Wrong hash type";
            case 1034 -> "Hash failed";
            case 1035 -> "Wrong signature type";
            case 1036 -> "Verification failed";
            case 1037 -> "Insufficient space";
            default -> "Reserved for future use";
        };
    }

    public static String parseButtonlessError(int error) {
        return switch (error) {
            case 2050 -> "OP CODE NOT SUPPORTED";
            case 2052 -> "OPERATION FAILED";
            default -> "UNKNOWN (" + error + ")";
        };
    }
}

