/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;
import androidx.annotation.NonNull;
import java.io.IOException;
import java.util.UUID;
import java.util.zip.CRC32;
import no.nordicsemi.android.dfu.BaseDfuImpl;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.HexFileValidationException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;

@SuppressLint(value={"MissingPermission"})
abstract class BaseCustomDfuImpl
extends BaseDfuImpl {
    private boolean mInitPacketInProgress;
    boolean mFirmwareUploadInProgress;
    int mPacketsBeforeNotification;
    private int mPacketsSentSinceNotification;
    boolean mRemoteErrorOccurred;

    BaseCustomDfuImpl(@NonNull Intent intent, DfuBaseService service) {
        super(intent, service);
        if (intent.hasExtra("no.nordicsemi.android.dfu.extra.EXTRA_PRN_ENABLED")) {
            boolean packetReceiptNotificationEnabled = intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_PRN_ENABLED", Build.VERSION.SDK_INT < 23);
            int numberOfPackets = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_PRN_VALUE", 12);
            if (numberOfPackets < 0 || numberOfPackets > 65535) {
                numberOfPackets = 12;
            }
            if (!packetReceiptNotificationEnabled) {
                numberOfPackets = 0;
            }
            this.mPacketsBeforeNotification = numberOfPackets;
        } else {
            int numberOfPackets;
            SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)service);
            boolean packetReceiptNotificationEnabled = preferences.getBoolean("settings_packet_receipt_notification_enabled", Build.VERSION.SDK_INT < 23);
            String value = preferences.getString("settings_number_of_packets", String.valueOf(12));
            try {
                numberOfPackets = Integer.parseInt(value);
                if (numberOfPackets < 0 || numberOfPackets > 65535) {
                    numberOfPackets = 12;
                }
            }
            catch (NumberFormatException e) {
                numberOfPackets = 12;
            }
            if (!packetReceiptNotificationEnabled) {
                numberOfPackets = 0;
            }
            this.mPacketsBeforeNotification = numberOfPackets;
        }
    }

    protected abstract UUID getControlPointCharacteristicUUID();

    protected abstract UUID getPacketCharacteristicUUID();

    protected abstract UUID getDfuServiceUUID();

    void writeInitData(BluetoothGattCharacteristic characteristic, CRC32 crc32) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        try {
            int size;
            byte[] data = this.mBuffer;
            while ((size = this.mInitPacketStream.read(data, 0, data.length)) != -1) {
                this.writeInitPacket(characteristic, data, size);
                if (crc32 == null) continue;
                crc32.update(data, 0, size);
            }
        }
        catch (IOException e) {
            this.loge("Error while reading Init packet file", e);
            throw new DfuException("Error while reading Init packet file", 4098);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInitPacket(BluetoothGattCharacteristic characteristic, byte[] buffer, int size) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        byte[] locBuffer = buffer;
        if (buffer.length != size) {
            locBuffer = new byte[size];
            System.arraycopy(buffer, 0, locBuffer, 0, size);
        }
        this.mReceivedData = null;
        this.mError = 0;
        this.mInitPacketInProgress = true;
        this.logi("Sending init packet (size: " + locBuffer.length + ", value: 0x" + this.parse(locBuffer) + ")");
        this.mService.sendLogBroadcast(1, "Writing to characteristic " + characteristic.getUuid() + " value (0x): " + this.parse(locBuffer));
        if (Build.VERSION.SDK_INT >= 33) {
            this.mService.sendLogBroadcast(0, "gatt.writeCharacteristic(" + characteristic.getUuid() + ", value=0x" + this.parse(locBuffer) + ", WRITE_TYPE_NO_RESPONSE)");
            this.mGatt.writeCharacteristic(characteristic, locBuffer, 1);
        } else {
            characteristic.setWriteType(1);
            characteristic.setValue(locBuffer);
            this.mService.sendLogBroadcast(0, "gatt.writeCharacteristic(" + characteristic.getUuid() + ")");
            this.mGatt.writeCharacteristic(characteristic);
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (this.mInitPacketInProgress && this.mConnected && this.mError == 0 || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to write Init DFU Parameters: device disconnected");
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to write Init DFU Parameters", this.mError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uploadFirmwareImage(BluetoothGattCharacteristic packetCharacteristic) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        this.mReceivedData = null;
        this.mError = 0;
        this.mFirmwareUploadInProgress = true;
        this.mPacketsSentSinceNotification = 0;
        try {
            int available = this.mProgressInfo.getAvailableObjectSizeIsBytes();
            byte[] buffer = this.mBuffer;
            if (available < buffer.length) {
                buffer = new byte[available];
            }
            int size = this.mFirmwareStream.read(buffer);
            this.mService.sendLogBroadcast(1, "Sending firmware to characteristic " + packetCharacteristic.getUuid() + "...");
            this.writePacket(this.mGatt, packetCharacteristic, buffer, size);
        }
        catch (HexFileValidationException e) {
            throw new DfuException("HEX file not valid", 4099);
        }
        catch (IOException e) {
            throw new DfuException("Error while reading file", 4100);
        }
        try {
            Object e = this.mLock;
            synchronized (e) {
                while (this.mFirmwareUploadInProgress && this.mReceivedData == null && this.mConnected && this.mError == 0 || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Uploading Firmware Image failed: device disconnected");
        }
        if (this.mError != 0) {
            throw new DfuException("Uploading Firmware Image failed", this.mError);
        }
    }

    private void writePacket(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, byte[] buffer, int size) {
        byte[] locBuffer = buffer;
        if (size <= 0) {
            return;
        }
        if (buffer.length != size) {
            locBuffer = new byte[size];
            System.arraycopy(buffer, 0, locBuffer, 0, size);
        }
        this.mProgressInfo.addBytesSent(size);
        if (Build.VERSION.SDK_INT >= 33) {
            gatt.writeCharacteristic(characteristic, locBuffer, 1);
        } else {
            characteristic.setWriteType(1);
            characteristic.setValue(locBuffer);
            gatt.writeCharacteristic(characteristic);
        }
    }

    void finalize(Intent intent, boolean forceRefresh) {
        boolean keepBond = intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_KEEP_BOND", false);
        this.mService.refreshDeviceCache(this.mGatt, forceRefresh || !keepBond);
        this.mService.close(this.mGatt);
        if (this.mGatt.getDevice().getBondState() == 12) {
            boolean restoreBond = intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_RESTORE_BOND", false);
            if (restoreBond || !keepBond) {
                this.removeBond();
                this.mService.waitFor(2000L);
            }
            if (restoreBond && (this.mFileType & 4) > 0 && !this.createBond()) {
                this.logw("Creating bond failed");
            }
        }
        if (this.mProgressInfo.isLastPart()) {
            this.mProgressInfo.setProgress(-6);
        } else {
            this.logi("Starting service that will upload application");
            Intent newIntent = new Intent();
            newIntent.fillIn(intent, 24);
            newIntent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_MIME_TYPE", "application/zip");
            newIntent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FILE_TYPE", 4);
            newIntent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_PART_CURRENT", this.mProgressInfo.getCurrentPart() + 1);
            newIntent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_PARTS_TOTAL", this.mProgressInfo.getTotalParts());
            this.restartService(newIntent, true);
        }
    }

    class BaseCustomBluetoothCallback
    extends BaseDfuImpl.BaseBluetoothGattCallback {
        BaseCustomBluetoothCallback() {
            super(BaseCustomDfuImpl.this);
        }

        protected void onPacketCharacteristicWrite() {
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0) {
                UUID uuid = characteristic.getUuid();
                if (uuid.equals(BaseCustomDfuImpl.this.getPacketCharacteristicUUID())) {
                    if (BaseCustomDfuImpl.this.mInitPacketInProgress) {
                        BaseCustomDfuImpl.this.mService.sendLogBroadcast(5, "Data written to " + uuid);
                        BaseCustomDfuImpl.this.mInitPacketInProgress = false;
                    } else if (BaseCustomDfuImpl.this.mFirmwareUploadInProgress) {
                        ++BaseCustomDfuImpl.this.mPacketsSentSinceNotification;
                        boolean notificationExpected = BaseCustomDfuImpl.this.mPacketsBeforeNotification > 0 && BaseCustomDfuImpl.this.mPacketsSentSinceNotification >= BaseCustomDfuImpl.this.mPacketsBeforeNotification;
                        boolean lastPacketTransferred = BaseCustomDfuImpl.this.mProgressInfo.isComplete();
                        boolean lastObjectPacketTransferred = BaseCustomDfuImpl.this.mProgressInfo.isObjectComplete();
                        if (notificationExpected) {
                            return;
                        }
                        if (lastPacketTransferred || lastObjectPacketTransferred) {
                            BaseCustomDfuImpl.this.mFirmwareUploadInProgress = false;
                            BaseCustomDfuImpl.this.notifyLock();
                            return;
                        }
                        try {
                            byte[] buffer;
                            BaseCustomDfuImpl.this.waitIfPaused();
                            if (BaseCustomDfuImpl.this.mAborted || BaseCustomDfuImpl.this.mError != 0 || BaseCustomDfuImpl.this.mRemoteErrorOccurred || BaseCustomDfuImpl.this.mResetRequestSent) {
                                BaseCustomDfuImpl.this.mFirmwareUploadInProgress = false;
                                BaseCustomDfuImpl.this.mService.sendLogBroadcast(15, "Upload terminated");
                                BaseCustomDfuImpl.this.notifyLock();
                                return;
                            }
                            int available = BaseCustomDfuImpl.this.mProgressInfo.getAvailableObjectSizeIsBytes();
                            if (available < (buffer = BaseCustomDfuImpl.this.mBuffer).length) {
                                buffer = new byte[available];
                            }
                            int size = BaseCustomDfuImpl.this.mFirmwareStream.read(buffer);
                            BaseCustomDfuImpl.this.writePacket(gatt, characteristic, buffer, size);
                            return;
                        }
                        catch (HexFileValidationException e) {
                            BaseCustomDfuImpl.this.loge("Invalid HEX file");
                            BaseCustomDfuImpl.this.mError = 4099;
                        }
                        catch (IOException e) {
                            BaseCustomDfuImpl.this.loge("Error while reading the input stream", e);
                            BaseCustomDfuImpl.this.mError = 4100;
                        }
                    } else {
                        BaseCustomDfuImpl.this.mService.sendLogBroadcast(5, "Data written to " + uuid);
                        this.onPacketCharacteristicWrite();
                    }
                } else {
                    BaseCustomDfuImpl.this.mService.sendLogBroadcast(5, "Data written to " + uuid);
                    BaseCustomDfuImpl.this.mRequestCompleted = true;
                }
            } else if (BaseCustomDfuImpl.this.mResetRequestSent) {
                BaseCustomDfuImpl.this.mRequestCompleted = true;
            } else {
                BaseCustomDfuImpl.this.loge("Characteristic write error: " + status);
                BaseCustomDfuImpl.this.mError = 0x4000 | status;
            }
            BaseCustomDfuImpl.this.notifyLock();
        }

        void handlePacketReceiptNotification(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, byte[] value) {
            if (!BaseCustomDfuImpl.this.mFirmwareUploadInProgress) {
                this.handleNotification(gatt, characteristic, value);
                return;
            }
            BluetoothGattCharacteristic packetCharacteristic = gatt.getService(BaseCustomDfuImpl.this.getDfuServiceUUID()).getCharacteristic(BaseCustomDfuImpl.this.getPacketCharacteristicUUID());
            try {
                byte[] buffer;
                BaseCustomDfuImpl.this.mPacketsSentSinceNotification = 0;
                BaseCustomDfuImpl.this.waitIfPaused();
                if (BaseCustomDfuImpl.this.mAborted || BaseCustomDfuImpl.this.mError != 0 || BaseCustomDfuImpl.this.mRemoteErrorOccurred || BaseCustomDfuImpl.this.mResetRequestSent) {
                    BaseCustomDfuImpl.this.mFirmwareUploadInProgress = false;
                    BaseCustomDfuImpl.this.mService.sendLogBroadcast(15, "Upload terminated");
                    return;
                }
                boolean lastPacketTransferred = BaseCustomDfuImpl.this.mProgressInfo.isComplete();
                boolean lastObjectPacketTransferred = BaseCustomDfuImpl.this.mProgressInfo.isObjectComplete();
                if (lastPacketTransferred || lastObjectPacketTransferred) {
                    BaseCustomDfuImpl.this.mFirmwareUploadInProgress = false;
                    BaseCustomDfuImpl.this.notifyLock();
                    return;
                }
                int available = BaseCustomDfuImpl.this.mProgressInfo.getAvailableObjectSizeIsBytes();
                if (available < (buffer = BaseCustomDfuImpl.this.mBuffer).length) {
                    buffer = new byte[available];
                }
                int size = BaseCustomDfuImpl.this.mFirmwareStream.read(buffer);
                BaseCustomDfuImpl.this.writePacket(gatt, packetCharacteristic, buffer, size);
            }
            catch (HexFileValidationException e) {
                BaseCustomDfuImpl.this.loge("Invalid HEX file");
                BaseCustomDfuImpl.this.mError = 4099;
            }
            catch (IOException e) {
                BaseCustomDfuImpl.this.loge("Error while reading the input stream", e);
                BaseCustomDfuImpl.this.mError = 4100;
            }
        }

        void handleNotification(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, byte[] value) {
            BaseCustomDfuImpl.this.mService.sendLogBroadcast(5, "Notification received from " + characteristic.getUuid() + ", value (0x): " + this.parse(value));
            BaseCustomDfuImpl.this.mReceivedData = value;
            BaseCustomDfuImpl.this.mFirmwareUploadInProgress = false;
        }
    }
}

