/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.bluetooth.BluetoothGatt;
import android.content.Intent;
import androidx.annotation.NonNull;
import no.nordicsemi.android.dfu.BaseDfuImpl;
import no.nordicsemi.android.dfu.ButtonlessDfuWithBondSharingImpl;
import no.nordicsemi.android.dfu.ButtonlessDfuWithoutBondSharingImpl;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.DfuCallback;
import no.nordicsemi.android.dfu.DfuService;
import no.nordicsemi.android.dfu.ExperimentalButtonlessDfuImpl;
import no.nordicsemi.android.dfu.LegacyButtonlessDfuImpl;
import no.nordicsemi.android.dfu.LegacyDfuImpl;
import no.nordicsemi.android.dfu.SecureDfuImpl;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;

class DfuServiceProvider
implements DfuCallback {
    private BaseDfuImpl mImpl;
    private boolean mPaused;
    private boolean mAborted;

    DfuServiceProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DfuService getServiceImpl(@NonNull Intent intent, @NonNull DfuBaseService service, @NonNull BluetoothGatt gatt) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        try {
            this.mImpl = new ButtonlessDfuWithBondSharingImpl(intent, service);
            if (this.mImpl.isClientCompatible(intent, gatt)) {
                BaseDfuImpl baseDfuImpl = this.mImpl;
                return baseDfuImpl;
            }
            this.mImpl = new ButtonlessDfuWithoutBondSharingImpl(intent, service);
            if (this.mImpl.isClientCompatible(intent, gatt)) {
                BaseDfuImpl baseDfuImpl = this.mImpl;
                return baseDfuImpl;
            }
            this.mImpl = new SecureDfuImpl(intent, service);
            if (this.mImpl.isClientCompatible(intent, gatt)) {
                BaseDfuImpl baseDfuImpl = this.mImpl;
                return baseDfuImpl;
            }
            this.mImpl = new LegacyButtonlessDfuImpl(intent, service);
            if (this.mImpl.isClientCompatible(intent, gatt)) {
                BaseDfuImpl baseDfuImpl = this.mImpl;
                return baseDfuImpl;
            }
            this.mImpl = new LegacyDfuImpl(intent, service);
            if (this.mImpl.isClientCompatible(intent, gatt)) {
                BaseDfuImpl baseDfuImpl = this.mImpl;
                return baseDfuImpl;
            }
            boolean enableUnsafeExperimentalButtonlessDfuService = intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_UNSAFE_EXPERIMENTAL_BUTTONLESS_DFU", false);
            if (enableUnsafeExperimentalButtonlessDfuService) {
                this.mImpl = new ExperimentalButtonlessDfuImpl(intent, service);
                if (this.mImpl.isClientCompatible(intent, gatt)) {
                    BaseDfuImpl baseDfuImpl = this.mImpl;
                    return baseDfuImpl;
                }
            }
            DfuService dfuService = null;
            return dfuService;
        }
        finally {
            if (this.mImpl != null) {
                if (this.mPaused) {
                    this.mImpl.pause();
                }
                if (this.mAborted) {
                    this.mImpl.abort();
                }
            }
        }
    }

    @Override
    public DfuCallback.DfuGattCallback getGattCallback() {
        return this.mImpl != null ? this.mImpl.getGattCallback() : null;
    }

    @Override
    public void onBondStateChanged(int state) {
        if (this.mImpl != null) {
            this.mImpl.onBondStateChanged(state);
        }
    }

    @Override
    public void pause() {
        this.mPaused = true;
    }

    @Override
    public void resume() {
        this.mPaused = false;
    }

    @Override
    public void abort() {
        this.mAborted = true;
        if (this.mImpl != null) {
            this.mImpl.abort();
        }
    }
}

