/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu.internal.scanner;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import no.nordicsemi.android.dfu.DfuDeviceSelector;
import no.nordicsemi.android.dfu.internal.scanner.BootloaderScanner;

@SuppressLint(value={"MissingPermission"})
@TargetApi(value=21)
class BootloaderScannerLollipop
extends ScanCallback
implements BootloaderScanner {
    private final Object mLock = new Object();
    private final String mDeviceAddress;
    private final String mDeviceAddressIncremented;
    private DfuDeviceSelector mSelector;
    private String mBootloaderAddress;
    private boolean mFound;

    BootloaderScannerLollipop(String deviceAddress, String deviceAddressIncremented) {
        this.mDeviceAddress = deviceAddress;
        this.mDeviceAddressIncremented = deviceAddressIncremented;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String searchUsing(@NonNull DfuDeviceSelector selector, long timeout) {
        this.mSelector = selector;
        this.mBootloaderAddress = null;
        this.mFound = false;
        new Thread(() -> {
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.mFound) {
                return;
            }
            this.mBootloaderAddress = null;
            this.mFound = true;
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notifyAll();
            }
        }, "Scanner timer").start();
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null || adapter.getState() != 12) {
            return null;
        }
        BluetoothLeScanner scanner = adapter.getBluetoothLeScanner();
        if (scanner == null) {
            return null;
        }
        ScanSettings settings = new ScanSettings.Builder().setScanMode(2).build();
        if (adapter.isOffloadedFilteringSupported() && Build.VERSION.SDK_INT >= 27) {
            ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
            filters.add(new ScanFilter.Builder().build());
            scanner.startScan(filters, settings, (ScanCallback)this);
        } else {
            scanner.startScan(null, settings, (ScanCallback)this);
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mFound) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        scanner.stopScan((ScanCallback)this);
        return this.mBootloaderAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScanResult(int callbackType, ScanResult result) {
        String address = result.getDevice().getAddress();
        if (!this.mFound && this.mSelector.matches(result.getDevice(), result.getRssi(), result.getScanRecord().getBytes(), this.mDeviceAddress, this.mDeviceAddressIncremented)) {
            this.mBootloaderAddress = address;
            this.mFound = true;
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notifyAll();
            }
        }
    }
}

