/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.error;

import no.nordicsemi.android.error.LegacyDfuError;
import no.nordicsemi.android.error.SecureDfuError;

public class GattError {
    public static String parseConnectionError(int error) {
        return switch (error) {
            case 0 -> "SUCCESS";
            case 1 -> "GATT CONN L2C FAILURE";
            case 8 -> "GATT CONN TIMEOUT";
            case 19 -> "GATT CONN TERMINATE PEER USER";
            case 22 -> "GATT CONN TERMINATE LOCAL HOST";
            case 62 -> "GATT CONN FAIL ESTABLISH";
            case 34 -> "GATT CONN LMP TIMEOUT";
            case 256 -> "GATT CONN CANCEL ";
            case 133 -> "GATT ERROR";
            default -> "UNKNOWN (" + error + ")";
        };
    }

    public static String parse(int error) {
        return switch (error) {
            case 1 -> "GATT INVALID HANDLE";
            case 2 -> "GATT READ NOT PERMIT";
            case 3 -> "GATT WRITE NOT PERMIT";
            case 4 -> "GATT INVALID PDU";
            case 5 -> "GATT INSUF AUTHENTICATION";
            case 6 -> "GATT REQ NOT SUPPORTED";
            case 7 -> "GATT INVALID OFFSET";
            case 8 -> "GATT INSUF AUTHORIZATION";
            case 9 -> "GATT PREPARE Q FULL";
            case 10 -> "GATT NOT FOUND";
            case 11 -> "GATT NOT LONG";
            case 12 -> "GATT INSUF KEY SIZE";
            case 13 -> "GATT INVALID ATTR LEN";
            case 14 -> "GATT ERR UNLIKELY";
            case 15 -> "GATT INSUF ENCRYPTION";
            case 16 -> "GATT UNSUPPORT GRP TYPE";
            case 17 -> "GATT INSUF RESOURCE";
            case 26 -> "HCI ERROR UNSUPPORTED REMOTE FEATURE";
            case 30 -> "HCI ERROR INVALID LMP PARAM";
            case 34 -> "GATT CONN LMP TIMEOUT";
            case 42 -> "HCI ERROR DIFF TRANSACTION COLLISION";
            case 58 -> "GATT CONTROLLER BUSY";
            case 59 -> "GATT UNACCEPT CONN INTERVAL";
            case 135 -> "GATT ILLEGAL PARAMETER";
            case 128 -> "GATT NO RESOURCES";
            case 129 -> "GATT INTERNAL ERROR";
            case 130 -> "GATT WRONG STATE";
            case 131 -> "GATT DB FULL";
            case 132 -> "GATT BUSY";
            case 133 -> "GATT ERROR";
            case 134 -> "GATT CMD STARTED";
            case 136 -> "GATT PENDING";
            case 137 -> "GATT AUTH FAIL";
            case 138 -> "GATT MORE";
            case 139 -> "GATT INVALID CFG";
            case 140 -> "GATT SERVICE STARTED";
            case 141 -> "GATT ENCRYPTED NO MITM";
            case 142 -> "GATT NOT ENCRYPTED";
            case 143 -> "GATT CONGESTED";
            case 253 -> "GATT CCCD CFG ERROR";
            case 254 -> "GATT PROCEDURE IN PROGRESS";
            case 255 -> "GATT VALUE OUT OF RANGE";
            case 257 -> "TOO MANY OPEN CONNECTIONS";
            case 4096 -> "DFU DEVICE DISCONNECTED";
            case 4097 -> "DFU FILE NOT FOUND";
            case 4098 -> "DFU FILE ERROR";
            case 4099 -> "DFU NOT A VALID HEX FILE";
            case 4100 -> "DFU IO EXCEPTION";
            case 4101 -> "DFU SERVICE DISCOVERY NOT STARTED";
            case 4102 -> "DFU CHARACTERISTICS NOT FOUND";
            case 4104 -> "DFU INVALID RESPONSE";
            case 4105 -> "DFU FILE TYPE NOT SUPPORTED";
            case 4106 -> "BLUETOOTH ADAPTER DISABLED";
            case 4107 -> "DFU INIT PACKET REQUIRED";
            case 4108 -> "DFU INIT PACKET REQUIRED";
            case 4109 -> "DFU CRC ERROR";
            case 4110 -> "DFU DEVICE NOT BONDED";
            default -> "UNKNOWN (" + error + ")";
        };
    }

    public static String parseDfuRemoteError(int error) {
        return switch (error & 0xF00) {
            case 256 -> LegacyDfuError.parse(error);
            case 512 -> SecureDfuError.parse(error);
            case 1024 -> SecureDfuError.parseExtendedError(error);
            case 2048 -> SecureDfuError.parseButtonlessError(error);
            default -> "UNKNOWN (" + error + ")";
        };
    }
}

