/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.log;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import no.nordicsemi.android.log.ILogSession;

public class LocalLogSession
implements ILogSession {
    private final Context context;
    private final Uri sessionUri;

    public static LocalLogSession newSession(@NonNull Context context, @NonNull Uri authority, @NonNull String key, @NonNull String name) {
        Uri uri = authority.buildUpon().appendEncodedPath("session").appendEncodedPath("key").appendEncodedPath(key).build();
        ContentValues values = new ContentValues();
        values.put("name", name);
        try {
            Uri sessionUri = context.getContentResolver().insert(uri, values);
            if (sessionUri != null) {
                return new LocalLogSession(context, sessionUri);
            }
            return null;
        }
        catch (Exception e) {
            Log.e((String)"LocalLogSession", (String)"Error while creating a local log session.", (Throwable)e);
            return null;
        }
    }

    LocalLogSession(@NonNull Context context, @NonNull Uri sessionUri) {
        this.context = context.getApplicationContext();
        this.sessionUri = sessionUri;
    }

    public void delete() {
        try {
            this.context.getContentResolver().delete(this.sessionUri, null, null);
        }
        catch (Exception e) {
            Log.e((String)"LocalLogSession", (String)"Error while deleting local log session.", (Throwable)e);
        }
    }

    @Override
    @NonNull
    public Context getContext() {
        return this.context;
    }

    @Override
    @NonNull
    public Uri getSessionUri() {
        return this.sessionUri;
    }

    @Override
    @NonNull
    public Uri getSessionEntriesUri() {
        return this.sessionUri.buildUpon().appendEncodedPath("log").build();
    }

    @Override
    @NonNull
    public Uri getSessionContentUri() {
        return this.sessionUri.buildUpon().appendEncodedPath("log").appendEncodedPath("content").build();
    }
}

