/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.log;

import android.net.Uri;
import android.provider.BaseColumns;

public class LogContract {
    public static final String AUTHORITY = "no.nordicsemi.android.log";
    public static final Uri AUTHORITY_URI = Uri.parse((String)"content://no.nordicsemi.android.log");

    public static final class Application
    implements BaseColumns,
    ApplicationColumns {
        public static final String APPLICATION_CONTENT_DIRECTORY = "application";
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"application");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/no.nordicsemi.android.log.applications";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/no.nordicsemi.android.log.application";

        private Application() {
        }
    }

    public static final class Session
    implements BaseColumns,
    SessionColumns {
        public static final String SESSION_CONTENT_DIRECTORY = "session";
        public static final String KEY_CONTENT_DIRECTORY = "key";
        public static final String APPLICATION_CONTENT_DIRECTORY = "application";
        public static final Uri CONTENT_URI = Uri.withAppendedPath((Uri)AUTHORITY_URI, (String)"session");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/no.nordicsemi.android.log.sessions";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/no.nordicsemi.android.log.session";

        private Session() {
        }

        public static Uri createUri(long sessionId) {
            return CONTENT_URI.buildUpon().appendEncodedPath(String.valueOf(sessionId)).build();
        }

        public static Uri createUri(String key, int number) {
            return CONTENT_URI.buildUpon().appendEncodedPath(KEY_CONTENT_DIRECTORY).appendEncodedPath(key).appendEncodedPath(String.valueOf(number)).build();
        }

        public static Uri createSessionsUri(long applicationId) {
            return CONTENT_URI.buildUpon().appendEncodedPath(APPLICATION_CONTENT_DIRECTORY).appendEncodedPath(String.valueOf(applicationId)).build();
        }

        public static final class Content {
            public static final String CONTENT = "content";
        }
    }

    public static final class Log
    implements BaseColumns,
    LogColumns {
        public static final String CONTENT_DIRECTORY = "log";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/no.nordicsemi.android.log.enties";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/no.nordicsemi.android.log.entry";

        private Log() {
        }

        public static Uri createUri(long sessionId) {
            return Session.CONTENT_URI.buildUpon().appendEncodedPath(String.valueOf(sessionId)).appendEncodedPath(CONTENT_DIRECTORY).build();
        }

        public static Uri createUri(String key, int number) {
            return Session.CONTENT_URI.buildUpon().appendEncodedPath("key").appendEncodedPath(key).appendEncodedPath(String.valueOf(number)).appendEncodedPath(CONTENT_DIRECTORY).build();
        }

        public static final class Level {
            public static final int DEBUG = 0;
            public static final int VERBOSE = 1;
            public static final int INFO = 5;
            public static final int APPLICATION = 10;
            public static final int WARNING = 15;
            public static final int ERROR = 20;

            private Level() {
            }

            public static int fromPriority(int priority) {
                switch (priority) {
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                    case 4: {
                        return 5;
                    }
                    case 5: {
                        return 15;
                    }
                    case 6: 
                    case 7: {
                        return 20;
                    }
                }
                return priority;
            }
        }
    }

    protected static interface ApplicationColumns {
        public static final String APPLICATION = "application";
    }

    protected static interface SessionColumns {
        public static final String KEY = "key";
        public static final String NAME = "name";
        public static final String APPLICATION_ID = "application_id";
        public static final String CREATED_AT = "created_at";
        public static final String NUMBER = "number";
        public static final String DESCRIPTION = "description";
        public static final String MARK = "mark";
    }

    protected static interface LogColumns {
        public static final String SESSION_ID = "session_id";
        public static final String TIME = "time";
        public static final String LEVEL = "level";
        public static final String DATA = "data";
    }
}

