/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.log;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import no.nordicsemi.android.log.ILogSession;
import no.nordicsemi.android.log.LogContract;

public class LogSession
implements ILogSession {
    private final Context context;
    private final Uri sessionUri;

    LogSession(Context context, Uri sessionUri) {
        this.context = context.getApplicationContext();
        this.sessionUri = sessionUri;
    }

    @Override
    @NonNull
    public Context getContext() {
        return this.context;
    }

    @Override
    @NonNull
    public Uri getSessionUri() {
        return this.sessionUri;
    }

    @Override
    @NonNull
    public Uri getSessionEntriesUri() {
        return this.sessionUri.buildUpon().appendEncodedPath("log").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Uri getSessionsUri() {
        try (Cursor cursor = this.context.getContentResolver().query(this.sessionUri, new String[]{"application_id"}, null, null, null);){
            if (cursor.moveToNext()) {
                long appId = cursor.getLong(0);
                Uri uri = LogContract.Session.createSessionsUri(appId);
                return uri;
            }
            Uri uri = null;
            return uri;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @NonNull
    public Uri getSessionContentUri() {
        return this.sessionUri.buildUpon().appendEncodedPath("log").appendEncodedPath("content").build();
    }

    @NonNull
    public String toString() {
        return this.sessionUri.toString();
    }
}

