/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.log;

import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.log.ILogSession;
import no.nordicsemi.android.log.LocalLogSession;
import no.nordicsemi.android.log.LogContract;
import no.nordicsemi.android.log.LogSession;

public class Logger {
    public static final int MARK_CLEAR = 0;
    public static final int MARK_STAR_YELLOW = 1;
    public static final int MARK_STAR_BLUE = 2;
    public static final int MARK_STAR_RED = 3;
    public static final int MARK_FLAG_YELLOW = 4;
    public static final int MARK_FLAG_BLUE = 5;
    public static final int MARK_FLAG_RED = 6;
    private static final int SESSION_ID = 100;
    private static final int SESSION_ID_LOG = 101;
    private static final int SESSION_KEY_NUMBER = 102;
    private static final int SESSION_KEY_NUMBER_LOG = 103;
    private static final UriMatcher mUriMatcher = new UriMatcher(-1);
    private static final ContentValues values = new ContentValues();

    @Nullable
    public static LogSession newSession(@NonNull Context context, @NonNull String key, @Nullable String name) {
        return Logger.newSession(context, null, key, name);
    }

    @Nullable
    public static LogSession newSession(@NonNull Context context, @Nullable String profile, @NonNull String key, @Nullable String name) {
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        ContentProviderOperation.Builder builder = ContentProviderOperation.newInsert((Uri)LogContract.Application.CONTENT_URI);
        String appName = context.getApplicationInfo().loadLabel(context.getPackageManager()).toString();
        if (profile != null) {
            builder.withValue("application", (Object)(appName + " " + profile));
        } else {
            builder.withValue("application", (Object)appName);
        }
        ops.add(builder.build());
        Uri uri = LogContract.Session.CONTENT_URI.buildUpon().appendEncodedPath("key").appendEncodedPath(key).build();
        builder = ContentProviderOperation.newInsert((Uri)uri).withValueBackReference("application_id", 0).withValue("name", (Object)name);
        ops.add(builder.build());
        try {
            ContentProviderResult[] results = context.getContentResolver().applyBatch("no.nordicsemi.android.log", ops);
            Uri sessionUri = results[1].uri;
            return new LogSession(context, sessionUri);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static ILogSession openSession(@NonNull Context context, @Nullable Uri uri) {
        if (uri == null) {
            return null;
        }
        int match = mUriMatcher.match(uri);
        switch (match) {
            case 100: 
            case 102: {
                return new LogSession(context, uri);
            }
            case 101: 
            case 103: {
                Uri.Builder builder = LogContract.Session.CONTENT_URI.buildUpon();
                List segments = uri.getPathSegments();
                for (int i = 1; i < segments.size() - 1; ++i) {
                    builder.appendEncodedPath((String)segments.get(i));
                }
                return new LogSession(context, builder.build());
            }
        }
        return new LocalLogSession(context, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSessionDescription(@Nullable LogSession session, @Nullable String description) {
        if (session == null) {
            return;
        }
        ContentValues contentValues = values;
        synchronized (contentValues) {
            values.clear();
            values.put("description", description);
            try {
                session.getContext().getContentResolver().update(session.getSessionUri(), values, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSessionMark(@Nullable LogSession session, int mark) {
        if (session == null) {
            return;
        }
        ContentValues contentValues = values;
        synchronized (contentValues) {
            values.clear();
            values.put("mark", Integer.valueOf(mark));
            try {
                session.getContext().getContentResolver().update(session.getSessionUri(), values, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void d(@Nullable ILogSession session, @NonNull String message) {
        Logger.log(session, 0, message);
    }

    public static void v(@Nullable ILogSession session, @NonNull String message) {
        Logger.log(session, 1, message);
    }

    public static void i(@Nullable ILogSession session, @NonNull String message) {
        Logger.log(session, 5, message);
    }

    public static void a(@Nullable ILogSession session, @NonNull String message) {
        Logger.log(session, 10, message);
    }

    public static void w(@Nullable ILogSession session, @NonNull String message) {
        Logger.log(session, 15, message);
    }

    public static void e(@Nullable ILogSession session, @NonNull String message) {
        Logger.log(session, 20, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(@Nullable ILogSession session, int level, @NonNull String message) {
        if (session == null) {
            return;
        }
        ContentValues contentValues = values;
        synchronized (contentValues) {
            values.clear();
            values.put("level", Integer.valueOf(level));
            values.put("data", message);
            try {
                session.getContext().getContentResolver().insert(session.getSessionEntriesUri(), values);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ContentValues logEntry(@Nullable ILogSession session, int level, @NonNull String message) {
        if (session == null) {
            return null;
        }
        ContentValues values = new ContentValues();
        values.put("time", Long.valueOf(System.currentTimeMillis()));
        values.put("level", Integer.valueOf(level));
        values.put("data", message);
        return values;
    }

    public static void d(@Nullable ILogSession session, @StringRes int messageResId, Object ... params) {
        Logger.log(session, 0, messageResId, params);
    }

    public static void v(@Nullable ILogSession session, @StringRes int messageResId, Object ... params) {
        Logger.log(session, 1, messageResId, params);
    }

    public static void i(@Nullable ILogSession session, @StringRes int messageResId, Object ... params) {
        Logger.log(session, 5, messageResId, params);
    }

    public static void a(@Nullable ILogSession session, @StringRes int messageResId, Object ... params) {
        Logger.log(session, 10, messageResId, params);
    }

    public static void w(@Nullable ILogSession session, @StringRes int messageResId, Object ... params) {
        Logger.log(session, 15, messageResId, params);
    }

    public static void e(@Nullable ILogSession session, @StringRes int messageResId, Object ... params) {
        Logger.log(session, 20, messageResId, params);
    }

    public static void log(@Nullable ILogSession session, int level, @StringRes int messageResId, Object ... params) {
        if (session == null) {
            return;
        }
        values.clear();
        values.put("level", Integer.valueOf(level));
        values.put("data", session.getContext().getString(messageResId, params));
        try {
            session.getContext().getContentResolver().insert(session.getSessionEntriesUri(), values);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ContentValues logEntry(@Nullable ILogSession session, int level, @StringRes int messageResId, Object ... params) {
        if (session == null) {
            return null;
        }
        ContentValues values = new ContentValues();
        values.put("time", Long.valueOf(System.currentTimeMillis()));
        values.put("level", Integer.valueOf(level));
        values.put("data", session.getContext().getString(messageResId, params));
        return values;
    }

    public static void log(@Nullable ILogSession session, @Nullable ContentValues[] values) {
        if (session == null || values == null || values.length == 0) {
            return;
        }
        try {
            session.getContext().getContentResolver().bulkInsert(session.getSessionEntriesUri(), values);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void log(@Nullable ILogSession session, @Nullable List<ContentValues> values) {
        if (session == null || values == null || values.isEmpty()) {
            return;
        }
        try {
            session.getContext().getContentResolver().bulkInsert(session.getSessionEntriesUri(), values.toArray(new ContentValues[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        UriMatcher matcher = mUriMatcher;
        matcher.addURI("no.nordicsemi.android.log", "session/#", 100);
        matcher.addURI("no.nordicsemi.android.log", "session/#/log", 101);
        matcher.addURI("no.nordicsemi.android.log", "session/key/*/#", 102);
        matcher.addURI("no.nordicsemi.android.log", "session/key/*/#/log", 103);
    }
}

