/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.log.localprovider;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import no.nordicsemi.android.log.LogContract;
import no.nordicsemi.android.log.localprovider.LocalLogDatabaseHelper;
import no.nordicsemi.android.log.localprovider.LogTransaction;
import no.nordicsemi.android.log.localprovider.ProjectionMap;

public abstract class LocalLogContentProvider
extends ContentProvider {
    private static final String TAG = "LocalLogContentProvider";
    private static final String DB_TAG = "local_log_db";
    protected static final int SLEEP_AFTER_YIELD_DELAY = 4000;
    private static final int MAX_OPERATIONS_PER_YIELD_POINT = 500;
    private static final int BULK_INSERTS_PER_YIELD_POINT = 50;
    private static final UriMatcher sUriMatcher = new UriMatcher(-1);
    private static final int SESSION = 1020;
    private static final int SESSION_ID = 1021;
    private static final int SESSION_ID_LOG = 1022;
    private static final int SESSION_ID_LOG_CONTENT = 1023;
    private static final int SESSION_KEY = 1024;
    private static final ProjectionMap sSessionColumns = ProjectionMap.builder().add("_id").add("key").add("name").add("created_at").build();
    private static final ProjectionMap sLogColumns = ProjectionMap.builder().add("_id").add("session_id").add("level").add("time").add("data").build();
    private static final ProjectionMap sCountProjectionMap = ProjectionMap.builder().add("_count", "COUNT(*)").build();
    private final ThreadLocal<LogTransaction> mTransactionHolder = new ThreadLocal();
    private final ThreadLocal<LocalLogDatabaseHelper> mLocalDatabaseHelper = new ThreadLocal();
    private LocalLogDatabaseHelper mDatabaseHelper;
    private final ContentValues mValues = new ContentValues();
    private final String[] mSelectionArgs1 = new String[1];
    private SQLiteOpenHelper mSerializeOnDbHelper;
    private String mSerializeDbTag;

    protected abstract Uri getAuthorityUri();

    protected LocalLogDatabaseHelper getDatabaseHelper(Context context) {
        return LocalLogDatabaseHelper.getInstance(context);
    }

    public void setDbHelperToSerializeOn(SQLiteOpenHelper serializeOnDbHelper, String tag) {
        this.mSerializeOnDbHelper = serializeOnDbHelper;
        this.mSerializeDbTag = tag;
    }

    public boolean onCreate() {
        try {
            return this.initialize();
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Cannot start provider", (Throwable)e);
            return false;
        }
    }

    private boolean initialize() {
        this.mDatabaseHelper = this.getDatabaseHelper(this.getContext());
        this.mLocalDatabaseHelper.set(this.mDatabaseHelper);
        this.setDbHelperToSerializeOn(this.mDatabaseHelper, DB_TAG);
        String authority = this.getAuthorityUri().getAuthority();
        UriMatcher matcher = sUriMatcher;
        matcher.addURI(authority, "session", 1020);
        matcher.addURI(authority, "session/#", 1021);
        matcher.addURI(authority, "session/#/log", 1022);
        matcher.addURI(authority, "session/#/log/content", 1023);
        matcher.addURI(authority, "session/key/*", 1024);
        return true;
    }

    public String getType(@NonNull Uri uri) {
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 1021: {
                return "vnd.android.cursor.item/no.nordicsemi.android.log.session";
            }
            case 1022: {
                return "vnd.android.cursor.dir/no.nordicsemi.android.log.enties";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        this.mLocalDatabaseHelper.set(this.mDatabaseHelper);
        SQLiteDatabase db = this.mLocalDatabaseHelper.get().getReadableDatabase();
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 1021: {
                String id = uri.getLastPathSegment();
                qb.setTables("sessions");
                qb.setProjectionMap((Map)sSessionColumns);
                qb.appendWhere((CharSequence)"_id=?");
                selectionArgs = this.appendSelectionArgs(selectionArgs, id);
                break;
            }
            case 1022: 
            case 1023: {
                String id = (String)uri.getPathSegments().get(1);
                qb.setTables("log");
                qb.setProjectionMap((Map)sLogColumns);
                qb.appendWhere((CharSequence)"session_id=?");
                selectionArgs = this.appendSelectionArgs(selectionArgs, id);
                if (match != 1023) break;
                StringBuilder builder = new StringBuilder();
                String[] sessionProjection = new String[]{"key", "name", "created_at"};
                String sessionSelection = "_id=?";
                String[] sessionSelArgs = this.mSelectionArgs1;
                sessionSelArgs[0] = id;
                try (Cursor c = db.query("sessions", sessionProjection, "_id=?", sessionSelArgs, null, null, null);){
                    if (c.moveToNext()) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(c.getLong(2));
                        String appName = this.getContext().getApplicationInfo().loadLabel(this.getContext().getPackageManager()).toString();
                        builder.append(String.format("%s, %tF\n", appName, calendar));
                        String name = c.getString(1);
                        builder.append(String.format("%s (%s)\n", name != null ? name : "No name", c.getString(0)));
                    }
                }
                String[] entryProjection = new String[]{"time", "level", "data"};
                c = this.query(uri, db, qb, entryProjection, selection, selectionArgs, "time ASC");
                try {
                    Calendar calendar = Calendar.getInstance();
                    while (c.moveToNext()) {
                        builder.append(this.getLevelAsChar(c.getInt(1)));
                        calendar.setTimeInMillis(c.getLong(0));
                        builder.append(String.format("\t%1$tR:%1$tS.%1$tL\t%2$s\n", calendar, c.getString(2)));
                    }
                }
                finally {
                    c.close();
                }
                MatrixCursor cursor = new MatrixCursor(new String[]{"content"});
                cursor.addRow((Object[])new String[]{builder.toString()});
                return cursor;
            }
        }
        return this.query(uri, db, qb, projection, selection, selectionArgs, sortOrder);
    }

    private char getLevelAsChar(int level) {
        switch (level) {
            case 1: {
                return 'V';
            }
            case 5: {
                return 'I';
            }
            case 10: {
                return 'A';
            }
            case 15: {
                return 'W';
            }
            case 20: {
                return 'E';
            }
        }
        return 'D';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(@NonNull Uri uri, @NonNull ContentValues[] values) {
        LogTransaction transaction = this.startTransaction(true);
        int numValues = values.length;
        int opCount = 0;
        boolean dirty = false;
        try {
            for (ContentValues value : values) {
                if (value == null) continue;
                if (this.insertInTransaction(uri, value) != null) {
                    dirty = true;
                }
                if (++opCount < 50) continue;
                opCount = 0;
                try {
                    this.yield(transaction);
                }
                catch (RuntimeException re) {
                    transaction.markYieldFailed();
                    throw re;
                }
            }
            if (dirty) {
                transaction.markDirty();
            }
            transaction.markSuccessful(true);
        }
        finally {
            this.endTransaction(uri, true);
        }
        return numValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ContentProviderResult[] applyBatch(@NonNull ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        int ypCount = 0;
        int opCount = 0;
        LogTransaction transaction = this.startTransaction(true);
        try {
            int numOperations = operations.size();
            ContentProviderResult[] results = new ContentProviderResult[numOperations];
            for (int i = 0; i < numOperations; ++i) {
                if (++opCount >= 500) {
                    throw new OperationApplicationException("Too many content provider operations between yield points. The maximum number of operations per yield point is 500", ypCount);
                }
                ContentProviderOperation operation = operations.get(i);
                if (i > 0 && operation.isYieldAllowed()) {
                    opCount = 0;
                    try {
                        if (this.yield(transaction)) {
                            ++ypCount;
                        }
                    }
                    catch (RuntimeException re) {
                        transaction.markYieldFailed();
                        throw re;
                    }
                }
                results[i] = operation.apply((ContentProvider)this, results, i);
            }
            transaction.markSuccessful(true);
            ContentProviderResult[] contentProviderResultArray = results;
            return contentProviderResultArray;
        }
        finally {
            this.endTransaction(LogContract.Session.CONTENT_URI, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri insert(@NonNull Uri uri, ContentValues values) {
        LogTransaction transaction = this.startTransaction(false);
        try {
            Uri result = this.insertInTransaction(uri, values);
            if (result != null) {
                transaction.markDirty();
            }
            transaction.markSuccessful(false);
            Uri uri2 = result;
            return uri2;
        }
        finally {
            this.endTransaction(uri, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(@NonNull Uri uri, String selection, String[] selectionArgs) {
        LogTransaction transaction = this.startTransaction(false);
        try {
            int deleted = this.deleteInTransaction(uri, selection, selectionArgs);
            if (deleted > 0) {
                transaction.markDirty();
            }
            transaction.markSuccessful(false);
            int n = deleted;
            return n;
        }
        finally {
            this.endTransaction(uri, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(@NonNull Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        LogTransaction transaction = this.startTransaction(false);
        try {
            int updated = this.updateInTransaction(uri, values, selection, selectionArgs);
            if (updated > 0) {
                transaction.markDirty();
            }
            transaction.markSuccessful(false);
            int n = updated;
            return n;
        }
        finally {
            this.endTransaction(uri, false);
        }
    }

    private Cursor query(Uri uri, SQLiteDatabase db, SQLiteQueryBuilder qb, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor c;
        if (projection != null && projection.length == 1 && "_count".equals(projection[0])) {
            qb.setProjectionMap((Map)sCountProjectionMap);
        }
        if ((c = qb.query(db, projection, selection, selectionArgs, null, null, sortOrder)) != null) {
            c.setNotificationUri(this.getContext().getContentResolver(), uri);
        }
        return c;
    }

    protected Uri insertInTransaction(@NonNull Uri uri, ContentValues values) {
        this.mLocalDatabaseHelper.set(this.mDatabaseHelper);
        int match = sUriMatcher.match(uri);
        long id = 0L;
        switch (match) {
            case 1022: {
                long sessionId = Long.parseLong((String)uri.getPathSegments().get(1));
                if (!values.containsKey("time")) {
                    values.put("time", Long.valueOf(System.currentTimeMillis()));
                }
                values.put("session_id", Long.valueOf(sessionId));
                id = this.insertLog(uri, values);
                break;
            }
            case 1020: {
                String key = values.getAsString("key");
                if (key == null) {
                    return null;
                }
                long time = System.currentTimeMillis();
                values.put("created_at", Long.valueOf(time));
                id = this.insertSession(uri, values);
                if (id < 0L) {
                    return null;
                }
            }
            case 1024: {
                String key = uri.getLastPathSegment();
                long time = System.currentTimeMillis();
                values.put("key", key);
                values.put("created_at", Long.valueOf(time));
                id = this.insertSession(uri, values);
                if (id < 0L) {
                    return null;
                }
                return ContentUris.withAppendedId((Uri)Uri.withAppendedPath((Uri)this.getAuthorityUri(), (String)"session"), (long)id);
            }
        }
        if (id < 0L) {
            return null;
        }
        return ContentUris.withAppendedId((Uri)uri, (long)id);
    }

    private long insertSession(Uri uri, ContentValues values) {
        this.mValues.clear();
        this.mValues.putAll(values);
        SQLiteDatabase db = this.mLocalDatabaseHelper.get().getWritableDatabase();
        return db.insert("sessions", null, this.mValues);
    }

    private long insertLog(Uri uri, ContentValues values) {
        this.mValues.clear();
        this.mValues.putAll(values);
        SQLiteDatabase db = this.mLocalDatabaseHelper.get().getWritableDatabase();
        return db.insert("log", null, this.mValues);
    }

    private int deleteInTransaction(Uri uri, String selection, String[] selectionArgs) {
        this.mLocalDatabaseHelper.set(this.mDatabaseHelper);
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 1020: {
                return this.deleteSessions();
            }
            case 1021: {
                long id = ContentUris.parseId((Uri)uri);
                return this.deleteSession(id);
            }
        }
        return 0;
    }

    private int deleteSessions() {
        SQLiteDatabase db = this.mLocalDatabaseHelper.get().getWritableDatabase();
        db.delete("log", null, null);
        return db.delete("sessions", null, null);
    }

    private int deleteSession(long sessionId) {
        SQLiteDatabase db = this.mLocalDatabaseHelper.get().getWritableDatabase();
        String[] args = this.mSelectionArgs1;
        args[0] = String.valueOf(sessionId);
        db.delete("log", "session_id=?", args);
        return db.delete("sessions", "_id=?", args);
    }

    private int updateInTransaction(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Updating log is not supported. You can not change the history.");
    }

    private LogTransaction startTransaction(boolean callerIsBatch) {
        LogTransaction transaction = this.mTransactionHolder.get();
        if (transaction == null) {
            transaction = new LogTransaction(callerIsBatch);
            if (this.mSerializeOnDbHelper != null) {
                transaction.startTransactionForDb(this.mSerializeOnDbHelper.getWritableDatabase(), this.mSerializeDbTag);
            }
            this.mTransactionHolder.set(transaction);
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTransaction(Uri uri, boolean callerIsBatch) {
        LogTransaction transaction = this.mTransactionHolder.get();
        if (transaction != null && (!transaction.isBatch() || callerIsBatch)) {
            try {
                if (transaction.isDirty()) {
                    this.notifyChange(Uri.withAppendedPath((Uri)this.getAuthorityUri(), (String)"session"));
                }
                transaction.finish(callerIsBatch);
            }
            finally {
                this.mTransactionHolder.set(null);
            }
        }
    }

    protected boolean yield(LogTransaction transaction) {
        SQLiteDatabase db = transaction.getDbForTag(DB_TAG);
        return db != null && db.yieldIfContendedSafely(4000L);
    }

    protected void notifyChange(Uri uri) {
        this.getContext().getContentResolver().notifyChange(uri, null, false);
    }

    private String[] appendSelectionArgs(String[] selectionArgs, String ... arg) {
        if (selectionArgs == null) {
            return arg;
        }
        int newLength = selectionArgs.length + arg.length;
        String[] newSelectionArgs = new String[newLength];
        System.arraycopy(arg, 0, newSelectionArgs, 0, arg.length);
        System.arraycopy(selectionArgs, 0, newSelectionArgs, arg.length, selectionArgs.length);
        return newSelectionArgs;
    }
}

