/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.log.localprovider;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.util.ArrayList;

class LocalLogDatabaseHelper
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "local_log.db";
    private static final int DATABASE_VERSION = 1;
    private static LocalLogDatabaseHelper sInstance = null;
    private static final String CREATE_LOG_SESSIONS = "CREATE TABLE sessions(_id INTEGER PRIMARY KEY AUTOINCREMENT, key TEXT NOT NULL, name TEXT, created_at INTEGER NOT NULL);";
    private static final String CREATE_LOG = "CREATE TABLE log(_id INTEGER PRIMARY KEY AUTOINCREMENT, session_id INTEGER NOT NULL, time INTEGER NOT NULL, level INTEGER NOT NULL, data TEXT NOT NULL, FOREIGN KEY(session_id) REFERENCES sessions(_id));";

    static synchronized LocalLogDatabaseHelper getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new LocalLogDatabaseHelper(context, DATABASE_NAME, 1);
        }
        return sInstance;
    }

    private LocalLogDatabaseHelper(Context context, String databaseName, int version) {
        super(context, databaseName, null, version);
    }

    public void onCreate(SQLiteDatabase db) {
        ArrayList<String> ddls = new ArrayList<String>();
        ddls.add(CREATE_LOG_SESSIONS);
        ddls.add(CREATE_LOG);
        for (String ddl : ddls) {
            db.execSQL(ddl);
        }
        this.initializeAutoIncrementSequences(db);
    }

    private void initializeAutoIncrementSequences(SQLiteDatabase db) {
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public static interface LogColumns {
        public static final String CONCRETE_ID = "log._id";
        public static final String CONCRETE_SESSION_ID = "log.session_id";
        public static final String CONCRETE_TIME = "log.time";
        public static final String CONCRETE_LEVEL = "log.level";
        public static final String CONCRETE_DATA = "log.data";
    }

    public static interface SessionColumns {
        public static final String CONCRETE_ID = "sessions._id";
        public static final String CONCRETE_KEY = "sessions.key";
        public static final String CONCRETE_NAME = "sessions.name";
        public static final String CONCRETE_APPLICATION_ID = "sessions.application_id";
        public static final String CONCRETE_CREATED_AT = "sessions.created_at";
        public static final String CONCRETE_NUMBER = "sessions.number";
        public static final String CONCRETE_DESCRIPTION = "sessions.description";
        public static final String CONCRETE_MARK = "sessions.mark";
    }

    public static interface Projections {
        public static final String[] ID = new String[]{"_id"};
        public static final String[] MAX_NUMBER = new String[]{"MAX(number)"};
    }

    public static interface Tables {
        public static final String LOG_SESSIONS = "sessions";
        public static final String LOG = "log";
    }
}

