/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.log.localprovider;

import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class LogTransaction {
    private final boolean mBatch;
    private final List<SQLiteDatabase> mDatabasesForTransaction;
    private final Map<String, SQLiteDatabase> mDatabaseTagMap;
    private boolean mIsDirty;
    private boolean mYieldFailed;

    LogTransaction(boolean batch) {
        this.mBatch = batch;
        this.mDatabasesForTransaction = new ArrayList<SQLiteDatabase>();
        this.mDatabaseTagMap = new HashMap<String, SQLiteDatabase>();
        this.mIsDirty = false;
    }

    boolean isBatch() {
        return this.mBatch;
    }

    boolean isDirty() {
        return this.mIsDirty;
    }

    void markDirty() {
        this.mIsDirty = true;
    }

    void markYieldFailed() {
        this.mYieldFailed = true;
    }

    void startTransactionForDb(SQLiteDatabase db, String tag) {
        if (!this.hasDbInTransaction(tag)) {
            this.mDatabasesForTransaction.add(0, db);
            this.mDatabaseTagMap.put(tag, db);
            db.beginTransaction();
        }
    }

    private boolean hasDbInTransaction(String tag) {
        return this.mDatabaseTagMap.containsKey(tag);
    }

    SQLiteDatabase getDbForTag(String tag) {
        return this.mDatabaseTagMap.get(tag);
    }

    public SQLiteDatabase removeDbForTag(String tag) {
        SQLiteDatabase db = this.mDatabaseTagMap.get(tag);
        this.mDatabaseTagMap.remove(tag);
        this.mDatabasesForTransaction.remove(db);
        return db;
    }

    void markSuccessful(boolean callerIsBatch) {
        if (!this.mBatch || callerIsBatch) {
            for (SQLiteDatabase db : this.mDatabasesForTransaction) {
                db.setTransactionSuccessful();
            }
        }
    }

    void finish(boolean callerIsBatch) {
        if (!this.mBatch || callerIsBatch) {
            for (SQLiteDatabase db : this.mDatabasesForTransaction) {
                if (this.mYieldFailed && !db.isDbLockedByCurrentThread()) continue;
                db.endTransaction();
            }
            this.mDatabasesForTransaction.clear();
            this.mDatabaseTagMap.clear();
            this.mIsDirty = false;
        }
    }
}

