/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.Entity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.BaseMeshNetwork;
import no.nordicsemi.android.mesh.Group;
import no.nordicsemi.android.mesh.IvIndex;
import no.nordicsemi.android.mesh.MeshNetworkCallbacks;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.Provisioner;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.MeshAddress;

@Entity(tableName="mesh_network")
public final class MeshNetwork
extends BaseMeshNetwork {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public MeshNetwork(String meshUUID) {
        super(meshUUID);
    }

    void setCallbacks(MeshNetworkCallbacks mCallbacks) {
        this.mCallbacks = mCallbacks;
    }

    public void setIvIndex(IvIndex ivIndex) {
        this.ivIndex = ivIndex;
        this.notifyNetworkUpdated();
    }

    public IvIndex getIvIndex() {
        return this.ivIndex;
    }

    public String getSchema() {
        return this.schema;
    }

    void setSchema(String schema) {
        this.schema = schema;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    void setVersion(String version) {
        this.version = version;
    }

    public String getMeshUUID() {
        return this.meshUUID;
    }

    public String getMeshName() {
        return this.meshName;
    }

    public void setMeshName(String meshName) {
        this.meshName = meshName;
        this.notifyNetworkUpdated();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public int nextAvailableUnicastAddress(int elementCount, @NonNull Provisioner provisioner) throws IllegalArgumentException {
        if (provisioner.getAllocatedUnicastRanges().isEmpty()) {
            throw new IllegalArgumentException("Please allocate a unicast address range to the provisioner");
        }
        Collections.sort(this.nodes, this.nodeComparator);
        int index = 0;
        for (AllocatedUnicastRange range : provisioner.getAllocatedUnicastRanges()) {
            int currentIndex;
            int address = range.getLowAddress();
            for (int i = currentIndex = index; i < this.nodes.size(); ++i) {
                ProvisionedMeshNode node = (ProvisionedMeshNode)this.nodes.get(i);
                index += i;
                int lastUnicastInNode = node.getLastUnicastAddress();
                if (address > lastUnicastInNode) continue;
                if (node.getUnicastAddress() > address + (elementCount - 1)) {
                    return address;
                }
                address = lastUnicastInNode + 1;
                if (range.highAddress < address + (elementCount - 1)) break;
            }
            if (range.getHighAddress() < address + (elementCount - 1)) continue;
            return address;
        }
        return -1;
    }

    public AllocatedUnicastRange nextAvailableUnicastAddressRange(int rangeSize) {
        ArrayList<AllocatedUnicastRange> ranges = new ArrayList<AllocatedUnicastRange>();
        for (Provisioner provisioner : this.provisioners) {
            ranges.addAll(provisioner.getAllocatedUnicastRanges());
        }
        Collections.sort(ranges, this.unicastRangeComparator);
        return this.getNextAvailableUnicastRange(rangeSize, new AllocatedUnicastRange(1, Short.MAX_VALUE), ranges);
    }

    public AllocatedGroupRange nextAvailableGroupAddressRange(int rangeSize) {
        ArrayList<AllocatedGroupRange> ranges = new ArrayList<AllocatedGroupRange>();
        for (Provisioner provisioner : this.provisioners) {
            ranges.addAll(provisioner.getAllocatedGroupRanges());
        }
        Collections.sort(ranges, this.groupRangeComparator);
        return this.getNextAvailableGroupRange(rangeSize, new AllocatedGroupRange(49152, 65279), ranges);
    }

    public AllocatedSceneRange nextAvailableSceneAddressRange(int rangeSize) {
        ArrayList<AllocatedSceneRange> ranges = new ArrayList<AllocatedSceneRange>();
        for (Provisioner provisioner : this.provisioners) {
            ranges.addAll(provisioner.getAllocatedSceneRanges());
        }
        Collections.sort(ranges, this.sceneRangeComparator);
        return this.getNextAvailableSceneRange(rangeSize, new AllocatedSceneRange(1, 65535), ranges);
    }

    @Nullable
    private AllocatedUnicastRange getNextAvailableUnicastRange(int size, @NonNull AllocatedUnicastRange bound, @NonNull List<AllocatedUnicastRange> ranges) {
        AllocatedUnicastRange bestRange = null;
        int lastUpperBound = bound.lowAddress - 1;
        for (AllocatedUnicastRange range : ranges) {
            if (lastUpperBound + size < range.lowAddress) {
                return new AllocatedUnicastRange(lastUpperBound + 1, lastUpperBound + size);
            }
            if (range.lowAddress - lastUpperBound > 1) {
                AllocatedUnicastRange newRange = new AllocatedUnicastRange(lastUpperBound + 1, range.lowAddress - 1);
                if (bestRange == null || newRange.range() > bestRange.range()) {
                    bestRange = newRange;
                }
            }
            lastUpperBound = range.highAddress;
        }
        if (lastUpperBound + size < bound.highAddress) {
            return new AllocatedUnicastRange(lastUpperBound + 1, lastUpperBound + size - 1);
        }
        return bestRange;
    }

    @Nullable
    private AllocatedGroupRange getNextAvailableGroupRange(int size, @NonNull AllocatedGroupRange bound, @NonNull List<AllocatedGroupRange> ranges) {
        AllocatedGroupRange bestRange = null;
        int lastUpperBound = bound.lowAddress - 1;
        for (AllocatedGroupRange range : ranges) {
            if (lastUpperBound + size < range.lowAddress) {
                return new AllocatedGroupRange(lastUpperBound + 1, lastUpperBound + size);
            }
            if (range.lowAddress - lastUpperBound > 1) {
                AllocatedGroupRange newRange = new AllocatedGroupRange(lastUpperBound + 1, range.lowAddress - 1);
                if (bestRange == null || newRange.range() > bestRange.range()) {
                    bestRange = newRange;
                }
            }
            lastUpperBound = range.highAddress;
        }
        if (lastUpperBound + size < bound.highAddress) {
            return new AllocatedGroupRange(lastUpperBound + 1, lastUpperBound + size - 1);
        }
        return bestRange;
    }

    @Nullable
    private AllocatedSceneRange getNextAvailableSceneRange(int size, @NonNull AllocatedSceneRange bound, @NonNull List<AllocatedSceneRange> ranges) {
        AllocatedSceneRange bestRange = null;
        int lastUpperBound = bound.getFirstScene() - 1;
        for (AllocatedSceneRange range : ranges) {
            if (lastUpperBound + size < range.getFirstScene()) {
                return new AllocatedSceneRange(lastUpperBound + 1, lastUpperBound + size);
            }
            if (range.getFirstScene() - lastUpperBound > 1) {
                AllocatedSceneRange newRange = new AllocatedSceneRange(lastUpperBound + 1, range.getFirstScene() - 1);
                if (bestRange == null || newRange.range() > bestRange.range()) {
                    bestRange = newRange;
                }
            }
            lastUpperBound = range.getLastScene();
        }
        if (lastUpperBound + size < bound.getLastScene()) {
            return new AllocatedSceneRange(lastUpperBound + 1, lastUpperBound + size - 1);
        }
        return bestRange;
    }

    public Integer nextAvailableGroupAddress(@NonNull Provisioner provisioner) throws IllegalStateException {
        if (provisioner.getAllocatedGroupRanges().isEmpty()) {
            throw new IllegalArgumentException("Provisioner has no group range allocated.");
        }
        Collections.sort(this.groups, this.groupComparator);
        for (AllocatedGroupRange range : provisioner.getAllocatedGroupRanges()) {
            if (this.groups.isEmpty()) {
                return range.getLowAddress();
            }
            for (int address = range.lowAddress; address < range.getHighAddress(); ++address) {
                if (this.isGroupAddressInUse(address)) continue;
                return address;
            }
        }
        return null;
    }

    private boolean isGroupAddressInUse(int address) {
        for (Group group : this.groups) {
            if (group.getAddress() != address) continue;
            return true;
        }
        return false;
    }

    public Group createGroup(@NonNull Provisioner provisioner, @NonNull String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Group name cannot be empty");
        }
        Integer address = this.nextAvailableGroupAddress(provisioner);
        if (address != null) {
            Group group = new Group(address, this.meshUUID);
            group.setName(name);
            return group;
        }
        return null;
    }

    public Group createGroup(@NonNull UUID addressLabel, @Nullable UUID parentLabel, @NonNull String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Group name cannot be empty");
        }
        int address = MeshAddress.generateVirtualAddress(addressLabel);
        Group group = new Group(addressLabel, parentLabel, this.meshUUID);
        group.setName(name);
        return group;
    }

    public Group createGroup(@NonNull Provisioner provisioner, int address, @NonNull String name) throws IllegalArgumentException {
        if (MeshAddress.isValidVirtualAddress(address)) {
            throw new IllegalArgumentException("Call addGroup(@NonNull final Group group) to create a group with group address label");
        }
        if (provisioner.getAllocatedGroupRanges().isEmpty()) {
            throw new IllegalArgumentException("Unable to create group, there is no group range allocated to the current provisioner");
        }
        for (AllocatedGroupRange range : provisioner.getAllocatedGroupRanges()) {
            if (range.getLowAddress() <= address && range.getHighAddress() >= address) continue;
            throw new IllegalArgumentException("Unable to create group, the address is outside the range allocated to the provisioner");
        }
        Group group = new Group(address, this.meshUUID);
        if (!TextUtils.isEmpty((CharSequence)name)) {
            group.setName(name);
        }
        return group;
    }

    public boolean addGroup(@NonNull Group group) throws IllegalArgumentException {
        Provisioner provisioner = this.getSelectedProvisioner();
        if (provisioner.getAllocatedGroupRanges().isEmpty()) {
            throw new IllegalArgumentException("Unable to create group, there is no group range allocated to the current provisioner");
        }
        if (group.getAddressLabel() == null) {
            for (AllocatedGroupRange range : provisioner.getAllocatedGroupRanges()) {
                if (range.getLowAddress() <= group.getAddress() && range.getHighAddress() >= group.getAddress()) continue;
                throw new IllegalArgumentException("Unable to create group, the address is outside the range allocated to the provisioner");
            }
        }
        return this.insertGroup(group);
    }

    private boolean insertGroup(@NonNull Group group) {
        if (!this.isGroupExist(group)) {
            this.groups.add(group);
            this.notifyGroupAdded(group);
            return true;
        }
        throw new IllegalArgumentException("Group already exists");
    }

    public Group getGroup(int address) {
        for (Group group : this.groups) {
            if (address != group.getAddress()) continue;
            return group;
        }
        return null;
    }

    public boolean updateGroup(@NonNull Group group) {
        if (this.isGroupExist(group)) {
            this.notifyGroupUpdated(group);
            return true;
        }
        return false;
    }

    public boolean removeGroup(@NonNull Group group) {
        if (this.groups.remove(group)) {
            this.notifyGroupDeleted(group);
            return true;
        }
        return false;
    }

    public boolean isGroupExist(int address) {
        for (Group group : this.groups) {
            if (address != group.getAddress()) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupExist(@NonNull Group group) {
        for (Group grp : this.groups) {
            if (group.getAddress() != grp.getAddress()) continue;
            return true;
        }
        return false;
    }

    public List<Element> getElements(Group group) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (ProvisionedMeshNode node : this.nodes) {
            for (Map.Entry<Integer, Element> elementEntry : node.getElements().entrySet()) {
                Element element = elementEntry.getValue();
                for (Map.Entry<Integer, MeshModel> modelEntry : element.getMeshModels().entrySet()) {
                    MeshModel model = modelEntry.getValue();
                    if (model == null) continue;
                    List<Integer> subscriptionAddresses = model.getSubscribedAddresses();
                    for (Integer subscriptionAddress : subscriptionAddresses) {
                        if (group.getAddress() != subscriptionAddress.intValue() || elements.contains(element)) continue;
                        elements.add(element);
                    }
                }
            }
        }
        return elements;
    }

    public List<MeshModel> getModels(Group group) {
        ArrayList<MeshModel> models = new ArrayList<MeshModel>();
        for (ProvisionedMeshNode node : this.nodes) {
            for (Map.Entry<Integer, Element> elementEntry : node.getElements().entrySet()) {
                Element element = elementEntry.getValue();
                for (Map.Entry<Integer, MeshModel> modelEntry : element.getMeshModels().entrySet()) {
                    MeshModel model = modelEntry.getValue();
                    if (model == null) continue;
                    List<Integer> subscriptionAddresses = model.getSubscribedAddresses();
                    for (Integer subscriptionAddress : subscriptionAddresses) {
                        if (group.getAddress() != subscriptionAddress.intValue() || models.contains(model)) continue;
                        models.add(model);
                    }
                }
            }
        }
        return models;
    }

    public List<Scene> getScenes() {
        return this.scenes;
    }

    void setScenes(List<Scene> scenes) {
        this.scenes = scenes;
    }

    public boolean isLastSelected() {
        return this.lastSelected;
    }

    public void setLastSelected(boolean lastSelected) {
        this.lastSelected = lastSelected;
    }

    public List<NetworkKey> getNetKeys() {
        return Collections.unmodifiableList(this.netKeys);
    }

    public NetworkKey getPrimaryNetworkKey() {
        for (NetworkKey networkKey : this.netKeys) {
            if (networkKey.getKeyIndex() != 0) continue;
            return networkKey;
        }
        return null;
    }

    void setNetKeys(List<NetworkKey> netKeys) {
        this.netKeys = netKeys;
    }

    public List<ApplicationKey> getAppKeys() {
        return Collections.unmodifiableList(this.appKeys);
    }

    void setAppKeys(List<ApplicationKey> appKeys) {
        this.appKeys = appKeys;
    }

    public final int getProvisioningFlags() {
        int flags = 0;
        NetworkKey key = this.getPrimaryNetworkKey();
        if (key != null) {
            if (key.getPhase() == 2) {
                flags |= 0x80;
            }
            if (this.ivIndex.isIvUpdateActive()) {
                flags |= 0x40;
            }
        }
        return flags;
    }

    public UUID getLabelUuid(int address) throws IllegalArgumentException {
        if (!MeshAddress.isValidVirtualAddress(address)) {
            throw new IllegalArgumentException("Address type must be a virtual address ");
        }
        for (ProvisionedMeshNode node : this.nodes) {
            for (Map.Entry<Integer, Element> elementEntry : node.getElements().entrySet()) {
                Element element = elementEntry.getValue();
                for (Map.Entry<Integer, MeshModel> modelEntry : element.getMeshModels().entrySet()) {
                    MeshModel model = modelEntry.getValue();
                    if (model == null) continue;
                    if (model.getPublicationSettings() != null && model.getPublicationSettings().getLabelUUID() != null && address == MeshAddress.generateVirtualAddress(model.getPublicationSettings().getLabelUUID())) {
                        return model.getPublicationSettings().getLabelUUID();
                    }
                    UUID label = model.getLabelUUID(address);
                    if (label == null) continue;
                    return label;
                }
            }
        }
        return null;
    }
}

