/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.os.AsyncTask;
import android.util.Log;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.Group;
import no.nordicsemi.android.mesh.IvIndex;
import no.nordicsemi.android.mesh.LoadNetworkCallbacks;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.NodeKey;
import no.nordicsemi.android.mesh.Provisioner;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.data.ApplicationKeyDao;
import no.nordicsemi.android.mesh.data.ApplicationKeysDao;
import no.nordicsemi.android.mesh.data.GroupDao;
import no.nordicsemi.android.mesh.data.GroupsDao;
import no.nordicsemi.android.mesh.data.MeshNetworkDao;
import no.nordicsemi.android.mesh.data.NetworkKeyDao;
import no.nordicsemi.android.mesh.data.NetworkKeysDao;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodeDao;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodesDao;
import no.nordicsemi.android.mesh.data.ProvisionerDao;
import no.nordicsemi.android.mesh.data.ProvisionersDao;
import no.nordicsemi.android.mesh.data.SceneDao;
import no.nordicsemi.android.mesh.data.ScenesDao;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@Database(entities={MeshNetwork.class, NetworkKey.class, ApplicationKey.class, Provisioner.class, ProvisionedMeshNode.class, Group.class, Scene.class}, version=9)
abstract class MeshNetworkDb
extends RoomDatabase {
    private static String TAG = MeshNetworkDb.class.getSimpleName();
    private static volatile MeshNetworkDb INSTANCE;
    private static RoomDatabase.Callback sRoomDatabaseCallback;
    private static final Migration MIGRATION_1_2;
    private static final Migration MIGRATION_2_3;
    private static final Migration MIGRATION_3_4;
    private static final Migration MIGRATION_4_5;
    private static final Migration MIGRATION_5_6;
    private static final Migration MIGRATION_6_7;
    private static final Migration MIGRATION_7_8;
    private static final Migration MIGRATION_8_9;

    MeshNetworkDb() {
    }

    abstract MeshNetworkDao meshNetworkDao();

    abstract NetworkKeyDao networkKeyDao();

    abstract NetworkKeysDao networkKeysDao();

    abstract ApplicationKeyDao applicationKeyDao();

    abstract ApplicationKeysDao applicationKeysDao();

    abstract ProvisionerDao provisionerDao();

    abstract ProvisionersDao provisionersDao();

    abstract ProvisionedMeshNodeDao provisionedMeshNodeDao();

    abstract ProvisionedMeshNodesDao provisionedMeshNodesDao();

    abstract GroupsDao groupsDao();

    abstract GroupDao groupDao();

    abstract ScenesDao scenesDao();

    abstract SceneDao sceneDao();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static MeshNetworkDb getDatabase(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<MeshNetworkDb> clazz = MeshNetworkDb.class;
        synchronized (MeshNetworkDb.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = (MeshNetworkDb)Room.databaseBuilder((Context)context.getApplicationContext(), MeshNetworkDb.class, (String)"mesh_network_database.db").addCallback(sRoomDatabaseCallback).addMigrations(new Migration[]{MIGRATION_1_2}).addMigrations(new Migration[]{MIGRATION_2_3}).addMigrations(new Migration[]{MIGRATION_3_4}).addMigrations(new Migration[]{MIGRATION_4_5}).addMigrations(new Migration[]{MIGRATION_5_6}).addMigrations(new Migration[]{MIGRATION_6_7}).addMigrations(new Migration[]{MIGRATION_7_8}).addMigrations(new Migration[]{MIGRATION_8_9}).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    void insertNetwork(@NonNull MeshNetworkDao dao, @NonNull NetworkKeysDao netKeysDao, @NonNull ApplicationKeysDao appKeysDao, @NonNull ProvisionersDao provisionersDao, @NonNull ProvisionedMeshNodesDao nodesDao, @NonNull GroupsDao groupsDao, @NonNull ScenesDao scenesDao, @NonNull MeshNetwork meshNetwork) {
        new InsertNetworkAsyncTask(dao, netKeysDao, appKeysDao, provisionersDao, nodesDao, groupsDao, scenesDao, meshNetwork).execute(new Void[0]);
    }

    void loadNetwork(@NonNull MeshNetworkDao dao, @NonNull NetworkKeysDao netKeysDao, @NonNull ApplicationKeysDao appKeysDao, @NonNull ProvisionersDao provisionersDao, @NonNull ProvisionedMeshNodesDao nodesDao, @NonNull GroupsDao groupsDao, @NonNull ScenesDao scenesDao, @NonNull LoadNetworkCallbacks listener) {
        new LoadNetworkAsyncTask(dao, netKeysDao, appKeysDao, provisionersDao, nodesDao, groupsDao, scenesDao, listener).execute(new Void[0]);
    }

    void updateNetwork(@NonNull MeshNetworkDao dao, @NonNull MeshNetwork meshNetwork) {
        new UpdateNetworkAsyncTask(dao).execute(new MeshNetwork[]{meshNetwork});
    }

    void updateNetwork1(@NonNull MeshNetwork meshNetwork, @NonNull MeshNetworkDao dao, @NonNull NetworkKeysDao netKeyDao, @NonNull ApplicationKeysDao appKeyDao, @NonNull ProvisionersDao provisionerDao, @NonNull ProvisionedMeshNodesDao nodeDao, @NonNull GroupsDao groupsDao, @NonNull ScenesDao sceneDao) {
        new UpdateNetworkAsyncTask1(dao, netKeyDao, appKeyDao, provisionerDao, nodeDao, groupsDao, sceneDao).execute(new MeshNetwork[]{meshNetwork});
    }

    void deleteNetwork(@NonNull MeshNetworkDao dao, @NonNull MeshNetwork meshNetwork) {
        new DeleteNetworkAsyncTask(dao).execute(new MeshNetwork[]{meshNetwork});
    }

    void insertNetKey(@NonNull NetworkKeyDao dao, @NonNull NetworkKey networkKey) {
        new InsertNetKeyAsyncTask(dao).execute(new NetworkKey[]{networkKey});
    }

    void updateNetKey(@NonNull NetworkKeyDao dao, @NonNull NetworkKey networkKey) {
        new UpdateNetKeyAsyncTask(dao).execute(new NetworkKey[]{networkKey});
    }

    void deleteNetKey(@NonNull NetworkKeyDao dao, @NonNull NetworkKey networkKey) {
        new DeleteNetKeyAsyncTask(dao).execute(new NetworkKey[]{networkKey});
    }

    void insertAppKey(@NonNull ApplicationKeyDao dao, @NonNull ApplicationKey applicationKey) {
        new InsertAppKeyAsyncTask(dao).execute(new ApplicationKey[]{applicationKey});
    }

    void updateAppKey(@NonNull ApplicationKeyDao dao, @NonNull ApplicationKey applicationKey) {
        new UpdateAppKeyAsyncTask(dao).execute(new ApplicationKey[]{applicationKey});
    }

    void deleteAppKey(@NonNull ApplicationKeyDao dao, @NonNull ApplicationKey applicationKey) {
        new DeleteAppKeyAsyncTask(dao).execute(new ApplicationKey[]{applicationKey});
    }

    void insertProvisioner(@NonNull ProvisionerDao dao, @NonNull Provisioner provisioner) {
        new InsertProvisionerAsyncTask(dao).execute(new Provisioner[]{provisioner});
    }

    void updateProvisioner(@NonNull ProvisionerDao dao, @NonNull Provisioner provisioner) {
        new UpdateProvisionerAsyncTask(dao).execute(new Provisioner[]{provisioner});
    }

    void updateProvisioners(@NonNull ProvisionerDao dao, @NonNull List<Provisioner> provisioners) {
        new UpdateProvisionersAsyncTask(dao, provisioners).execute(new Void[0]);
    }

    void deleteProvisioner(@NonNull ProvisionerDao dao, @NonNull Provisioner provisioner) {
        new DeleteProvisionerAsyncTask(dao).execute(new Provisioner[]{provisioner});
    }

    void insertNode(@NonNull ProvisionedMeshNodeDao dao, @NonNull ProvisionedMeshNode node) {
        new InsertNodeAsyncTask(dao).execute(new ProvisionedMeshNode[]{node});
    }

    void updateNode(@NonNull ProvisionedMeshNodeDao dao, @NonNull ProvisionedMeshNode node) {
        new UpdateNodeAsyncTask(dao).execute(new ProvisionedMeshNode[]{node});
    }

    void updateNodes(@NonNull ProvisionedMeshNodesDao dao, @NonNull List<ProvisionedMeshNode> nodes) {
        new UpdateNodesAsyncTask(dao, nodes).execute(new Void[0]);
    }

    void deleteNode(@NonNull ProvisionedMeshNodeDao dao, @NonNull ProvisionedMeshNode node) {
        new DeleteNodeAsyncTask(dao).execute(new ProvisionedMeshNode[]{node});
    }

    void insertGroup(@NonNull GroupDao dao, @NonNull Group group) {
        new InsertGroupAsyncTask(dao).execute(new Group[]{group});
    }

    void updateGroup(@NonNull GroupDao dao, @NonNull Group group) {
        new UpdateGroupAsyncTask(dao).execute(new Group[]{group});
    }

    void updateGroups(@NonNull GroupsDao dao, @NonNull List<Group> groups) {
        new UpdateGroupsAsyncTask(dao, groups).execute(new Void[0]);
    }

    void deleteGroup(@NonNull GroupDao dao, @NonNull Group group) {
        new DeleteGroupAsyncTask(dao).execute(new Group[]{group});
    }

    void insertScene(@NonNull SceneDao dao, @NonNull Scene scene) {
        new InsertSceneAsyncTask(dao).execute(new Scene[]{scene});
    }

    void updateScene(@NonNull SceneDao dao, @NonNull Scene scene) {
        new UpdateSceneKeyAsyncTask(dao).execute(new Scene[]{scene});
    }

    void deleteScene(@NonNull SceneDao dao, @NonNull Scene scene) {
        new DeleteSceneKeyAsyncTask(dao).execute(new Scene[]{scene});
    }

    private static void migrateMeshNetwork(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `mesh_network_temp` (`mesh_uuid` TEXT NOT NULL, `mesh_name` TEXT, `timestamp` INTEGER NOT NULL, `iv_index` INTEGER NOT NULL, `iv_update_state` INTEGER NOT NULL, `unicast_address` INTEGER NOT NULL DEFAULT 0x0001, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`mesh_uuid`))");
        database.execSQL("INSERT INTO mesh_network_temp (mesh_uuid, mesh_name, timestamp, iv_index, iv_update_state, last_selected) SELECT mesh_uuid, mesh_name, timestamp, iv_index, iv_update_state, last_selected FROM mesh_network");
        Cursor cursor = database.query("SELECT * FROM mesh_network");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String uuid = cursor.getString(cursor.getColumnIndex("mesh_uuid"));
                byte[] unicast = cursor.getBlob(cursor.getColumnIndex("unicast_address"));
                short address = MeshAddress.addressBytesToInt(unicast);
                ContentValues values = new ContentValues();
                values.put("unicast_address", Integer.valueOf(address));
                database.update("mesh_network_temp", 5, values, "mesh_uuid = ?", (Object[])new String[]{uuid});
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE mesh_network");
        database.execSQL("ALTER TABLE mesh_network_temp RENAME TO mesh_network");
    }

    private static void migrateNodes(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `nodes_temp` (`timestamp` INTEGER NOT NULL, `mAddedNetworkKeys` TEXT, `name` TEXT, `ttl` INTEGER, `blacklisted` INTEGER NOT NULL, `secureNetworkBeacon` INTEGER, `mesh_uuid` TEXT, `uuid` TEXT NOT NULL, `security` INTEGER NOT NULL, `unicast_address` INTEGER NOT NULL DEFAULT 1, `configured` INTEGER NOT NULL, `device_key` BLOB, `seq_number` INTEGER NOT NULL, `cid` INTEGER, `pid` INTEGER, `vid` INTEGER, `crpl` INTEGER, `mElements` TEXT, `mAddedApplicationKeys` TEXT, `networkTransmitCount` INTEGER, `networkIntervalSteps` INTEGER, `relayTransmitCount` INTEGER, `relayIntervalSteps` INTEGER, `friend` INTEGER, `lowPower` INTEGER, `proxy` INTEGER, `relay` INTEGER, PRIMARY KEY(`uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO nodes_temp (timestamp, mAddedNetworkKeys, name, blacklisted, secureNetworkBeacon, mesh_uuid, security, configured, device_key, seq_number, cid, pid, vid, crpl, mElements, mAddedApplicationKeys, networkTransmitCount, networkIntervalSteps, relayTransmitCount, relayIntervalSteps, friend, lowPower, proxy, relay, uuid, mesh_uuid) SELECT timestamp, mAddedNetworkKeys, name, blacklisted, secureNetworkBeacon, mesh_uuid, security, configured, device_key, seq_number, cid, pid, vid, crpl, mElements, mAddedApplicationKeys, networkTransmitCount, networkIntervalSteps, relayTransmitCount, relayIntervalSteps,friend, lowPower, proxy, relay, uuid, mesh_uuid FROM nodes");
        Cursor cursor = database.query("SELECT * FROM nodes");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String uuid = cursor.getString(cursor.getColumnIndex("uuid"));
                byte[] unicast = cursor.getBlob(cursor.getColumnIndex("unicast_address"));
                short address = MeshAddress.addressBytesToInt(unicast);
                ContentValues values = new ContentValues();
                values.put("unicast_address", Integer.valueOf(address));
                database.update("nodes_temp", 5, values, "uuid = ?", (Object[])new String[]{uuid});
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE nodes");
        database.execSQL("ALTER TABLE nodes_temp RENAME TO nodes");
        database.execSQL("CREATE INDEX index_nodes_mesh_uuid ON `nodes` (mesh_uuid)");
    }

    private static void migrateProvisioner(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `provisioner_temp` (`mesh_uuid` TEXT NOT NULL, `provisioner_uuid` TEXT NOT NULL, `name` TEXT, `allocatedGroupRanges` TEXT, `allocatedUnicastRanges` TEXT, `allocatedSceneRanges` TEXT, `sequence_number` INTEGER NOT NULL, `provisioner_address` INTEGER NOT NULL DEFAULT 32767,`global_ttl` INTEGER NOT NULL, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`provisioner_uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO provisioner_temp (mesh_uuid, provisioner_uuid, name, allocatedGroupRanges, allocatedUnicastRanges, allocatedSceneRanges, sequence_number, global_ttl, last_selected) SELECT mesh_uuid, provisioner_uuid, name, allocatedGroupRanges, allocatedUnicastRanges, allocatedSceneRanges, sequence_number, global_ttl, last_selected FROM provisioner");
        Cursor cursor = database.query("SELECT * FROM provisioner");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String uuid = cursor.getString(cursor.getColumnIndex("provisioner_uuid"));
                byte[] unicast = cursor.getBlob(cursor.getColumnIndex("provisioner_address"));
                short address = MeshAddress.addressBytesToInt(unicast);
                ContentValues values = new ContentValues();
                values.put("provisioner_address", Integer.valueOf(address));
                database.update("provisioner_temp", 5, values, "provisioner_uuid = ?", (Object[])new String[]{uuid});
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE provisioner");
        database.execSQL("ALTER TABLE provisioner_temp RENAME TO provisioner");
        database.execSQL("CREATE INDEX index_provisioner_mesh_uuid ON `provisioner` (mesh_uuid)");
    }

    private static void migrateGroup(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `groups_temp` (`id` INTEGER PRIMARY KEY NOT NULL,`mesh_uuid` TEXT, `name` TEXT, `group_address` INTEGER NOT NULL DEFAULT 49152, `parent_address` INTEGER NOT NULL DEFAULT 49152, FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        Cursor cursor = database.query("SELECT * FROM groups");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String uuid = cursor.getString(cursor.getColumnIndex("mesh_uuid"));
                String name = cursor.getString(cursor.getColumnIndex("name"));
                byte[] grpAddress = cursor.getBlob(cursor.getColumnIndex("group_address"));
                byte[] pAddress = cursor.getBlob(cursor.getColumnIndex("parent_address"));
                int groupAddress = MeshParserUtils.unsignedBytesToInt(grpAddress[1], grpAddress[0]);
                ContentValues values = new ContentValues();
                values.put("mesh_uuid", uuid);
                values.put("name", name);
                values.put("group_address", Integer.valueOf(groupAddress));
                if (pAddress != null) {
                    int parentAddress = MeshParserUtils.unsignedBytesToInt(pAddress[1], pAddress[0]);
                    values.put("parent_address", Integer.valueOf(parentAddress));
                }
                database.insert("groups_temp", 5, values);
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE groups");
        database.execSQL("ALTER TABLE groups_temp RENAME TO groups");
        database.execSQL("CREATE INDEX index_groups_mesh_uuid ON `groups` (mesh_uuid)");
    }

    private static void migrateGroup2_3(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `groups_temp` (`id` INTEGER PRIMARY KEY NOT NULL,`mesh_uuid` TEXT, `name` TEXT, `group_address` INTEGER NOT NULL DEFAULT 49152, `parent_address` INTEGER NOT NULL DEFAULT 0, `group_address_label` TEXT, `parent_address_label` TEXT, FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO groups_temp (id, mesh_uuid, name, group_address, parent_address) SELECT id, mesh_uuid, name, group_address, parent_address FROM groups");
        database.execSQL("DROP TABLE groups");
        database.execSQL("ALTER TABLE groups_temp RENAME TO groups");
        database.execSQL("CREATE INDEX index_groups_mesh_uuid ON `groups` (mesh_uuid)");
    }

    private static void migrateNodes3_4(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `nodes_temp` (`timestamp` INTEGER NOT NULL, `name` TEXT, `ttl` INTEGER, `blacklisted` INTEGER NOT NULL, `secureNetworkBeacon` INTEGER, `mesh_uuid` TEXT, `uuid` TEXT NOT NULL, `security` INTEGER NOT NULL, `unicast_address` INTEGER NOT NULL DEFAULT 1, `configured` INTEGER NOT NULL, `device_key` BLOB, `seq_number` INTEGER NOT NULL, `cid` INTEGER, `pid` INTEGER, `vid` INTEGER, `crpl` INTEGER, `mElements` TEXT, `netKeys` TEXT, `appKeys` TEXT, `networkTransmitCount` INTEGER, `networkIntervalSteps` INTEGER, `relayTransmitCount` INTEGER, `relayIntervalSteps` INTEGER, `friend` INTEGER, `lowPower` INTEGER, `proxy` INTEGER, `relay` INTEGER, PRIMARY KEY(`uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO nodes_temp (timestamp, name, blacklisted, secureNetworkBeacon, mesh_uuid, security, unicast_address, configured, device_key, seq_number, cid, pid, vid, crpl, mElements, networkTransmitCount, networkIntervalSteps, relayTransmitCount, relayIntervalSteps, friend, lowPower, proxy, relay, uuid, mesh_uuid) SELECT timestamp, name, blacklisted, secureNetworkBeacon, mesh_uuid, security, unicast_address, configured, device_key, seq_number, cid, pid, vid, crpl, mElements, networkTransmitCount, networkIntervalSteps, relayTransmitCount, relayIntervalSteps,friend, lowPower, proxy, relay, uuid, mesh_uuid FROM nodes");
        Cursor cursor = database.query("SELECT * FROM nodes");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                ContentValues values = new ContentValues();
                String uuid = cursor.getString(cursor.getColumnIndex("uuid"));
                String netKeysJson = cursor.getString(cursor.getColumnIndex("mAddedNetworkKeys"));
                List<NetworkKey> netKeys = MeshTypeConverters.fromJsonToAddedNetKeys(netKeysJson);
                ArrayList<Integer> keyIndexes = new ArrayList<Integer>();
                for (NetworkKey networkKey : netKeys) {
                    if (networkKey == null) continue;
                    keyIndexes.add(networkKey.getKeyIndex());
                }
                values.put("netKeys", MeshTypeConverters.integerToJson(keyIndexes));
                keyIndexes.clear();
                String appKeysJson = cursor.getString(cursor.getColumnIndex("mAddedApplicationKeys"));
                Map<Integer, ApplicationKey> appKeyMap = MeshTypeConverters.fromJsonToAddedAppKeys(appKeysJson);
                for (Map.Entry<Integer, ApplicationKey> applicationKeyEntry : appKeyMap.entrySet()) {
                    ApplicationKey key = applicationKeyEntry.getValue();
                    if (key == null) continue;
                    keyIndexes.add(key.getKeyIndex());
                }
                values.put("appKeys", MeshTypeConverters.integerToJson(keyIndexes));
                database.update("nodes_temp", 5, values, "uuid = ?", (Object[])new String[]{uuid});
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE nodes");
        database.execSQL("ALTER TABLE nodes_temp RENAME TO nodes");
        database.execSQL("CREATE INDEX index_nodes_mesh_uuid ON `nodes` (mesh_uuid)");
    }

    private static void migrateProvisioner4_5(SupportSQLiteDatabase database) {
        ArrayList<AllocatedUnicastRange> unicastRange = new ArrayList<AllocatedUnicastRange>();
        ArrayList<AllocatedGroupRange> groupRange = new ArrayList<AllocatedGroupRange>();
        ArrayList<AllocatedSceneRange> sceneRange = new ArrayList<AllocatedSceneRange>();
        unicastRange.add(new AllocatedUnicastRange(1, 6554));
        groupRange.add(new AllocatedGroupRange(49152, 52378));
        sceneRange.add(new AllocatedSceneRange(1, 13107));
        database.execSQL("CREATE TABLE `provisioner_temp` (`mesh_uuid` TEXT NOT NULL, `provisioner_uuid` TEXT NOT NULL, `name` TEXT, `allocated_unicast_ranges` TEXT NOT NULL, `allocated_group_ranges` TEXT NOT NULL, `allocated_scene_ranges` TEXT NOT NULL, `sequence_number` INTEGER NOT NULL, `provisioner_address` INTEGER,`global_ttl` INTEGER NOT NULL, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`provisioner_uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO provisioner_temp (mesh_uuid, provisioner_uuid, name, allocated_unicast_ranges, allocated_group_ranges, allocated_scene_ranges, sequence_number, global_ttl, last_selected) SELECT mesh_uuid, provisioner_uuid, name, allocatedUnicastRanges, allocatedGroupRanges, allocatedSceneRanges,sequence_number, global_ttl, last_selected FROM provisioner");
        ArrayList<Provisioner> provisioners = new ArrayList<Provisioner>();
        Cursor cursor = database.query("SELECT * FROM provisioner");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String meshUuid = cursor.getString(cursor.getColumnIndex("mesh_uuid"));
                String uuid = cursor.getString(cursor.getColumnIndex("provisioner_uuid"));
                String name = cursor.getString(cursor.getColumnIndex("name"));
                String unicastRanges = cursor.getString(cursor.getColumnIndex("allocatedUnicastRanges"));
                String groupRanges = cursor.getString(cursor.getColumnIndex("allocatedGroupRanges"));
                String sceneRanges = cursor.getString(cursor.getColumnIndex("allocatedSceneRanges"));
                int sequenceNumber = cursor.getInt(cursor.getColumnIndex("sequence_number"));
                int globalTtl = cursor.getInt(cursor.getColumnIndex("global_ttl"));
                boolean lastSelected = cursor.getInt(cursor.getColumnIndex("last_selected")) == 1;
                int unicast = cursor.getInt(cursor.getColumnIndex("provisioner_address"));
                ContentValues values = new ContentValues();
                values.put("mesh_uuid", meshUuid);
                values.put("provisioner_uuid", uuid);
                values.put("name", name);
                values.put("sequence_number", Integer.valueOf(sequenceNumber));
                values.put("global_ttl", Integer.valueOf(globalTtl));
                values.put("last_selected", Boolean.valueOf(lastSelected));
                if (unicast == 0) {
                    Integer t = null;
                    values.put("provisioner_address", t);
                } else {
                    values.put("provisioner_address", Integer.valueOf(unicast));
                }
                values.put("allocated_unicast_ranges", unicastRanges.equalsIgnoreCase("null") ? MeshTypeConverters.allocatedUnicastRangeToJson(unicastRange) : unicastRanges);
                values.put("allocated_group_ranges", groupRanges.equalsIgnoreCase("null") ? MeshTypeConverters.allocatedGroupRangeToJson(groupRange) : groupRanges);
                values.put("allocated_scene_ranges", sceneRanges.equalsIgnoreCase("null") ? MeshTypeConverters.allocatedSceneRangeToJson(sceneRange) : sceneRanges);
                database.update("provisioner_temp", 5, values, "provisioner_uuid = ?", (Object[])new String[]{uuid});
                Provisioner provisioner = new Provisioner(uuid, unicastRanges.equalsIgnoreCase("null") ? unicastRange : MeshTypeConverters.fromJsonToAllocatedUnicastRanges(unicastRanges), groupRanges.equalsIgnoreCase("null") ? groupRange : MeshTypeConverters.fromJsonToAllocatedGroupRanges(groupRanges), sceneRanges.equalsIgnoreCase("null") ? sceneRange : MeshTypeConverters.fromJsonToAllocatedSceneRanges(sceneRanges), meshUuid);
                provisioner.setProvisionerName(name);
                provisioner.setProvisionerAddress(unicast);
                provisioner.setLastSelected(lastSelected);
                provisioner.setGlobalTtl(globalTtl);
                provisioners.add(provisioner);
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE provisioner");
        database.execSQL("ALTER TABLE provisioner_temp RENAME TO provisioner");
        database.execSQL("CREATE INDEX index_provisioner_mesh_uuid ON `provisioner` (mesh_uuid)");
        MeshNetworkDb.addProvisionerNodes(database, provisioners);
    }

    private static HashMap<UUID, ArrayList<Integer>> getKeyIndexes(@NonNull SupportSQLiteDatabase database, String tableName) {
        Cursor cursor = database.query("SELECT * FROM " + tableName);
        HashMap<UUID, ArrayList<Integer>> netKeyIndexMap = new HashMap<UUID, ArrayList<Integer>>();
        if (cursor != null && cursor.moveToFirst()) {
            UUID meshUuid = UUID.fromString(cursor.getString(cursor.getColumnIndex("mesh_uuid")).toUpperCase(Locale.US));
            do {
                int index = cursor.getInt(cursor.getColumnIndex("index"));
                ArrayList<Integer> indexes = netKeyIndexMap.get(meshUuid);
                if (indexes != null) {
                    indexes.add(index);
                } else {
                    indexes = new ArrayList();
                    indexes.add(index);
                }
                netKeyIndexMap.put(meshUuid, indexes);
            } while (cursor.moveToNext());
        }
        return netKeyIndexMap;
    }

    private static List<NetworkKey> getNetKeys(@NonNull SupportSQLiteDatabase database) {
        ArrayList<NetworkKey> keys = new ArrayList<NetworkKey>();
        Cursor cursor = database.query("SELECT * FROM network_key");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String meshUuid = cursor.getString(cursor.getColumnIndex("mesh_uuid")).toUpperCase(Locale.US);
                int index = cursor.getInt(cursor.getColumnIndex("index"));
                byte[] key = cursor.getBlob(cursor.getColumnIndex("key"));
                NetworkKey networkKey = new NetworkKey(index, key);
                keys.add(networkKey);
            } while (cursor.moveToNext());
        }
        return keys;
    }

    private static List<ApplicationKey> getAppKeys(@NonNull SupportSQLiteDatabase database) {
        ArrayList<ApplicationKey> keys = new ArrayList<ApplicationKey>();
        Cursor cursor = database.query("SELECT * FROM application_key");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String meshUuid = cursor.getString(cursor.getColumnIndex("mesh_uuid")).toUpperCase(Locale.US);
                int index = cursor.getInt(cursor.getColumnIndex("index"));
                byte[] key = cursor.getBlob(cursor.getColumnIndex("key"));
                ApplicationKey applicationKey = new ApplicationKey(index, key);
                keys.add(applicationKey);
            } while (cursor.moveToNext());
        }
        return keys;
    }

    private static void addProvisionerNodes(@NonNull SupportSQLiteDatabase database, @NonNull List<Provisioner> provisioners) {
        if (!provisioners.isEmpty()) {
            List<NetworkKey> netKeys = MeshNetworkDb.getNetKeys(database);
            List<ApplicationKey> appKeys = MeshNetworkDb.getAppKeys(database);
            ArrayList nodes = new ArrayList();
            for (Provisioner provisioner : provisioners) {
                ProvisionedMeshNode node = new ProvisionedMeshNode(provisioner, netKeys, appKeys);
                ContentValues values = new ContentValues();
                values.put("timestamp", Long.valueOf(node.getTimeStamp()));
                values.put("name", node.getNodeName());
                values.put("mesh_uuid", node.getMeshUuid());
                values.put("uuid", node.getUuid());
                values.put("ttl", node.getTtl());
                values.put("blacklisted", Boolean.valueOf(node.isBlackListed()));
                values.put("security", Integer.valueOf(node.getSecurity()));
                values.put("unicast_address", Integer.valueOf(node.getUnicastAddress()));
                values.put("configured", Boolean.valueOf(node.isConfigured()));
                values.put("device_key", node.getDeviceKey());
                values.put("seq_number", Integer.valueOf(node.getSequenceNumber()));
                values.put("mElements", MeshTypeConverters.elementsToJson(node.getElements()));
                ArrayList<Integer> networkKeys = new ArrayList<Integer>();
                for (NetworkKey networkKey : netKeys) {
                    networkKeys.add(networkKey.getKeyIndex());
                }
                ArrayList<Integer> applicationKeys = new ArrayList<Integer>();
                for (ApplicationKey applicationKey : appKeys) {
                    applicationKeys.add(applicationKey.getKeyIndex());
                }
                if (!netKeys.isEmpty()) {
                    values.put("netKeys", MeshTypeConverters.integerToJson(networkKeys));
                }
                if (!appKeys.isEmpty()) {
                    values.put("appKeys", MeshTypeConverters.integerToJson(applicationKeys));
                }
                database.insert("nodes", 5, values);
            }
        }
    }

    private static void migrateMeshNetwork5_6(SupportSQLiteDatabase database) {
        HashMap<UUID, SparseIntArray> nodesMap = new HashMap<UUID, SparseIntArray>();
        Cursor cursor1 = database.query("SELECT mesh_uuid, unicast_address, seq_number FROM nodes");
        if (cursor1 != null && cursor1.moveToFirst()) {
            UUID meshUuid = UUID.fromString(cursor1.getString(cursor1.getColumnIndex("mesh_uuid")).toUpperCase(Locale.US));
            do {
                int unicast = cursor1.getInt(cursor1.getColumnIndex("unicast_address"));
                int seqNumber = cursor1.getInt(cursor1.getColumnIndex("seq_number"));
                SparseIntArray sparseIntArray = (SparseIntArray)nodesMap.get(meshUuid);
                if (sparseIntArray != null) {
                    sparseIntArray.put(unicast, seqNumber);
                } else {
                    sparseIntArray = new SparseIntArray();
                    sparseIntArray.put(unicast, seqNumber);
                }
                nodesMap.put(meshUuid, sparseIntArray);
            } while (cursor1.moveToNext());
            cursor1.close();
        }
        database.execSQL("ALTER TABLE mesh_network RENAME TO mesh_network_temp");
        database.execSQL("CREATE TABLE `mesh_network` (`mesh_uuid` TEXT NOT NULL, `mesh_name` TEXT, `timestamp` INTEGER NOT NULL, `iv_index` INTEGER NOT NULL, `iv_update_state` INTEGER NOT NULL, `sequence_numbers` TEXT NOT NULL, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`mesh_uuid`))");
        Cursor cursor = database.query("SELECT * FROM mesh_network_temp");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String meshUuid = cursor.getString(cursor.getColumnIndex("mesh_uuid")).toUpperCase(Locale.US);
                String meshName = cursor.getString(cursor.getColumnIndex("mesh_name"));
                long timestamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
                int ivIndex = cursor.getInt(cursor.getColumnIndex("iv_index"));
                int ivUpdateState = cursor.getInt(cursor.getColumnIndex("iv_update_state"));
                boolean lastSelected = cursor.getInt(cursor.getColumnIndex("last_selected")) == 1;
                SparseIntArray sequenceNumbersArray = (SparseIntArray)nodesMap.get(UUID.fromString(meshUuid));
                ContentValues values = new ContentValues();
                values.put("mesh_uuid", meshUuid);
                values.put("mesh_name", meshName);
                values.put("timestamp", Long.valueOf(timestamp));
                values.put("iv_index", Integer.valueOf(ivIndex));
                values.put("iv_update_state", Integer.valueOf(ivUpdateState));
                if (sequenceNumbersArray != null) {
                    values.put("sequence_numbers", MeshTypeConverters.sparseIntArrayToJson(sequenceNumbersArray));
                }
                values.put("last_selected", Boolean.valueOf(lastSelected));
                database.insert("mesh_network", 5, values);
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE mesh_network_temp");
    }

    private static void migrateKeyIndexes6_7(@NonNull SupportSQLiteDatabase database) {
        Cursor cursor = database.query("SELECT uuid, netKeys, appKeys FROM nodes");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                try {
                    ContentValues values = new ContentValues();
                    String uuid = cursor.getString(cursor.getColumnIndex("uuid"));
                    String netKeysJson = cursor.getString(cursor.getColumnIndex("netKeys"));
                    List<Integer> netKeys = MeshTypeConverters.fromJsonToIntegerList(netKeysJson);
                    ArrayList<NodeKey> netKeyIndexes = new ArrayList<NodeKey>();
                    for (Integer keyIndex : netKeys) {
                        if (keyIndex == null) continue;
                        netKeyIndexes.add(new NodeKey(keyIndex, false));
                    }
                    values.put("netKeys", MeshTypeConverters.nodeKeysToJson(netKeyIndexes));
                    ArrayList<NodeKey> appKeyIndexes = new ArrayList<NodeKey>();
                    String appKeysJson = cursor.getString(cursor.getColumnIndex("appKeys"));
                    List<Integer> appKeys = MeshTypeConverters.fromJsonToIntegerList(appKeysJson);
                    for (Integer keyIndex : appKeys) {
                        appKeyIndexes.add(new NodeKey(keyIndex, false));
                    }
                    values.put("appKeys", MeshTypeConverters.nodeKeysToJson(appKeyIndexes));
                    database.update("nodes", 5, values, "uuid = ?", (Object[])new String[]{uuid});
                }
                catch (Exception ex) {
                    Log.v((String)TAG, (String)"Something went wrong while migrating data");
                }
            } while (cursor.moveToNext());
            cursor.close();
        }
    }

    private static void migrateMeshNetwork7_8(@NonNull SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `mesh_network_temp` (`mesh_uuid` TEXT NOT NULL, `mesh_name` TEXT, `timestamp` INTEGER NOT NULL, `iv_index` TEXT NOT NULL, `sequence_numbers` TEXT NOT NULL, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`mesh_uuid`))");
        Cursor cursor = database.query("SELECT * FROM mesh_network");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String uuid = cursor.getString(cursor.getColumnIndex("mesh_uuid"));
                String meshName = cursor.getString(cursor.getColumnIndex("mesh_name"));
                long timestamp = cursor.getInt(cursor.getColumnIndex("timestamp"));
                int ivIndex = cursor.getInt(cursor.getColumnIndex("iv_index"));
                int ivUpdateState = cursor.getInt(cursor.getColumnIndex("iv_update_state"));
                String sequenceNumbers = cursor.getString(cursor.getColumnIndex("sequence_numbers"));
                int lastSelected = cursor.getInt(cursor.getColumnIndex("last_selected"));
                ContentValues values = new ContentValues();
                values.put("mesh_uuid", uuid);
                values.put("mesh_name", meshName);
                values.put("timestamp", Long.valueOf(timestamp));
                values.put("iv_index", MeshTypeConverters.ivIndexToJson(new IvIndex(ivIndex, ivUpdateState == 1, Calendar.getInstance())));
                values.put("sequence_numbers", sequenceNumbers);
                values.put("last_selected", Integer.valueOf(lastSelected));
                database.insert("mesh_network_temp", 5, values);
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE mesh_network");
        database.execSQL("ALTER TABLE mesh_network_temp RENAME TO mesh_network");
    }

    private static void migrateProvisioner8_9(@NonNull SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `provisioner_temp` (`provisioner_uuid` TEXT NOT NULL, `mesh_uuid` TEXT NOT NULL, `name` TEXT, `allocated_unicast_ranges` TEXT NOT NULL, `allocated_group_ranges` TEXT NOT NULL, `allocated_scene_ranges` TEXT NOT NULL, `provisioner_address` INTEGER,`global_ttl` INTEGER NOT NULL, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`provisioner_uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO provisioner_temp (provisioner_uuid,  mesh_uuid, name,  allocated_unicast_ranges, allocated_group_ranges, allocated_scene_ranges, provisioner_address, global_ttl, last_selected) SELECT provisioner_uuid, mesh_uuid, name,allocated_unicast_ranges, allocated_group_ranges, allocated_scene_ranges,provisioner_address, global_ttl, last_selected FROM provisioner");
        database.execSQL("DROP TABLE provisioner");
        database.execSQL("CREATE INDEX index_provisioner_mesh_uuid ON `provisioner_temp` (mesh_uuid)");
        database.execSQL("ALTER TABLE provisioner_temp RENAME TO provisioner");
    }

    static {
        sRoomDatabaseCallback = new RoomDatabase.Callback(){

            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                super.onOpen(db);
            }
        };
        MIGRATION_1_2 = new Migration(1, 2){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateMeshNetwork(database);
                MeshNetworkDb.migrateNodes(database);
                MeshNetworkDb.migrateProvisioner(database);
                MeshNetworkDb.migrateGroup(database);
            }
        };
        MIGRATION_2_3 = new Migration(2, 3){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateGroup2_3(database);
            }
        };
        MIGRATION_3_4 = new Migration(3, 4){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateNodes3_4(database);
            }
        };
        MIGRATION_4_5 = new Migration(4, 5){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateProvisioner4_5(database);
            }
        };
        MIGRATION_5_6 = new Migration(5, 6){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateMeshNetwork5_6(database);
            }
        };
        MIGRATION_6_7 = new Migration(6, 7){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateKeyIndexes6_7(database);
            }
        };
        MIGRATION_7_8 = new Migration(7, 8){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateMeshNetwork7_8(database);
            }
        };
        MIGRATION_8_9 = new Migration(8, 9){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateProvisioner8_9(database);
            }
        };
    }

    private static class DeleteSceneKeyAsyncTask
    extends AsyncTask<Scene, Void, Void> {
        private final SceneDao mAsyncTaskDao;

        DeleteSceneKeyAsyncTask(@NonNull SceneDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(Scene ... params) {
            this.mAsyncTaskDao.delete(params[0]);
            return null;
        }
    }

    private static class UpdateSceneKeyAsyncTask
    extends AsyncTask<Scene, Void, Void> {
        private final SceneDao mAsyncTaskDao;

        UpdateSceneKeyAsyncTask(@NonNull SceneDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(Scene ... params) {
            this.mAsyncTaskDao.update(params[0]);
            return null;
        }
    }

    private static class InsertSceneAsyncTask
    extends AsyncTask<Scene, Void, Void> {
        private SceneDao mAsyncTaskDao;

        InsertSceneAsyncTask(@NonNull SceneDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(Scene ... params) {
            this.mAsyncTaskDao.insert(params[0]);
            return null;
        }
    }

    private static class DeleteGroupAsyncTask
    extends AsyncTask<Group, Void, Void> {
        private GroupDao mAsyncTaskDao;

        DeleteGroupAsyncTask(@NonNull GroupDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(Group ... params) {
            this.mAsyncTaskDao.delete(params[0]);
            return null;
        }
    }

    private static class UpdateGroupsAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private final GroupsDao mAsyncTaskDao;
        private final List<Group> mGroups;

        UpdateGroupsAsyncTask(@NonNull GroupsDao dao, @NonNull List<Group> groups) {
            this.mAsyncTaskDao = dao;
            this.mGroups = groups;
        }

        protected Void doInBackground(Void ... voids) {
            this.mAsyncTaskDao.update(this.mGroups);
            return null;
        }
    }

    private static class UpdateGroupAsyncTask
    extends AsyncTask<Group, Void, Void> {
        private final GroupDao mAsyncTaskDao;

        UpdateGroupAsyncTask(@NonNull GroupDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(Group ... params) {
            this.mAsyncTaskDao.update(params[0]);
            return null;
        }
    }

    private static class InsertGroupAsyncTask
    extends AsyncTask<Group, Void, Void> {
        private final GroupDao mAsyncTaskDao;

        InsertGroupAsyncTask(@NonNull GroupDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(Group ... params) {
            this.mAsyncTaskDao.insert(params[0]);
            return null;
        }
    }

    private static class DeleteNodeAsyncTask
    extends AsyncTask<ProvisionedMeshNode, Void, Void> {
        private ProvisionedMeshNodeDao mAsyncTaskDao;

        DeleteNodeAsyncTask(@NonNull ProvisionedMeshNodeDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(ProvisionedMeshNode ... params) {
            this.mAsyncTaskDao.delete(params[0]);
            return null;
        }
    }

    private static class UpdateNodesAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private ProvisionedMeshNodesDao mAsyncTaskDao;
        private List<ProvisionedMeshNode> nodes;

        UpdateNodesAsyncTask(@NonNull ProvisionedMeshNodesDao dao, @NonNull List<ProvisionedMeshNode> nodes) {
            this.mAsyncTaskDao = dao;
            this.nodes = nodes;
        }

        protected Void doInBackground(Void ... params) {
            this.mAsyncTaskDao.update(this.nodes);
            return null;
        }
    }

    private static class UpdateNodeAsyncTask
    extends AsyncTask<ProvisionedMeshNode, Void, Void> {
        private ProvisionedMeshNodeDao mAsyncTaskDao;

        UpdateNodeAsyncTask(@NonNull ProvisionedMeshNodeDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(ProvisionedMeshNode ... params) {
            this.mAsyncTaskDao.update(params[0]);
            return null;
        }
    }

    private static class InsertNodeAsyncTask
    extends AsyncTask<ProvisionedMeshNode, Void, Void> {
        private ProvisionedMeshNodeDao mAsyncTaskDao;

        InsertNodeAsyncTask(@NonNull ProvisionedMeshNodeDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(ProvisionedMeshNode ... params) {
            this.mAsyncTaskDao.insert(params[0]);
            return null;
        }
    }

    private static class DeleteProvisionerAsyncTask
    extends AsyncTask<Provisioner, Void, Void> {
        private final ProvisionerDao mAsyncTaskDao;

        DeleteProvisionerAsyncTask(@NonNull ProvisionerDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(Provisioner ... params) {
            this.mAsyncTaskDao.delete(params[0]);
            return null;
        }
    }

    private static class UpdateProvisionersAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private final ProvisionerDao mAsyncTaskDao;
        private final List<Provisioner> provisioners;

        UpdateProvisionersAsyncTask(@NonNull ProvisionerDao dao, @NonNull List<Provisioner> provisioners) {
            this.mAsyncTaskDao = dao;
            this.provisioners = provisioners;
        }

        protected Void doInBackground(Void ... voids) {
            this.mAsyncTaskDao.update(this.provisioners);
            return null;
        }
    }

    private static class UpdateProvisionerAsyncTask
    extends AsyncTask<Provisioner, Void, Void> {
        private final ProvisionerDao mAsyncTaskDao;

        UpdateProvisionerAsyncTask(@NonNull ProvisionerDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(Provisioner ... params) {
            this.mAsyncTaskDao.update(params[0]);
            return null;
        }
    }

    private static class InsertProvisionerAsyncTask
    extends AsyncTask<Provisioner, Void, Void> {
        private final ProvisionerDao mAsyncTaskDao;

        InsertProvisionerAsyncTask(@NonNull ProvisionerDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(Provisioner ... params) {
            this.mAsyncTaskDao.insert(params[0]);
            return null;
        }
    }

    private static class DeleteAppKeyAsyncTask
    extends AsyncTask<ApplicationKey, Void, Void> {
        private ApplicationKeyDao mAsyncTaskDao;

        DeleteAppKeyAsyncTask(@NonNull ApplicationKeyDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(ApplicationKey ... params) {
            this.mAsyncTaskDao.delete(params[0]);
            return null;
        }
    }

    private static class UpdateAppKeyAsyncTask
    extends AsyncTask<ApplicationKey, Void, Void> {
        private ApplicationKeyDao mAsyncTaskDao;

        UpdateAppKeyAsyncTask(@NonNull ApplicationKeyDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(ApplicationKey ... params) {
            this.mAsyncTaskDao.update(params[0]);
            return null;
        }
    }

    private static class InsertAppKeyAsyncTask
    extends AsyncTask<ApplicationKey, Void, Void> {
        private ApplicationKeyDao mAsyncTaskDao;

        InsertAppKeyAsyncTask(@NonNull ApplicationKeyDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(ApplicationKey ... params) {
            this.mAsyncTaskDao.insert(params[0]);
            return null;
        }
    }

    private static class DeleteNetKeyAsyncTask
    extends AsyncTask<NetworkKey, Void, Void> {
        private NetworkKeyDao mAsyncTaskDao;

        DeleteNetKeyAsyncTask(@NonNull NetworkKeyDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(NetworkKey ... params) {
            this.mAsyncTaskDao.delete(params[0]);
            return null;
        }
    }

    private static class UpdateNetKeyAsyncTask
    extends AsyncTask<NetworkKey, Void, Void> {
        private NetworkKeyDao mAsyncTaskDao;

        UpdateNetKeyAsyncTask(@NonNull NetworkKeyDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(NetworkKey ... params) {
            this.mAsyncTaskDao.update(params[0]);
            return null;
        }
    }

    private static class InsertNetKeyAsyncTask
    extends AsyncTask<NetworkKey, Void, Void> {
        private NetworkKeyDao mAsyncTaskDao;

        InsertNetKeyAsyncTask(@NonNull NetworkKeyDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(NetworkKey ... params) {
            this.mAsyncTaskDao.insert(params[0]);
            return null;
        }
    }

    private static class DeleteNetworkAsyncTask
    extends AsyncTask<MeshNetwork, Void, Void> {
        private MeshNetworkDao mAsyncTaskDao;

        DeleteNetworkAsyncTask(@NonNull MeshNetworkDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(MeshNetwork ... params) {
            this.mAsyncTaskDao.delete(params[0]);
            return null;
        }
    }

    private static class UpdateNetworkAsyncTask1
    extends AsyncTask<MeshNetwork, Void, Void> {
        private final MeshNetworkDao meshNetworkDao;
        private final NetworkKeysDao netKeyDao;
        private final ApplicationKeysDao appKeyDao;
        private final ProvisionersDao provisionersDao;
        private final ProvisionedMeshNodesDao nodesDao;
        private final GroupsDao groupsDao;
        private final ScenesDao sceneDao;

        UpdateNetworkAsyncTask1(@NonNull MeshNetworkDao meshNetworkDao, @NonNull NetworkKeysDao netKeysDao, @NonNull ApplicationKeysDao appKeysDao, @NonNull ProvisionersDao provisionersDao, @NonNull ProvisionedMeshNodesDao nodesDao, @NonNull GroupsDao groupsDao, @NonNull ScenesDao scenesDao) {
            this.meshNetworkDao = meshNetworkDao;
            this.netKeyDao = netKeysDao;
            this.appKeyDao = appKeysDao;
            this.provisionersDao = provisionersDao;
            this.nodesDao = nodesDao;
            this.groupsDao = groupsDao;
            this.sceneDao = scenesDao;
        }

        protected Void doInBackground(MeshNetwork ... params) {
            MeshNetwork network = params[0];
            this.meshNetworkDao.update(network);
            this.netKeyDao.update(network.getNetKeys());
            this.appKeyDao.update(network.getAppKeys());
            this.provisionersDao.update(network.getProvisioners());
            this.nodesDao.update(network.getNodes());
            this.groupsDao.update(network.getGroups());
            this.sceneDao.update(network.getScenes());
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
        }
    }

    private static class UpdateNetworkAsyncTask
    extends AsyncTask<MeshNetwork, Void, Void> {
        private MeshNetworkDao mAsyncTaskDao;

        UpdateNetworkAsyncTask(@NonNull MeshNetworkDao dao) {
            this.mAsyncTaskDao = dao;
        }

        protected Void doInBackground(MeshNetwork ... params) {
            this.mAsyncTaskDao.update(params[0]);
            return null;
        }
    }

    private static class LoadNetworkAsyncTask
    extends AsyncTask<Void, Void, MeshNetwork> {
        private final LoadNetworkCallbacks listener;
        private final MeshNetworkDao meshNetworkDao;
        private final NetworkKeysDao netKeysDao;
        private final ApplicationKeysDao appKeysDao;
        private final ProvisionersDao provisionersDao;
        private final ProvisionedMeshNodesDao nodesDao;
        private final GroupsDao groupsDao;
        private final ScenesDao sceneDao;

        LoadNetworkAsyncTask(@NonNull MeshNetworkDao meshNetworkDao, @NonNull NetworkKeysDao netKeysDao, @NonNull ApplicationKeysDao appKeysDao, @NonNull ProvisionersDao provisionersDao, @NonNull ProvisionedMeshNodesDao nodesDao, @NonNull GroupsDao groupsDao, @NonNull ScenesDao sceneDao, @NonNull LoadNetworkCallbacks listener) {
            this.meshNetworkDao = meshNetworkDao;
            this.netKeysDao = netKeysDao;
            this.appKeysDao = appKeysDao;
            this.provisionersDao = provisionersDao;
            this.nodesDao = nodesDao;
            this.groupsDao = groupsDao;
            this.sceneDao = sceneDao;
            this.listener = listener;
        }

        protected MeshNetwork doInBackground(Void ... params) {
            MeshNetwork meshNetwork = this.meshNetworkDao.getMeshNetwork(true);
            if (meshNetwork != null) {
                meshNetwork.netKeys = this.netKeysDao.loadNetworkKeys(meshNetwork.getMeshUUID());
                meshNetwork.appKeys = this.appKeysDao.loadApplicationKeys(meshNetwork.getMeshUUID());
                meshNetwork.nodes = this.nodesDao.getNodes(meshNetwork.getMeshUUID());
                meshNetwork.provisioners = this.provisionersDao.getProvisioners(meshNetwork.getMeshUUID());
                meshNetwork.groups = this.groupsDao.loadGroups(meshNetwork.getMeshUUID());
            }
            return meshNetwork;
        }

        protected void onPostExecute(MeshNetwork meshNetwork) {
            super.onPostExecute((Object)meshNetwork);
            this.listener.onNetworkLoadedFromDb(meshNetwork);
        }
    }

    private static class InsertNetworkAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private final MeshNetwork meshNetwork;
        private final MeshNetworkDao meshNetworkDao;
        private final NetworkKeysDao netKeysDao;
        private final ApplicationKeysDao appKeysDao;
        private final ProvisionersDao provisionersDao;
        private final ProvisionedMeshNodesDao nodesDao;
        private final GroupsDao groupsDao;
        private final ScenesDao scenesDao;

        InsertNetworkAsyncTask(@NonNull MeshNetworkDao meshNetworkDao, @NonNull NetworkKeysDao netKeysDao, @NonNull ApplicationKeysDao appKeysDao, @NonNull ProvisionersDao provisionersDao, @NonNull ProvisionedMeshNodesDao nodesDao, @NonNull GroupsDao groupsDao, @NonNull ScenesDao scenesDao, @NonNull MeshNetwork meshNetwork) {
            this.meshNetworkDao = meshNetworkDao;
            this.netKeysDao = netKeysDao;
            this.appKeysDao = appKeysDao;
            this.provisionersDao = provisionersDao;
            this.nodesDao = nodesDao;
            this.groupsDao = groupsDao;
            this.scenesDao = scenesDao;
            this.meshNetwork = meshNetwork;
        }

        protected Void doInBackground(Void ... params) {
            this.meshNetworkDao.insert(this.meshNetwork);
            this.netKeysDao.insert(this.meshNetwork.netKeys);
            this.appKeysDao.insert(this.meshNetwork.appKeys);
            this.provisionersDao.insert(this.meshNetwork.provisioners);
            if (!this.meshNetwork.nodes.isEmpty()) {
                this.nodesDao.insert(this.meshNetwork.nodes);
            }
            if (this.meshNetwork.groups != null) {
                this.groupsDao.insert(this.meshNetwork.groups);
            }
            if (this.meshNetwork.scenes != null) {
                this.scenesDao.insert(this.meshNetwork.scenes);
            }
            return null;
        }
    }
}

