/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.UUID;
import no.nordicsemi.android.mesh.InternalMeshManagerCallbacks;
import no.nordicsemi.android.mesh.InternalProvisioningCallbacks;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshProvisioningStatusCallbacks;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningCapabilities;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningCapabilitiesState;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningCompleteState;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningConfirmationState;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningDataState;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningFailedState;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningInputCompleteState;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningInviteState;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningPublicKeyState;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningRandomConfirmationState;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningStartState;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningState;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.InputOOBAction;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.OutputOOBAction;
import no.nordicsemi.android.mesh.utils.StaticOOBType;

class MeshProvisioningHandler
implements InternalProvisioningCallbacks {
    private static final String TAG = MeshProvisioningHandler.class.getSimpleName();
    static final int ATTENTION_TIMER = 5;
    private final InternalTransportCallbacks mInternalTransportCallbacks;
    private final Context mContext;
    private MeshProvisioningStatusCallbacks mStatusCallbacks;
    private UnprovisionedMeshNode mUnprovisionedMeshNode;
    private byte attentionTimer = (byte)5;
    private ProvisioningState provisioningState;
    private boolean isProvisioningPublicKeySent;
    private boolean isProvisioneePublicKeyReceived;
    private InternalMeshManagerCallbacks mInternalMeshManagerCallbacks;
    private byte[] confirmationInputs;

    MeshProvisioningHandler(Context context, InternalTransportCallbacks mInternalTransportCallbacks, InternalMeshManagerCallbacks internalMeshManagerCallbacks) {
        this.mContext = context;
        this.mInternalTransportCallbacks = mInternalTransportCallbacks;
        this.mInternalMeshManagerCallbacks = internalMeshManagerCallbacks;
    }

    public UnprovisionedMeshNode getMeshNode() {
        return this.mUnprovisionedMeshNode;
    }

    void setProvisioningCallbacks(MeshProvisioningStatusCallbacks provisioningCallbacks) {
        this.mStatusCallbacks = provisioningCallbacks;
    }

    void parseProvisioningNotifications(byte[] data) {
        UnprovisionedMeshNode unprovisionedMeshNode = this.mUnprovisionedMeshNode;
        try {
            switch (this.provisioningState.getState()) {
                case PROVISIONING_INVITE: {
                    break;
                }
                case PROVISIONING_CAPABILITIES: {
                    if (this.validateMessage(data)) {
                        if (this.parseProvisioningCapabilitiesMessage(unprovisionedMeshNode, data)) break;
                        this.parseProvisioningState(unprovisionedMeshNode, data);
                        break;
                    }
                    this.parseProvisioningState(unprovisionedMeshNode, data);
                    break;
                }
                case PROVISIONING_START: {
                    break;
                }
                case PROVISIONING_PUBLIC_KEY: {
                    if (this.validateMessage(data)) {
                        this.parseProvisioneePublicKeyXY(unprovisionedMeshNode, data);
                        break;
                    }
                    this.parseProvisioningState(unprovisionedMeshNode, data);
                    break;
                }
                case PROVISIONING_INPUT_COMPLETE: {
                    if (this.validateMessage(data)) {
                        if (!this.parseProvisioningInputCompleteState(data)) break;
                        this.sendProvisioningConfirmation(null);
                        break;
                    }
                    this.parseProvisioningState(unprovisionedMeshNode, data);
                    break;
                }
                case PROVISIONING_CONFIRMATION: {
                    if (this.validateMessage(data)) {
                        if (!this.parseProvisioneeConfirmation(data)) break;
                        this.sendRandomConfirmationPDU(unprovisionedMeshNode);
                        break;
                    }
                    this.parseProvisioningState(unprovisionedMeshNode, data);
                    break;
                }
                case PROVISIONING_RANDOM: {
                    if (this.validateMessage(data)) {
                        if (!this.parseProvisioneeRandom(data)) break;
                        this.sendProvisioningData(unprovisionedMeshNode);
                        break;
                    }
                    this.parseProvisioningState(unprovisionedMeshNode, data);
                    break;
                }
                case PROVISIONING_DATA: 
                case PROVISIONING_COMPLETE: 
                case PROVISIONING_FAILED: {
                    this.parseProvisioningState(unprovisionedMeshNode, data);
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Exception in " + this.provisioningState.getState().name() + " : " + ex.getMessage()));
            this.parseProvisioningState(unprovisionedMeshNode, data);
        }
    }

    void handleProvisioningWriteCallbacks() {
        UnprovisionedMeshNode unprovisionedMeshNode = this.mUnprovisionedMeshNode;
        switch (this.provisioningState.getState()) {
            case PROVISIONING_INVITE: {
                this.provisioningState = new ProvisioningCapabilitiesState(unprovisionedMeshNode, this.mStatusCallbacks);
                break;
            }
            case PROVISIONING_CAPABILITIES: {
                break;
            }
            case PROVISIONING_START: 
            case PROVISIONING_PUBLIC_KEY: {
                this.sendProvisionerPublicKey(unprovisionedMeshNode);
                break;
            }
            case PROVISIONING_INPUT_COMPLETE: {
                break;
            }
            case PROVISIONING_CONFIRMATION: {
                break;
            }
            case PROVISIONING_RANDOM: {
                break;
            }
        }
    }

    private void parseProvisioningState(UnprovisionedMeshNode unprovisionedMeshNode, byte[] data) {
        this.isProvisioningPublicKeySent = false;
        this.isProvisioneePublicKeyReceived = false;
        if (data[1] == ProvisioningState.State.PROVISIONING_COMPLETE.getState()) {
            this.provisioningState = new ProvisioningCompleteState(unprovisionedMeshNode);
            ProvisionedMeshNode provisionedMeshNode = new ProvisionedMeshNode(unprovisionedMeshNode);
            this.mInternalMeshManagerCallbacks.onNodeProvisioned(provisionedMeshNode);
            this.mStatusCallbacks.onProvisioningCompleted(provisionedMeshNode, ProvisioningState.States.PROVISIONING_COMPLETE, data);
        } else {
            ProvisioningFailedState provisioningFailedState = new ProvisioningFailedState();
            this.provisioningState = provisioningFailedState;
            if (provisioningFailedState.parseData(data)) {
                this.mStatusCallbacks.onProvisioningFailed(unprovisionedMeshNode, ProvisioningState.States.PROVISIONING_FAILED, data);
            }
        }
    }

    private UnprovisionedMeshNode initializeMeshNode(@NonNull UUID uuid, @NonNull NetworkKey networkKey, int flags, int ivIndex, int globalTtl) throws IllegalArgumentException {
        UnprovisionedMeshNode unprovisionedMeshNode = null;
        if (this.validateProvisioningDataInput(networkKey, flags, ivIndex)) {
            byte[] flagBytes = ByteBuffer.allocate(1).put((byte)flags).array();
            byte[] ivIndexBytes = null;
            if (MeshParserUtils.validateIvIndexInput(this.mContext, ivIndex)) {
                ivIndexBytes = ByteBuffer.allocate(4).putInt(ivIndex).array();
            }
            unprovisionedMeshNode = new UnprovisionedMeshNode(uuid);
            unprovisionedMeshNode.setNetworkKey(networkKey.getKey());
            unprovisionedMeshNode.setKeyIndex(networkKey.getKeyIndex());
            unprovisionedMeshNode.setFlags(flagBytes);
            unprovisionedMeshNode.setIvIndex(ivIndexBytes);
            unprovisionedMeshNode.setTtl(globalTtl);
            this.mUnprovisionedMeshNode = unprovisionedMeshNode;
        }
        return unprovisionedMeshNode;
    }

    private boolean validateProvisioningDataInput(NetworkKey networkKey, Integer flags, Integer ivIndex) {
        if (networkKey == null) {
            String error = "Network key cannot be null or empty!";
            throw new IllegalArgumentException(error);
        }
        if (networkKey.getKey() == null || networkKey.getKey().length != 16) {
            String error = "Network key length must be 16 octets!";
            throw new IllegalArgumentException(error);
        }
        if (flags == null) {
            String error = "Flags cannot be null!";
            throw new IllegalArgumentException(error);
        }
        if (ivIndex == null) {
            String error = "IV Index cannot be null!";
            throw new IllegalArgumentException(error);
        }
        return true;
    }

    void identify(@NonNull UUID uuid, @NonNull NetworkKey networkKey, int flags, int ivIndex, int globalTtl, int attentionTimer) throws IllegalArgumentException {
        this.confirmationInputs = null;
        this.attentionTimer = (byte)attentionTimer;
        UnprovisionedMeshNode unprovisionedMeshNode = this.initializeMeshNode(uuid, networkKey, flags, ivIndex, globalTtl);
        this.sendProvisioningInvite(unprovisionedMeshNode);
    }

    void startProvisioningNoOOB(@NonNull UnprovisionedMeshNode unprovisionedMeshNode) throws IllegalArgumentException {
        this.sendProvisioningStart(unprovisionedMeshNode);
    }

    void startProvisioningWithStaticOOB(@NonNull UnprovisionedMeshNode unprovisionedMeshNode) throws IllegalArgumentException {
        this.sendProvisioningStartWithStaticOOB(unprovisionedMeshNode);
    }

    void startProvisioningWithOutputOOB(@NonNull UnprovisionedMeshNode unprovisionedMeshNode, @NonNull OutputOOBAction action) throws IllegalArgumentException {
        this.sendProvisioningStartWithOutputOOB(unprovisionedMeshNode, action);
    }

    void startProvisioningWithInputOOB(@NonNull UnprovisionedMeshNode unprovisionedMeshNode, @NonNull InputOOBAction action) throws IllegalArgumentException {
        this.sendProvisioningStartWithInputOOB(unprovisionedMeshNode, action);
    }

    private void sendProvisioningInvite(UnprovisionedMeshNode unprovisionedMeshNode) {
        this.isProvisioningPublicKeySent = false;
        this.isProvisioneePublicKeyReceived = false;
        ProvisioningInviteState invite = new ProvisioningInviteState(unprovisionedMeshNode, this.attentionTimer, this.mInternalTransportCallbacks, this.mStatusCallbacks);
        this.provisioningState = invite;
        invite.executeSend();
    }

    private boolean parseProvisioningCapabilitiesMessage(UnprovisionedMeshNode unprovisionedMeshNode, byte[] capabilities) {
        ProvisioningCapabilitiesState provisioningCapabilitiesState = new ProvisioningCapabilitiesState(unprovisionedMeshNode, this.mStatusCallbacks);
        this.provisioningState = provisioningCapabilitiesState;
        return provisioningCapabilitiesState.parseData(capabilities);
    }

    private void sendProvisioningStart(UnprovisionedMeshNode unprovisionedMeshNode) {
        ProvisioningCapabilitiesState capabilitiesState = (ProvisioningCapabilitiesState)this.provisioningState;
        ProvisioningCapabilities capabilities = capabilitiesState.getCapabilities();
        ProvisioningStartState startProvisioning = new ProvisioningStartState(unprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
        startProvisioning.setProvisioningCapabilities(capabilities.getNumberOfElements(), capabilities.getRawAlgorithm(), capabilities.getRawPublicKeyType(), capabilities.getRawStaticOOBType(), capabilities.getOutputOOBSize(), capabilities.getRawOutputOOBAction(), capabilities.getInputOOBSize(), capabilities.getRawInputOOBAction());
        this.provisioningState = startProvisioning;
        startProvisioning.executeSend();
    }

    private void sendProvisioningStartWithStaticOOB(UnprovisionedMeshNode unprovisionedMeshNode) {
        ProvisioningCapabilitiesState capabilitiesState = (ProvisioningCapabilitiesState)this.provisioningState;
        ProvisioningCapabilities capabilities = capabilitiesState.getCapabilities();
        ProvisioningStartState startProvisioning = new ProvisioningStartState(unprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
        startProvisioning.setProvisioningCapabilities(capabilities.getNumberOfElements(), capabilities.getRawAlgorithm(), capabilities.getRawPublicKeyType(), capabilities.getRawStaticOOBType(), capabilities.getOutputOOBSize(), capabilities.getRawOutputOOBAction(), capabilities.getInputOOBSize(), capabilities.getRawInputOOBAction());
        startProvisioning.setUseStaticOOB(StaticOOBType.STATIC_OOB_AVAILABLE);
        this.provisioningState = startProvisioning;
        startProvisioning.executeSend();
    }

    private void sendProvisioningStartWithOutputOOB(UnprovisionedMeshNode unprovisionedMeshNode, OutputOOBAction action) {
        ProvisioningCapabilitiesState capabilitiesState = (ProvisioningCapabilitiesState)this.provisioningState;
        ProvisioningCapabilities capabilities = capabilitiesState.getCapabilities();
        ProvisioningStartState startProvisioning = new ProvisioningStartState(unprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
        startProvisioning.setProvisioningCapabilities(capabilities.getNumberOfElements(), capabilities.getRawAlgorithm(), capabilities.getRawPublicKeyType(), capabilities.getRawStaticOOBType(), capabilities.getOutputOOBSize(), capabilities.getRawOutputOOBAction(), capabilities.getInputOOBSize(), capabilities.getRawInputOOBAction());
        startProvisioning.setUseOutputOOB(action);
        this.provisioningState = startProvisioning;
        startProvisioning.executeSend();
    }

    private void sendProvisioningStartWithInputOOB(UnprovisionedMeshNode unprovisionedMeshNode, InputOOBAction action) {
        ProvisioningCapabilitiesState capabilitiesState = (ProvisioningCapabilitiesState)this.provisioningState;
        ProvisioningCapabilities capabilities = capabilitiesState.getCapabilities();
        ProvisioningStartState startProvisioning = new ProvisioningStartState(unprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
        startProvisioning.setProvisioningCapabilities(capabilities.getNumberOfElements(), capabilities.getRawAlgorithm(), capabilities.getRawPublicKeyType(), capabilities.getRawStaticOOBType(), capabilities.getOutputOOBSize(), capabilities.getRawOutputOOBAction(), capabilities.getInputOOBSize(), capabilities.getRawInputOOBAction());
        startProvisioning.setUseInputOOB(action);
        this.provisioningState = startProvisioning;
        startProvisioning.executeSend();
    }

    private void sendProvisionerPublicKey(UnprovisionedMeshNode unprovisionedMeshNode) {
        if (!this.isProvisioningPublicKeySent) {
            if (this.provisioningState instanceof ProvisioningPublicKeyState) {
                this.isProvisioningPublicKeySent = true;
                this.provisioningState.executeSend();
            } else {
                ProvisioningPublicKeyState provisioningPublicKeyState = new ProvisioningPublicKeyState(unprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
                this.provisioningState = provisioningPublicKeyState;
                this.isProvisioningPublicKeySent = true;
                provisioningPublicKeyState.executeSend();
            }
        }
    }

    private void parseProvisioneePublicKeyXY(UnprovisionedMeshNode unprovisionedMeshNode, byte[] data) {
        if (this.provisioningState instanceof ProvisioningPublicKeyState) {
            ProvisioningPublicKeyState provisioningPublicKeyState = (ProvisioningPublicKeyState)this.provisioningState;
            this.isProvisioneePublicKeyReceived = provisioningPublicKeyState.parseData(data);
            if (this.isProvisioningPublicKeySent && this.isProvisioneePublicKeyReceived) {
                switch (unprovisionedMeshNode.getAuthMethodUsed()) {
                    case STATIC_OOB_AUTHENTICATION: {
                        this.provisioningState = new ProvisioningConfirmationState(this, unprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
                        this.mStatusCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_AUTHENTICATION_STATIC_OOB_WAITING, data);
                        break;
                    }
                    case OUTPUT_OOB_AUTHENTICATION: {
                        this.provisioningState = new ProvisioningConfirmationState(this, unprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
                        this.mStatusCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_AUTHENTICATION_OUTPUT_OOB_WAITING, data);
                        break;
                    }
                    case INPUT_OOB_AUTHENTICATION: {
                        this.provisioningState = new ProvisioningInputCompleteState(unprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
                        this.mStatusCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_AUTHENTICATION_INPUT_OOB_WAITING, data);
                        break;
                    }
                    default: {
                        this.provisioningState = new ProvisioningConfirmationState(this, unprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
                        this.sendProvisioningConfirmation("");
                    }
                }
            }
        }
    }

    void sendProvisioningConfirmation(@Nullable String authentication) {
        ProvisioningConfirmationState provisioningConfirmationState;
        if (this.provisioningState instanceof ProvisioningInputCompleteState) {
            provisioningConfirmationState = new ProvisioningConfirmationState(this, this.mUnprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
            this.provisioningState = provisioningConfirmationState;
        } else {
            provisioningConfirmationState = (ProvisioningConfirmationState)this.provisioningState;
            provisioningConfirmationState.setProvisioningAuthentication(authentication);
        }
        provisioningConfirmationState.executeSend();
    }

    private boolean parseProvisioningInputCompleteState(@NonNull byte[] data) {
        ProvisioningInputCompleteState inputCompleteState = (ProvisioningInputCompleteState)this.provisioningState;
        return inputCompleteState.parseData(data);
    }

    private boolean parseProvisioneeConfirmation(byte[] data) {
        ProvisioningConfirmationState provisioningConfirmationState = (ProvisioningConfirmationState)this.provisioningState;
        return provisioningConfirmationState.parseData(data);
    }

    private void sendRandomConfirmationPDU(UnprovisionedMeshNode unprovisionedMeshNode) {
        ProvisioningRandomConfirmationState provisioningRandomConfirmation = new ProvisioningRandomConfirmationState(this, unprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
        this.provisioningState = provisioningRandomConfirmation;
        provisioningRandomConfirmation.executeSend();
    }

    private boolean parseProvisioneeRandom(byte[] data) {
        ProvisioningRandomConfirmationState provisioningRandomConfirmation = (ProvisioningRandomConfirmationState)this.provisioningState;
        return provisioningRandomConfirmation.parseData(data);
    }

    private void sendProvisioningData(UnprovisionedMeshNode unprovisionedMeshNode) {
        ProvisioningDataState provisioningDataState = new ProvisioningDataState(this, unprovisionedMeshNode, this.mInternalTransportCallbacks, this.mStatusCallbacks);
        this.provisioningState = provisioningDataState;
        provisioningDataState.executeSend();
    }

    private boolean validateMessage(byte[] data) {
        ProvisioningState state = this.provisioningState;
        return data[1] == state.getState().ordinal();
    }

    @Override
    public final byte[] generateConfirmationInputs(byte[] provisionerKeyXY, byte[] provisioneeKeyXY) {
        if (this.confirmationInputs != null) {
            return this.confirmationInputs;
        }
        int offset = 2;
        int inviteLength = this.mUnprovisionedMeshNode.getProvisioningInvitePdu().length - 2;
        ByteBuffer inviteBuffer = ByteBuffer.allocate(inviteLength).put(this.mUnprovisionedMeshNode.getProvisioningInvitePdu(), 2, inviteLength);
        byte[] invite = inviteBuffer.array();
        int capabilitiesLength = this.mUnprovisionedMeshNode.getProvisioningCapabilitiesPdu().length - 2;
        ByteBuffer capabilitiesBuffer = ByteBuffer.allocate(capabilitiesLength).put(this.mUnprovisionedMeshNode.getProvisioningCapabilitiesPdu(), 2, capabilitiesLength);
        byte[] capabilities = capabilitiesBuffer.array();
        int startDataLength = this.mUnprovisionedMeshNode.getProvisioningStartPdu().length - 2;
        ByteBuffer startDataBuffer = ByteBuffer.allocate(startDataLength).put(this.mUnprovisionedMeshNode.getProvisioningStartPdu(), 2, startDataLength);
        byte[] startData = startDataBuffer.array();
        int length = invite.length + capabilities.length + startData.length + provisionerKeyXY.length + provisioneeKeyXY.length;
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.put(invite);
        buffer.put(capabilities);
        buffer.put(startData);
        buffer.put(provisionerKeyXY);
        buffer.put(provisioneeKeyXY);
        this.confirmationInputs = buffer.array();
        return this.confirmationInputs;
    }
}

