/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.Index;
import com.google.gson.annotations.Expose;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import no.nordicsemi.android.mesh.MeshKey;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.utils.SecureUtils;

@Entity(tableName="network_key", foreignKeys={@ForeignKey(entity=MeshNetwork.class, parentColumns={"mesh_uuid"}, childColumns={"mesh_uuid"}, onUpdate=5, onDelete=5)}, indices={@Index(value={"mesh_uuid"})})
public final class NetworkKey
extends MeshKey {
    public static final int PHASE_0 = 0;
    public static final int PHASE_1 = 1;
    public static final int PHASE_2 = 2;
    @Expose
    @ColumnInfo(name="phase")
    private int phase = 0;
    @Expose
    @ColumnInfo(name="security")
    private boolean minSecurity;
    @Expose
    @ColumnInfo(name="timestamp")
    private long timestamp;
    @Ignore
    private byte[] identityKey;
    public static final Parcelable.Creator<NetworkKey> CREATOR = new Parcelable.Creator<NetworkKey>(){

        public NetworkKey createFromParcel(Parcel in) {
            return new NetworkKey(in);
        }

        public NetworkKey[] newArray(int size) {
            return new NetworkKey[size];
        }
    };

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public NetworkKey(int keyIndex, @NonNull byte[] key) {
        super(keyIndex, key);
        this.name = "Network Key " + (keyIndex + 1);
        this.identityKey = SecureUtils.calculateIdentityKey(key);
        this.timestamp = System.currentTimeMillis();
    }

    protected NetworkKey(Parcel in) {
        this.meshUuid = in.readString();
        this.keyIndex = in.readInt();
        this.name = in.readString();
        this.key = in.createByteArray();
        this.phase = in.readInt();
        this.minSecurity = in.readByte() != 0;
        this.oldKey = in.createByteArray();
        this.timestamp = in.readLong();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.meshUuid);
        dest.writeInt(this.keyIndex);
        dest.writeString(this.name);
        dest.writeByteArray(this.key);
        dest.writeInt(this.phase);
        dest.writeByte((byte)(this.minSecurity ? 1 : 0));
        dest.writeByteArray(this.oldKey);
        dest.writeLong(this.timestamp);
    }

    public int describeContents() {
        return 0;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isMinSecurity() {
        return this.minSecurity;
    }

    @Override
    public void setKey(@NonNull byte[] key) {
        super.setKey(key);
        this.identityKey = SecureUtils.calculateIdentityKey(key);
    }

    public byte[] getIdentityKey() {
        return this.identityKey;
    }

    public void setMinSecurity(boolean minSecurity) {
        this.minSecurity = minSecurity;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    @NonNull
    public NetworkKey clone() throws CloneNotSupportedException {
        return (NetworkKey)super.clone();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeyRefreshPhases {
    }
}

