/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import no.nordicsemi.android.mesh.Features;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.NodeKey;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodesDao;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.NetworkTransmitSettings;
import no.nordicsemi.android.mesh.utils.RelaySettings;

public final class ProvisionedMeshNodesDao_Impl
implements ProvisionedMeshNodesDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ProvisionedMeshNode> __insertionAdapterOfProvisionedMeshNode;
    private final EntityDeletionOrUpdateAdapter<ProvisionedMeshNode> __updateAdapterOfProvisionedMeshNode;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final MeshTypeConverters __meshTypeConverters = new MeshTypeConverters();

    public ProvisionedMeshNodesDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfProvisionedMeshNode = new EntityInsertionAdapter<ProvisionedMeshNode>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `nodes` (`timestamp`,`name`,`ttl`,`blacklisted`,`secureNetworkBeacon`,`mesh_uuid`,`uuid`,`security`,`unicast_address`,`configured`,`device_key`,`seq_number`,`cid`,`pid`,`vid`,`crpl`,`netKeys`,`appKeys`,`mElements`,`networkTransmitCount`,`networkIntervalSteps`,`relayTransmitCount`,`relayIntervalSteps`,`friend`,`lowPower`,`proxy`,`relay`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ProvisionedMeshNode value) {
                Integer _tmp_1;
                stmt.bindLong(1, value.mTimeStampInMillis);
                if (value.getNodeName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getNodeName());
                }
                if (value.getTtl() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, (long)value.getTtl().intValue());
                }
                int _tmp = value.isBlackListed() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                Integer n = value.isSecureNetworkBeaconSupported() == null ? null : (_tmp_1 = Integer.valueOf(value.isSecureNetworkBeaconSupported() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, (long)_tmp_1.intValue());
                }
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getMeshUuid());
                }
                if (value.getUuid() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUuid());
                }
                stmt.bindLong(8, (long)value.getSecurity());
                stmt.bindLong(9, (long)value.getUnicastAddress());
                int _tmp_2 = value.isConfigured() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_2);
                if (value.getDeviceKey() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindBlob(11, value.getDeviceKey());
                }
                stmt.bindLong(12, (long)value.getSequenceNumber());
                if (value.getCompanyIdentifier() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, (long)value.getCompanyIdentifier().intValue());
                }
                if (value.getProductIdentifier() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)value.getProductIdentifier().intValue());
                }
                if (value.getVersionIdentifier() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)value.getVersionIdentifier().intValue());
                }
                if (value.getCrpl() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindLong(16, (long)value.getCrpl().intValue());
                }
                String _tmp_3 = MeshTypeConverters.nodeKeysToJson(value.getAddedNetKeys());
                if (_tmp_3 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_3);
                }
                String _tmp_4 = MeshTypeConverters.nodeKeysToJson(value.getAddedAppKeys());
                if (_tmp_4 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_4);
                }
                String _tmp_5 = MeshTypeConverters.elementsToJson(value.getElements());
                if (_tmp_5 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_5);
                }
                NetworkTransmitSettings _tmpNetworkTransmitSettings = value.getNetworkTransmitSettings();
                if (_tmpNetworkTransmitSettings != null) {
                    stmt.bindLong(20, (long)_tmpNetworkTransmitSettings.getNetworkTransmitCount());
                    stmt.bindLong(21, (long)_tmpNetworkTransmitSettings.getNetworkIntervalSteps());
                } else {
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                }
                RelaySettings _tmpRelaySettings = value.getRelaySettings();
                if (_tmpRelaySettings != null) {
                    stmt.bindLong(22, (long)_tmpRelaySettings.getRelayTransmitCount());
                    stmt.bindLong(23, (long)_tmpRelaySettings.getRelayIntervalSteps());
                } else {
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                }
                Features _tmpNodeFeatures = value.getNodeFeatures();
                if (_tmpNodeFeatures != null) {
                    stmt.bindLong(24, (long)_tmpNodeFeatures.getFriend());
                    stmt.bindLong(25, (long)_tmpNodeFeatures.getLowPower());
                    stmt.bindLong(26, (long)_tmpNodeFeatures.getProxy());
                    stmt.bindLong(27, (long)_tmpNodeFeatures.getRelay());
                } else {
                    stmt.bindNull(24);
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                }
            }
        };
        this.__updateAdapterOfProvisionedMeshNode = new EntityDeletionOrUpdateAdapter<ProvisionedMeshNode>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `nodes` SET `timestamp` = ?,`name` = ?,`ttl` = ?,`blacklisted` = ?,`secureNetworkBeacon` = ?,`mesh_uuid` = ?,`uuid` = ?,`security` = ?,`unicast_address` = ?,`configured` = ?,`device_key` = ?,`seq_number` = ?,`cid` = ?,`pid` = ?,`vid` = ?,`crpl` = ?,`netKeys` = ?,`appKeys` = ?,`mElements` = ?,`networkTransmitCount` = ?,`networkIntervalSteps` = ?,`relayTransmitCount` = ?,`relayIntervalSteps` = ?,`friend` = ?,`lowPower` = ?,`proxy` = ?,`relay` = ? WHERE `uuid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ProvisionedMeshNode value) {
                Integer _tmp_1;
                stmt.bindLong(1, value.mTimeStampInMillis);
                if (value.getNodeName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getNodeName());
                }
                if (value.getTtl() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, (long)value.getTtl().intValue());
                }
                int _tmp = value.isBlackListed() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                Integer n = value.isSecureNetworkBeaconSupported() == null ? null : (_tmp_1 = Integer.valueOf(value.isSecureNetworkBeaconSupported() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindLong(5, (long)_tmp_1.intValue());
                }
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getMeshUuid());
                }
                if (value.getUuid() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUuid());
                }
                stmt.bindLong(8, (long)value.getSecurity());
                stmt.bindLong(9, (long)value.getUnicastAddress());
                int _tmp_2 = value.isConfigured() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_2);
                if (value.getDeviceKey() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindBlob(11, value.getDeviceKey());
                }
                stmt.bindLong(12, (long)value.getSequenceNumber());
                if (value.getCompanyIdentifier() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, (long)value.getCompanyIdentifier().intValue());
                }
                if (value.getProductIdentifier() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)value.getProductIdentifier().intValue());
                }
                if (value.getVersionIdentifier() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)value.getVersionIdentifier().intValue());
                }
                if (value.getCrpl() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindLong(16, (long)value.getCrpl().intValue());
                }
                String _tmp_3 = MeshTypeConverters.nodeKeysToJson(value.getAddedNetKeys());
                if (_tmp_3 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_3);
                }
                String _tmp_4 = MeshTypeConverters.nodeKeysToJson(value.getAddedAppKeys());
                if (_tmp_4 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_4);
                }
                String _tmp_5 = MeshTypeConverters.elementsToJson(value.getElements());
                if (_tmp_5 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_5);
                }
                NetworkTransmitSettings _tmpNetworkTransmitSettings = value.getNetworkTransmitSettings();
                if (_tmpNetworkTransmitSettings != null) {
                    stmt.bindLong(20, (long)_tmpNetworkTransmitSettings.getNetworkTransmitCount());
                    stmt.bindLong(21, (long)_tmpNetworkTransmitSettings.getNetworkIntervalSteps());
                } else {
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                }
                RelaySettings _tmpRelaySettings = value.getRelaySettings();
                if (_tmpRelaySettings != null) {
                    stmt.bindLong(22, (long)_tmpRelaySettings.getRelayTransmitCount());
                    stmt.bindLong(23, (long)_tmpRelaySettings.getRelayIntervalSteps());
                } else {
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                }
                Features _tmpNodeFeatures = value.getNodeFeatures();
                if (_tmpNodeFeatures != null) {
                    stmt.bindLong(24, (long)_tmpNodeFeatures.getFriend());
                    stmt.bindLong(25, (long)_tmpNodeFeatures.getLowPower());
                    stmt.bindLong(26, (long)_tmpNodeFeatures.getProxy());
                    stmt.bindLong(27, (long)_tmpNodeFeatures.getRelay());
                } else {
                    stmt.bindNull(24);
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                }
                if (value.getUuid() == null) {
                    stmt.bindNull(28);
                } else {
                    stmt.bindString(28, value.getUuid());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from nodes";
                return "DELETE from nodes";
            }
        };
    }

    @Override
    public void insert(List<ProvisionedMeshNode> provisionedMeshNode) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfProvisionedMeshNode.insert(provisionedMeshNode);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(List<ProvisionedMeshNode> nodes) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfProvisionedMeshNode.handleMultiple(nodes);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProvisionedMeshNode> loadMeshNodes(String meshUuid) {
        String _sql = "SELECT * from nodes WHERE mesh_uuid == ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from nodes WHERE mesh_uuid == ?", (int)1);
        int _argIndex = 1;
        if (meshUuid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, meshUuid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMTimeStampInMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfNodeName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfTtl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ttl");
            int _cursorIndexOfBlackListed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blacklisted");
            int _cursorIndexOfSecureNetworkBeaconSupported = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"secureNetworkBeacon");
            int _cursorIndexOfMeshUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uuid");
            int _cursorIndexOfSecurity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"security");
            int _cursorIndexOfUnicastAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unicast_address");
            int _cursorIndexOfIsConfigured = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"configured");
            int _cursorIndexOfDeviceKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"device_key");
            int _cursorIndexOfSequenceNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seq_number");
            int _cursorIndexOfCompanyIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfProductIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfVersionIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vid");
            int _cursorIndexOfCrpl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"crpl");
            int _cursorIndexOfMAddedNetKeys = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"netKeys");
            int _cursorIndexOfMAddedAppKeys = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appKeys");
            int _cursorIndexOfMElements = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mElements");
            int _cursorIndexOfNetworkTransmitCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"networkTransmitCount");
            int _cursorIndexOfNetworkIntervalSteps = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"networkIntervalSteps");
            int _cursorIndexOfRelayTransmitCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"relayTransmitCount");
            int _cursorIndexOfRelayIntervalSteps = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"relayIntervalSteps");
            int _cursorIndexOfFriend = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"friend");
            int _cursorIndexOfLowPower = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lowPower");
            int _cursorIndexOfProxy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"proxy");
            int _cursorIndexOfRelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"relay");
            ArrayList<ProvisionedMeshNode> _result = new ArrayList<ProvisionedMeshNode>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Features _tmpNodeFeatures;
                RelaySettings _tmpRelaySettings;
                NetworkTransmitSettings _tmpNetworkTransmitSettings;
                if (!_cursor.isNull(_cursorIndexOfNetworkTransmitCount) || !_cursor.isNull(_cursorIndexOfNetworkIntervalSteps)) {
                    int _tmpNetworkTransmitCount = _cursor.getInt(_cursorIndexOfNetworkTransmitCount);
                    int _tmpNetworkIntervalSteps = _cursor.getInt(_cursorIndexOfNetworkIntervalSteps);
                    _tmpNetworkTransmitSettings = new NetworkTransmitSettings(_tmpNetworkTransmitCount, _tmpNetworkIntervalSteps);
                } else {
                    _tmpNetworkTransmitSettings = null;
                }
                if (!_cursor.isNull(_cursorIndexOfRelayTransmitCount) || !_cursor.isNull(_cursorIndexOfRelayIntervalSteps)) {
                    int _tmpRelayTransmitCount = _cursor.getInt(_cursorIndexOfRelayTransmitCount);
                    int _tmpRelayIntervalSteps = _cursor.getInt(_cursorIndexOfRelayIntervalSteps);
                    _tmpRelaySettings = new RelaySettings(_tmpRelayTransmitCount, _tmpRelayIntervalSteps);
                } else {
                    _tmpRelaySettings = null;
                }
                if (!(_cursor.isNull(_cursorIndexOfFriend) && _cursor.isNull(_cursorIndexOfLowPower) && _cursor.isNull(_cursorIndexOfProxy) && _cursor.isNull(_cursorIndexOfRelay))) {
                    int _tmpFriend = _cursor.getInt(_cursorIndexOfFriend);
                    int _tmpLowPower = _cursor.getInt(_cursorIndexOfLowPower);
                    int _tmpProxy = _cursor.getInt(_cursorIndexOfProxy);
                    int _tmpRelay = _cursor.getInt(_cursorIndexOfRelay);
                    _tmpNodeFeatures = new Features(_tmpFriend, _tmpLowPower, _tmpProxy, _tmpRelay);
                } else {
                    _tmpNodeFeatures = null;
                }
                ProvisionedMeshNode _item = new ProvisionedMeshNode();
                _item.mTimeStampInMillis = _cursor.getLong(_cursorIndexOfMTimeStampInMillis);
                String _tmpNodeName = _cursor.getString(_cursorIndexOfNodeName);
                _item.setNodeName(_tmpNodeName);
                Integer _tmpTtl = _cursor.isNull(_cursorIndexOfTtl) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfTtl));
                _item.setTtl(_tmpTtl);
                int _tmp = _cursor.getInt(_cursorIndexOfBlackListed);
                boolean _tmpBlackListed = _tmp != 0;
                _item.setBlackListed(_tmpBlackListed);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfSecureNetworkBeaconSupported) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSecureNetworkBeaconSupported));
                Boolean _tmpSecureNetworkBeaconSupported = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                _item.setSecureNetworkBeaconSupported(_tmpSecureNetworkBeaconSupported);
                String _tmpMeshUuid = _cursor.getString(_cursorIndexOfMeshUuid);
                _item.setMeshUuid(_tmpMeshUuid);
                String _tmpUuid = _cursor.getString(_cursorIndexOfUuid);
                _item.setUuid(_tmpUuid);
                int _tmpSecurity = _cursor.getInt(_cursorIndexOfSecurity);
                _item.setSecurity(_tmpSecurity);
                int _tmpUnicastAddress = _cursor.getInt(_cursorIndexOfUnicastAddress);
                _item.setUnicastAddress(_tmpUnicastAddress);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsConfigured);
                boolean _tmpIsConfigured = _tmp_2 != 0;
                _item.setConfigured(_tmpIsConfigured);
                byte[] _tmpDeviceKey = _cursor.getBlob(_cursorIndexOfDeviceKey);
                _item.setDeviceKey(_tmpDeviceKey);
                int _tmpSequenceNumber = _cursor.getInt(_cursorIndexOfSequenceNumber);
                _item.setSequenceNumber(_tmpSequenceNumber);
                Integer _tmpCompanyIdentifier = _cursor.isNull(_cursorIndexOfCompanyIdentifier) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfCompanyIdentifier));
                _item.setCompanyIdentifier(_tmpCompanyIdentifier);
                Integer _tmpProductIdentifier = _cursor.isNull(_cursorIndexOfProductIdentifier) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfProductIdentifier));
                _item.setProductIdentifier(_tmpProductIdentifier);
                Integer _tmpVersionIdentifier = _cursor.isNull(_cursorIndexOfVersionIdentifier) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfVersionIdentifier));
                _item.setVersionIdentifier(_tmpVersionIdentifier);
                Integer _tmpCrpl = _cursor.isNull(_cursorIndexOfCrpl) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfCrpl));
                _item.setCrpl(_tmpCrpl);
                String _tmp_3 = _cursor.getString(_cursorIndexOfMAddedNetKeys);
                List<NodeKey> _tmpMAddedNetKeys = MeshTypeConverters.fromJsonToNodeKeys(_tmp_3);
                _item.setAddedNetKeys(_tmpMAddedNetKeys);
                String _tmp_4 = _cursor.getString(_cursorIndexOfMAddedAppKeys);
                List<NodeKey> _tmpMAddedAppKeys = MeshTypeConverters.fromJsonToNodeKeys(_tmp_4);
                _item.setAddedAppKeys(_tmpMAddedAppKeys);
                String _tmp_5 = _cursor.getString(_cursorIndexOfMElements);
                Map<Integer, Element> _tmpMElements = this.__meshTypeConverters.fromJsonToElements(_tmp_5);
                _item.setElements(_tmpMElements);
                _item.setNetworkTransmitSettings(_tmpNetworkTransmitSettings);
                _item.setRelaySettings(_tmpRelaySettings);
                _item.setNodeFeatures(_tmpNodeFeatures);
                _result.add(_item);
            }
            ArrayList<ProvisionedMeshNode> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProvisionedMeshNode> getNodes(String meshUuid) {
        String _sql = "SELECT * from nodes WHERE mesh_uuid IS ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from nodes WHERE mesh_uuid IS ?", (int)1);
        int _argIndex = 1;
        if (meshUuid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, meshUuid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMTimeStampInMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfNodeName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfTtl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ttl");
            int _cursorIndexOfBlackListed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blacklisted");
            int _cursorIndexOfSecureNetworkBeaconSupported = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"secureNetworkBeacon");
            int _cursorIndexOfMeshUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uuid");
            int _cursorIndexOfSecurity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"security");
            int _cursorIndexOfUnicastAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unicast_address");
            int _cursorIndexOfIsConfigured = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"configured");
            int _cursorIndexOfDeviceKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"device_key");
            int _cursorIndexOfSequenceNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seq_number");
            int _cursorIndexOfCompanyIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfProductIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfVersionIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"vid");
            int _cursorIndexOfCrpl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"crpl");
            int _cursorIndexOfMAddedNetKeys = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"netKeys");
            int _cursorIndexOfMAddedAppKeys = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appKeys");
            int _cursorIndexOfMElements = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mElements");
            int _cursorIndexOfNetworkTransmitCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"networkTransmitCount");
            int _cursorIndexOfNetworkIntervalSteps = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"networkIntervalSteps");
            int _cursorIndexOfRelayTransmitCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"relayTransmitCount");
            int _cursorIndexOfRelayIntervalSteps = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"relayIntervalSteps");
            int _cursorIndexOfFriend = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"friend");
            int _cursorIndexOfLowPower = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lowPower");
            int _cursorIndexOfProxy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"proxy");
            int _cursorIndexOfRelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"relay");
            ArrayList<ProvisionedMeshNode> _result = new ArrayList<ProvisionedMeshNode>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Features _tmpNodeFeatures;
                RelaySettings _tmpRelaySettings;
                NetworkTransmitSettings _tmpNetworkTransmitSettings;
                if (!_cursor.isNull(_cursorIndexOfNetworkTransmitCount) || !_cursor.isNull(_cursorIndexOfNetworkIntervalSteps)) {
                    int _tmpNetworkTransmitCount = _cursor.getInt(_cursorIndexOfNetworkTransmitCount);
                    int _tmpNetworkIntervalSteps = _cursor.getInt(_cursorIndexOfNetworkIntervalSteps);
                    _tmpNetworkTransmitSettings = new NetworkTransmitSettings(_tmpNetworkTransmitCount, _tmpNetworkIntervalSteps);
                } else {
                    _tmpNetworkTransmitSettings = null;
                }
                if (!_cursor.isNull(_cursorIndexOfRelayTransmitCount) || !_cursor.isNull(_cursorIndexOfRelayIntervalSteps)) {
                    int _tmpRelayTransmitCount = _cursor.getInt(_cursorIndexOfRelayTransmitCount);
                    int _tmpRelayIntervalSteps = _cursor.getInt(_cursorIndexOfRelayIntervalSteps);
                    _tmpRelaySettings = new RelaySettings(_tmpRelayTransmitCount, _tmpRelayIntervalSteps);
                } else {
                    _tmpRelaySettings = null;
                }
                if (!(_cursor.isNull(_cursorIndexOfFriend) && _cursor.isNull(_cursorIndexOfLowPower) && _cursor.isNull(_cursorIndexOfProxy) && _cursor.isNull(_cursorIndexOfRelay))) {
                    int _tmpFriend = _cursor.getInt(_cursorIndexOfFriend);
                    int _tmpLowPower = _cursor.getInt(_cursorIndexOfLowPower);
                    int _tmpProxy = _cursor.getInt(_cursorIndexOfProxy);
                    int _tmpRelay = _cursor.getInt(_cursorIndexOfRelay);
                    _tmpNodeFeatures = new Features(_tmpFriend, _tmpLowPower, _tmpProxy, _tmpRelay);
                } else {
                    _tmpNodeFeatures = null;
                }
                ProvisionedMeshNode _item = new ProvisionedMeshNode();
                _item.mTimeStampInMillis = _cursor.getLong(_cursorIndexOfMTimeStampInMillis);
                String _tmpNodeName = _cursor.getString(_cursorIndexOfNodeName);
                _item.setNodeName(_tmpNodeName);
                Integer _tmpTtl = _cursor.isNull(_cursorIndexOfTtl) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfTtl));
                _item.setTtl(_tmpTtl);
                int _tmp = _cursor.getInt(_cursorIndexOfBlackListed);
                boolean _tmpBlackListed = _tmp != 0;
                _item.setBlackListed(_tmpBlackListed);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfSecureNetworkBeaconSupported) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfSecureNetworkBeaconSupported));
                Boolean _tmpSecureNetworkBeaconSupported = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                _item.setSecureNetworkBeaconSupported(_tmpSecureNetworkBeaconSupported);
                String _tmpMeshUuid = _cursor.getString(_cursorIndexOfMeshUuid);
                _item.setMeshUuid(_tmpMeshUuid);
                String _tmpUuid = _cursor.getString(_cursorIndexOfUuid);
                _item.setUuid(_tmpUuid);
                int _tmpSecurity = _cursor.getInt(_cursorIndexOfSecurity);
                _item.setSecurity(_tmpSecurity);
                int _tmpUnicastAddress = _cursor.getInt(_cursorIndexOfUnicastAddress);
                _item.setUnicastAddress(_tmpUnicastAddress);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsConfigured);
                boolean _tmpIsConfigured = _tmp_2 != 0;
                _item.setConfigured(_tmpIsConfigured);
                byte[] _tmpDeviceKey = _cursor.getBlob(_cursorIndexOfDeviceKey);
                _item.setDeviceKey(_tmpDeviceKey);
                int _tmpSequenceNumber = _cursor.getInt(_cursorIndexOfSequenceNumber);
                _item.setSequenceNumber(_tmpSequenceNumber);
                Integer _tmpCompanyIdentifier = _cursor.isNull(_cursorIndexOfCompanyIdentifier) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfCompanyIdentifier));
                _item.setCompanyIdentifier(_tmpCompanyIdentifier);
                Integer _tmpProductIdentifier = _cursor.isNull(_cursorIndexOfProductIdentifier) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfProductIdentifier));
                _item.setProductIdentifier(_tmpProductIdentifier);
                Integer _tmpVersionIdentifier = _cursor.isNull(_cursorIndexOfVersionIdentifier) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfVersionIdentifier));
                _item.setVersionIdentifier(_tmpVersionIdentifier);
                Integer _tmpCrpl = _cursor.isNull(_cursorIndexOfCrpl) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfCrpl));
                _item.setCrpl(_tmpCrpl);
                String _tmp_3 = _cursor.getString(_cursorIndexOfMAddedNetKeys);
                List<NodeKey> _tmpMAddedNetKeys = MeshTypeConverters.fromJsonToNodeKeys(_tmp_3);
                _item.setAddedNetKeys(_tmpMAddedNetKeys);
                String _tmp_4 = _cursor.getString(_cursorIndexOfMAddedAppKeys);
                List<NodeKey> _tmpMAddedAppKeys = MeshTypeConverters.fromJsonToNodeKeys(_tmp_4);
                _item.setAddedAppKeys(_tmpMAddedAppKeys);
                String _tmp_5 = _cursor.getString(_cursorIndexOfMElements);
                Map<Integer, Element> _tmpMElements = this.__meshTypeConverters.fromJsonToElements(_tmp_5);
                _item.setElements(_tmpMElements);
                _item.setNetworkTransmitSettings(_tmpNetworkTransmitSettings);
                _item.setRelaySettings(_tmpRelaySettings);
                _item.setNodeFeatures(_tmpNodeFeatures);
                _result.add(_item);
            }
            ArrayList<ProvisionedMeshNode> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

