/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.data.ScenesDao;

public final class ScenesDao_Impl
implements ScenesDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Scene> __insertionAdapterOfScene;
    private final EntityDeletionOrUpdateAdapter<Scene> __updateAdapterOfScene;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public ScenesDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfScene = new EntityInsertionAdapter<Scene>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `scene` (`mesh_uuid`,`name`,`addresses`,`number`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Scene value) {
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUuid());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                String _tmp = MeshTypeConverters.integerToJson(value.getAddresses());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                stmt.bindLong(4, (long)value.getNumber());
            }
        };
        this.__updateAdapterOfScene = new EntityDeletionOrUpdateAdapter<Scene>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `scene` SET `mesh_uuid` = ?,`name` = ?,`addresses` = ?,`number` = ? WHERE `number` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Scene value) {
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUuid());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                String _tmp = MeshTypeConverters.integerToJson(value.getAddresses());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                stmt.bindLong(4, (long)value.getNumber());
                stmt.bindLong(5, (long)value.getNumber());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM scene";
                return "DELETE FROM scene";
            }
        };
    }

    @Override
    public void insert(List<Scene> scenes) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfScene.insert(scenes);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(List<Scene> scenes) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfScene.handleMultiple(scenes);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Scene> loadScenes(String uuid) {
        String _sql = "SELECT * from scene WHERE mesh_uuid == ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from scene WHERE mesh_uuid == ?", (int)1);
        int _argIndex = 1;
        if (uuid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, uuid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMeshUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfAddresses = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addresses");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            ArrayList<Scene> _result = new ArrayList<Scene>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpMeshUuid = _cursor.getString(_cursorIndexOfMeshUuid);
                String _tmp = _cursor.getString(_cursorIndexOfAddresses);
                List<Integer> _tmpAddresses = MeshTypeConverters.fromJsonToIntegerList(_tmp);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                Scene _item = new Scene(_tmpNumber, _tmpAddresses, _tmpMeshUuid);
                String _tmpName = _cursor.getString(_cursorIndexOfName);
                _item.setName(_tmpName);
                _result.add(_item);
            }
            ArrayList<Scene> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

