/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.util.UUID;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningCapabilities;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedBaseMeshNode;
import no.nordicsemi.android.mesh.utils.AuthenticationOOBMethods;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public final class UnprovisionedMeshNode
extends UnprovisionedBaseMeshNode {
    public static final Parcelable.Creator<UnprovisionedMeshNode> CREATOR = new Parcelable.Creator<UnprovisionedMeshNode>(){

        public UnprovisionedMeshNode createFromParcel(Parcel in) {
            return new UnprovisionedMeshNode(in);
        }

        public UnprovisionedMeshNode[] newArray(int size) {
            return new UnprovisionedMeshNode[size];
        }
    };

    public UnprovisionedMeshNode(UUID uuid) {
        super(uuid);
    }

    protected UnprovisionedMeshNode(Parcel in) {
        super((UUID)in.readSerializable());
        this.isProvisioned = in.readByte() != 0;
        this.isConfigured = in.readByte() != 0;
        this.nodeName = in.readString();
        this.provisionerPublicKeyXY = in.createByteArray();
        this.provisioneePublicKeyXY = in.createByteArray();
        this.sharedECDHSecret = in.createByteArray();
        this.provisionerRandom = in.createByteArray();
        this.provisioneeConfirmation = in.createByteArray();
        this.authenticationValue = in.createByteArray();
        this.provisioneeRandom = in.createByteArray();
        this.networkKey = in.createByteArray();
        this.identityKey = in.createByteArray();
        this.keyIndex = in.readInt();
        this.mFlags = in.createByteArray();
        this.ivIndex = in.createByteArray();
        this.unicastAddress = in.readInt();
        this.deviceKey = in.createByteArray();
        this.ttl = in.readInt();
        this.provisioningInvitePdu = in.createByteArray();
        this.provisioningCapabilitiesPdu = in.createByteArray();
        this.provisioningCapabilities = (ProvisioningCapabilities)in.readParcelable(ProvisioningCapabilities.class.getClassLoader());
        if (this.provisioningCapabilities != null) {
            this.numberOfElements = this.provisioningCapabilities.getNumberOfElements();
        }
        this.provisioningStartPdu = in.createByteArray();
        this.authMethodUsed = AuthenticationOOBMethods.fromValue(in.readInt());
        this.authActionUsed = (short)in.readInt();
        this.authenticationValue = in.createByteArray();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.deviceUuid);
        dest.writeByte((byte)(this.isProvisioned ? 1 : 0));
        dest.writeByte((byte)(this.isConfigured ? 1 : 0));
        dest.writeString(this.nodeName);
        dest.writeByteArray(this.provisionerPublicKeyXY);
        dest.writeByteArray(this.provisioneePublicKeyXY);
        dest.writeByteArray(this.sharedECDHSecret);
        dest.writeByteArray(this.provisionerRandom);
        dest.writeByteArray(this.provisioneeConfirmation);
        dest.writeByteArray(this.authenticationValue);
        dest.writeByteArray(this.provisioneeRandom);
        dest.writeByteArray(this.networkKey);
        dest.writeByteArray(this.identityKey);
        dest.writeInt(this.keyIndex);
        dest.writeByteArray(this.mFlags);
        dest.writeByteArray(this.ivIndex);
        dest.writeInt(this.unicastAddress);
        dest.writeByteArray(this.deviceKey);
        dest.writeInt(this.ttl);
        dest.writeByteArray(this.provisioningInvitePdu);
        dest.writeByteArray(this.provisioningCapabilitiesPdu);
        dest.writeParcelable((Parcelable)this.provisioningCapabilities, flags);
        dest.writeByteArray(this.provisioningStartPdu);
        dest.writeInt(this.authMethodUsed.ordinal());
        dest.writeInt((int)this.authActionUsed);
        dest.writeByteArray(this.authenticationValue);
        dest.writeByteArray(this.inputAuthentication);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public final byte[] getSharedECDHSecret() {
        return this.sharedECDHSecret;
    }

    final void setSharedECDHSecret(byte[] sharedECDHSecret) {
        this.sharedECDHSecret = sharedECDHSecret;
    }

    public final byte[] getProvisionerPublicKeyXY() {
        return this.provisionerPublicKeyXY;
    }

    public final void setProvisionerPublicKeyXY(byte[] rawProvisionerKey) {
        this.provisionerPublicKeyXY = rawProvisionerKey;
    }

    public final byte[] getProvisioneePublicKeyXY() {
        return this.provisioneePublicKeyXY;
    }

    final void setProvisioneePublicKeyXY(byte[] provisioneePublicKeyXY) {
        this.provisioneePublicKeyXY = provisioneePublicKeyXY;
    }

    public final byte[] getProvisionerRandom() {
        return this.provisionerRandom;
    }

    final void setProvisionerRandom(byte[] provisionerRandom) {
        this.provisionerRandom = provisionerRandom;
    }

    public final byte[] getProvisioneeConfirmation() {
        return this.provisioneeConfirmation;
    }

    final void setProvisioneeConfirmation(byte[] provisioneeConfirmation) {
        this.provisioneeConfirmation = provisioneeConfirmation;
    }

    public final byte[] getAuthenticationValue() {
        return this.authenticationValue;
    }

    final void setAuthenticationValue(byte[] authenticationValue) {
        this.authenticationValue = authenticationValue;
    }

    public final byte[] getProvisioneeRandom() {
        return this.provisioneeRandom;
    }

    final void setProvisioneeRandom(byte[] provisioneeRandom) {
        this.provisioneeRandom = provisioneeRandom;
    }

    public final byte[] getNetworkKey() {
        return this.networkKey;
    }

    public final void setNetworkKey(byte[] networkKey) {
        this.networkKey = networkKey;
    }

    final void setDeviceKey(byte[] deviceKey) {
        this.deviceKey = deviceKey;
    }

    final void setProvisionedTime(long timeStampInMillis) {
        this.mTimeStampInMillis = timeStampInMillis;
    }

    void setProvisioningCapabilities(ProvisioningCapabilities provisioningCapabilities) {
        this.numberOfElements = provisioningCapabilities.getNumberOfElements();
        this.provisioningCapabilities = provisioningCapabilities;
    }

    final void setIsProvisioned(boolean isProvisioned) {
        this.isProvisioned = isProvisioned;
        if (isProvisioned) {
            this.identityKey = SecureUtils.calculateIdentityKey(this.networkKey);
        }
    }
}

