/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.Message;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

abstract class AccessLayer {
    private static final String TAG = AccessLayer.class.getSimpleName();
    protected Context mContext;
    Handler mHandler;
    ProvisionedMeshNode mMeshNode;

    AccessLayer() {
    }

    protected abstract void initHandler();

    void createMeshMessage(@NonNull Message message) {
        this.createAccessMessage((AccessMessage)message);
    }

    void createVendorMeshMessage(@NonNull Message message) {
        this.createCustomAccessMessage((AccessMessage)message);
    }

    @VisibleForTesting(otherwise=4)
    final void createAccessMessage(@NonNull AccessMessage accessMessage) {
        ByteBuffer accessMessageBuffer;
        byte[] opCodes = MeshParserUtils.getOpCode(accessMessage.getOpCode());
        byte[] parameters = accessMessage.getParameters();
        if (parameters != null) {
            accessMessageBuffer = ByteBuffer.allocate(opCodes.length + parameters.length);
            accessMessageBuffer.put(opCodes).put(parameters);
        } else {
            accessMessageBuffer = ByteBuffer.allocate(opCodes.length);
            accessMessageBuffer.put(opCodes);
        }
        byte[] accessPdu = accessMessageBuffer.array();
        Log.v((String)TAG, (String)("Created Access PDU " + MeshParserUtils.bytesToHex(accessPdu, false)));
        accessMessage.setAccessPdu(accessMessageBuffer.array());
    }

    @VisibleForTesting(otherwise=4)
    final void createCustomAccessMessage(@NonNull AccessMessage accessMessage) {
        ByteBuffer accessMessageBuffer;
        byte[] parameters = accessMessage.getParameters();
        byte[] vendorOpcode = MeshParserUtils.createVendorOpCode(accessMessage.getOpCode(), accessMessage.getCompanyIdentifier());
        if (parameters != null) {
            accessMessageBuffer = ByteBuffer.allocate(vendorOpcode.length + parameters.length);
            accessMessageBuffer.put(vendorOpcode);
            accessMessageBuffer.put(parameters);
        } else {
            accessMessageBuffer = ByteBuffer.allocate(vendorOpcode.length);
            accessMessageBuffer.put(vendorOpcode);
        }
        byte[] accessPdu = accessMessageBuffer.array();
        Log.v((String)TAG, (String)("Created Access PDU " + MeshParserUtils.bytesToHex(accessPdu, false)));
        accessMessage.setAccessPdu(accessPdu);
    }

    final void parseAccessLayerPDU(@NonNull AccessMessage message) {
        byte[] accessPayload = message.getAccessPdu();
        int opCodeLength = MeshParserUtils.getOpCodeLength(accessPayload[0] & 0xFF);
        int opCode = MeshParserUtils.getOpCode(accessPayload, opCodeLength);
        message.setOpCode(opCode);
        int length = accessPayload.length - opCodeLength;
        ByteBuffer paramsBuffer = ByteBuffer.allocate(length).order(ByteOrder.BIG_ENDIAN);
        paramsBuffer.put(accessPayload, opCodeLength, length);
        message.setParameters(paramsBuffer.array());
        Log.v((String)TAG, (String)("Received Access PDU " + MeshParserUtils.bytesToHex(accessPayload, false)));
    }
}

