/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.transport.InternalMeshMsgHandlerCallbacks;
import no.nordicsemi.android.mesh.transport.MeshMessage;
import no.nordicsemi.android.mesh.transport.MeshMessageState;
import no.nordicsemi.android.mesh.transport.MeshTransport;

class ConfigMessageState
extends MeshMessageState {
    private final byte[] mDeviceKey;

    ConfigMessageState(int src, int dst, @NonNull byte[] deviceKey, @NonNull MeshMessage meshMessage, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks callbacks) {
        super(meshMessage, meshTransport, callbacks);
        this.mSrc = src;
        this.mDst = dst;
        this.mDeviceKey = deviceKey;
        this.createAccessMessage();
    }

    @Override
    public MeshMessageState.MessageState getState() {
        return MeshMessageState.MessageState.CONFIG_MESSAGE_STATE;
    }

    private void createAccessMessage() throws IllegalArgumentException {
        ConfigMessage configMessage = (ConfigMessage)this.mMeshMessage;
        int akf = configMessage.getAkf();
        int aid = configMessage.getAid();
        int aszmic = configMessage.getAszmic();
        int opCode = configMessage.getOpCode();
        byte[] parameters = configMessage.getParameters();
        this.message = this.mMeshTransport.createMeshMessage(this.mSrc, this.mDst, this.mDeviceKey, akf, aid, aszmic, opCode, parameters);
        configMessage.setMessage(this.message);
    }
}

