/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigNetKeyAdd
extends ConfigMessage {
    private static final String TAG = ConfigNetKeyAdd.class.getSimpleName();
    private static final int OP_CODE = 32832;
    private final NetworkKey mNetKey;

    public ConfigNetKeyAdd(@NonNull NetworkKey networkKey) throws IllegalArgumentException {
        if (networkKey.getKey().length != 16) {
            throw new IllegalArgumentException("Network key must be 16 bytes");
        }
        this.mNetKey = networkKey;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32832;
    }

    @Override
    void assembleMessageParameters() {
        Log.v((String)TAG, (String)("NetKeyIndex: " + this.mNetKey.getKeyIndex()));
        byte[] netKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mNetKey.getKeyIndex());
        ByteBuffer paramsBuffer = ByteBuffer.allocate(18).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.put(netKeyIndex[1]);
        paramsBuffer.put((byte)(netKeyIndex[0] & 0xFF & 0xF));
        paramsBuffer.put(this.mNetKey.getKey());
        this.mParameters = paramsBuffer.array();
    }
}

