/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import no.nordicsemi.android.mesh.models.SigModel;
import no.nordicsemi.android.mesh.models.VendorModel;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public final class Element
implements Parcelable {
    @Expose
    int locationDescriptor;
    @Expose
    final Map<Integer, MeshModel> meshModels;
    @Expose
    int elementAddress;
    @Expose
    String name;
    public static final Parcelable.Creator<Element> CREATOR = new Parcelable.Creator<Element>(){

        public Element createFromParcel(Parcel in) {
            return new Element(in);
        }

        public Element[] newArray(int size) {
            return new Element[size];
        }
    };

    Element(int elementAddress, int locationDescriptor, @NonNull Map<Integer, MeshModel> models) {
        this(elementAddress, locationDescriptor, models, "Element: " + MeshAddress.formatAddress(elementAddress, true));
    }

    Element(int elementAddress, int locationDescriptor, @NonNull Map<Integer, MeshModel> models, @NonNull String name) {
        this.elementAddress = elementAddress;
        this.locationDescriptor = locationDescriptor;
        this.meshModels = models;
        this.name = name;
    }

    Element(int locationDescriptor, @NonNull Map<Integer, MeshModel> models) {
        this.locationDescriptor = locationDescriptor;
        this.meshModels = models;
    }

    protected Element(Parcel in) {
        this.elementAddress = in.readInt();
        this.locationDescriptor = in.readInt();
        this.meshModels = new LinkedHashMap<Integer, MeshModel>();
        this.sortModels(in.readHashMap(MeshModel.class.getClassLoader()));
        this.name = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.elementAddress);
        dest.writeInt(this.locationDescriptor);
        dest.writeMap(this.meshModels);
        dest.writeString(this.name);
    }

    private void sortModels(HashMap<Integer, MeshModel> unorderedElements) {
        Set<Integer> unorderedKeys = unorderedElements.keySet();
        ArrayList<Integer> orderedKeys = new ArrayList<Integer>(unorderedKeys);
        Collections.sort(orderedKeys);
        for (int key : orderedKeys) {
            this.meshModels.put(key, unorderedElements.get(key));
        }
    }

    public int describeContents() {
        return 0;
    }

    public int getElementAddress() {
        return this.elementAddress;
    }

    void setElementAddress(int elementAddress) {
        this.elementAddress = elementAddress;
    }

    public int getLocationDescriptor() {
        return this.locationDescriptor;
    }

    void setLocationDescriptor(int locationDescriptor) {
        this.locationDescriptor = locationDescriptor;
    }

    public String getName() {
        return this.name;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setName(@NonNull String name) {
        this.name = name;
    }

    public int getSigModelCount() {
        int count = 0;
        for (Map.Entry<Integer, MeshModel> modelEntry : this.meshModels.entrySet()) {
            if (!(modelEntry.getValue() instanceof SigModel)) continue;
            ++count;
        }
        return count;
    }

    public int getVendorModelCount() {
        int count = 0;
        for (Map.Entry<Integer, MeshModel> modelEntry : this.meshModels.entrySet()) {
            if (!(modelEntry.getValue() instanceof VendorModel)) continue;
            ++count;
        }
        return count;
    }

    public Map<Integer, MeshModel> getMeshModels() {
        return Collections.unmodifiableMap(this.meshModels);
    }
}

