/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.UUID;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.GenericMessage;
import no.nordicsemi.android.mesh.transport.InternalMeshMsgHandlerCallbacks;
import no.nordicsemi.android.mesh.transport.MeshMessage;
import no.nordicsemi.android.mesh.transport.MeshMessageState;
import no.nordicsemi.android.mesh.transport.MeshTransport;
import no.nordicsemi.android.mesh.utils.MeshAddress;

class GenericMessageState
extends MeshMessageState {
    UUID mLabel;

    GenericMessageState(int src, int dst, @NonNull MeshMessage meshMessage, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        this(src, dst, null, meshMessage, meshTransport, callbacks);
    }

    GenericMessageState(int src, int dst, @Nullable UUID label, @NonNull MeshMessage meshMessage, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        super(meshMessage, meshTransport, callbacks);
        this.mSrc = src;
        if (!MeshAddress.isAddressInRange(src)) {
            throw new IllegalArgumentException("Invalid address, a source address must be a valid 16-bit value!");
        }
        this.mDst = dst;
        if (!MeshAddress.isAddressInRange(dst)) {
            throw new IllegalArgumentException("Invalid address, a destination address must be a valid 16-bit value");
        }
        this.mLabel = label;
        this.createAccessMessage();
    }

    protected void createAccessMessage() {
        GenericMessage genericMessage = (GenericMessage)this.mMeshMessage;
        ApplicationKey key = genericMessage.getAppKey();
        int akf = genericMessage.getAkf();
        int aid = genericMessage.getAid();
        int aszmic = genericMessage.getAszmic();
        int opCode = genericMessage.getOpCode();
        byte[] parameters = genericMessage.getParameters();
        this.message = this.mMeshTransport.createMeshMessage(this.mSrc, this.mDst, this.mLabel, key, akf, aid, aszmic, opCode, parameters);
        genericMessage.setMessage(this.message);
    }

    @Override
    public MeshMessageState.MessageState getState() {
        return MeshMessageState.MessageState.GENERIC_MESSAGE_STATE;
    }
}

