/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.GenericMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class LightLightnessSetUnacknowledged
extends GenericMessage {
    private static final String TAG = LightLightnessSetUnacknowledged.class.getSimpleName();
    private static final int OP_CODE = 33357;
    private static final int GENERIC_LEVEL_SET_TRANSITION_PARAMS_LENGTH = 5;
    private static final int GENERIC_LEVEL_SET_PARAMS_LENGTH = 3;
    private final Integer mTransitionSteps;
    private final Integer mTransitionResolution;
    private final Integer mDelay;
    private final int tId;
    private final int mLevel;

    public LightLightnessSetUnacknowledged(@NonNull ApplicationKey appKey, int level, int tId) throws IllegalArgumentException {
        this(appKey, null, null, null, level, tId);
    }

    public LightLightnessSetUnacknowledged(@NonNull ApplicationKey appKey, @Nullable Integer transitionSteps, @Nullable Integer transitionResolution, @Nullable Integer delay, int level, int tId) throws IllegalArgumentException {
        super(appKey);
        this.mTransitionSteps = transitionSteps;
        this.mTransitionResolution = transitionResolution;
        this.mDelay = delay;
        this.tId = tId;
        if (level < 0 || level > 65535) {
            throw new IllegalArgumentException("Light lightness value must be between 0x0000 and 0xFFFF");
        }
        this.mLevel = level;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33357;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        Log.v((String)TAG, (String)("Level: " + this.mLevel));
        Log.v((String)TAG, (String)("TID: " + this.tId));
        if (this.mTransitionSteps == null || this.mTransitionResolution == null || this.mDelay == null) {
            paramsBuffer = ByteBuffer.allocate(3).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mLevel);
            paramsBuffer.put((byte)this.tId);
        } else {
            Log.v((String)TAG, (String)("Transition steps: " + this.mTransitionSteps));
            Log.v((String)TAG, (String)("Transition step resolution: " + this.mTransitionResolution));
            paramsBuffer = ByteBuffer.allocate(5).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mLevel);
            paramsBuffer.put((byte)this.tId);
            paramsBuffer.put((byte)(this.mTransitionResolution << 6 | this.mTransitionSteps));
            int delay = this.mDelay;
            paramsBuffer.put((byte)delay);
        }
        this.mParameters = paramsBuffer.array();
    }
}

