/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.transport.ProxyConfigMessage;
import no.nordicsemi.android.mesh.utils.AddressArray;

public class ProxyConfigAddAddressToFilter
extends ProxyConfigMessage {
    private final List<AddressArray> addresses = new ArrayList<AddressArray>();

    public ProxyConfigAddAddressToFilter(@NonNull List<AddressArray> addresses) throws IllegalArgumentException {
        this.addresses.addAll(addresses);
        this.assembleMessageParameters();
    }

    @Override
    void assembleMessageParameters() throws IllegalArgumentException {
        if (this.addresses.isEmpty()) {
            throw new IllegalArgumentException("Address list cannot be empty!");
        }
        int length = (int)Math.pow(2.0, this.addresses.size());
        this.mParameters = new byte[length];
        int count = 0;
        for (AddressArray addressArray : this.addresses) {
            this.mParameters[count] = addressArray.getAddress()[0];
            this.mParameters[count + 1] = addressArray.getAddress()[1];
            count += 2;
        }
    }

    @Override
    int getOpCode() {
        return 1;
    }

    @Override
    byte[] getParameters() {
        return this.mParameters;
    }

    public List<AddressArray> getAddresses() {
        return this.addresses;
    }
}

