/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.GenericMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class SceneDelete
extends GenericMessage {
    private static final String TAG = SceneDelete.class.getSimpleName();
    private static final int OP_CODE = 33438;
    private static final int SCENE_DELETE_PARAMS_LENGTH = 2;
    private final int mSceneNumber;

    public SceneDelete(@NonNull ApplicationKey appKey, int sceneNumber) {
        super(appKey);
        this.mSceneNumber = sceneNumber;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33438;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        Log.v((String)TAG, (String)("Scene Number: " + this.mSceneNumber));
        ByteBuffer paramsBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.mSceneNumber);
        this.mParameters = paramsBuffer.array();
    }
}

