/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import no.nordicsemi.android.mesh.transport.AccessLayer;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ControlMessage;
import no.nordicsemi.android.mesh.transport.Message;
import no.nordicsemi.android.mesh.transport.UpperTransportLayerCallbacks;
import no.nordicsemi.android.mesh.utils.ExtendedInvalidCipherTextException;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.SecureUtils;
import org.spongycastle.crypto.InvalidCipherTextException;

abstract class UpperTransportLayer
extends AccessLayer {
    private static final String TAG = UpperTransportLayer.class.getSimpleName();
    private static final int PROXY_CONFIG_OPCODE_LENGTH = 1;
    static final int MAX_SEGMENTED_ACCESS_PAYLOAD_LENGTH = 12;
    static final int MAX_UNSEGMENTED_CONTROL_PAYLOAD_LENGTH = 11;
    static final int MAX_SEGMENTED_CONTROL_PAYLOAD_LENGTH = 8;
    static final int NONCE_TYPE_NETWORK = 0;
    static final int NONCE_TYPE_PROXY = 3;
    static final int PAD_NETWORK_NONCE = 0;
    static final int PAD_PROXY_NONCE = 0;
    static final int APPLICATION_KEY_IDENTIFIER = 0;
    private static final int MAX_UNSEGMENTED_ACCESS_PAYLOAD_LENGTH = 15;
    private static final int NONCE_TYPE_APPLICATION = 1;
    private static final int NONCE_TYPE_DEVICE = 2;
    private static final int PAD_APPLICATION_DEVICE_NONCE = 0;
    private static final int SZMIC = 1;
    private static final int TRANSPORT_SAR_SEQZERO_MASK = 8191;
    private static final int DEFAULT_UNSEGMENTED_MIC_LENGTH = 4;
    private static final int MINIMUM_TRANSMIC_LENGTH = 4;
    private static final int MAXIMUM_TRANSMIC_LENGTH = 8;
    UpperTransportLayerCallbacks mUpperTransportLayerCallbacks;

    UpperTransportLayer() {
    }

    abstract void createLowerTransportAccessPDU(@NonNull AccessMessage var1);

    abstract void createLowerTransportControlPDU(@NonNull ControlMessage var1);

    abstract void reassembleLowerTransportAccessPDU(@NonNull AccessMessage var1);

    abstract void reassembleLowerTransportControlPDU(@NonNull ControlMessage var1);

    abstract void setUpperTransportLayerCallbacks(@NonNull UpperTransportLayerCallbacks var1);

    @Override
    void createMeshMessage(@NonNull Message message) {
        if (message instanceof AccessMessage) {
            super.createMeshMessage(message);
            AccessMessage accessMessage = (AccessMessage)message;
            byte[] encryptedTransportPDU = this.encryptUpperTransportPDU(accessMessage);
            Log.v((String)TAG, (String)("Encrypted upper transport pdu: " + MeshParserUtils.bytesToHex(encryptedTransportPDU, false)));
            accessMessage.setUpperTransportPdu(encryptedTransportPDU);
        } else {
            this.createUpperTransportPDU(message);
        }
    }

    @Override
    void createVendorMeshMessage(@NonNull Message message) {
        super.createVendorMeshMessage(message);
        AccessMessage accessMessage = (AccessMessage)message;
        byte[] encryptedTransportPDU = this.encryptUpperTransportPDU(accessMessage);
        Log.v((String)TAG, (String)("Encrypted upper transport pdu: " + MeshParserUtils.bytesToHex(encryptedTransportPDU, false)));
        accessMessage.setUpperTransportPdu(encryptedTransportPDU);
    }

    @VisibleForTesting(otherwise=4)
    void createUpperTransportPDU(@NonNull Message message) {
        if (message instanceof AccessMessage) {
            AccessMessage accessMessage = (AccessMessage)message;
            byte[] encryptedTransportPDU = this.encryptUpperTransportPDU(accessMessage);
            Log.v((String)TAG, (String)("Encrypted upper transport pdu: " + MeshParserUtils.bytesToHex(encryptedTransportPDU, false)));
            accessMessage.setUpperTransportPdu(encryptedTransportPDU);
        } else {
            ByteBuffer accessMessageBuffer;
            ControlMessage controlMessage = (ControlMessage)message;
            int opCode = controlMessage.getOpCode();
            byte[] parameters = controlMessage.getParameters();
            if (parameters != null) {
                accessMessageBuffer = ByteBuffer.allocate(1 + parameters.length).order(ByteOrder.BIG_ENDIAN).put((byte)opCode).put(parameters);
            } else {
                accessMessageBuffer = ByteBuffer.allocate(1);
                accessMessageBuffer.put((byte)opCode);
            }
            byte[] accessPdu = accessMessageBuffer.array();
            Log.v((String)TAG, (String)("Created Transport Control PDU " + MeshParserUtils.bytesToHex(accessPdu, false)));
            controlMessage.setTransportControlPdu(accessPdu);
        }
    }

    final void parseUpperTransportPDU(@NonNull Message message) throws ExtendedInvalidCipherTextException {
        try {
            switch (message.getPduType()) {
                case 0: {
                    if (!(message instanceof AccessMessage)) break;
                    AccessMessage accessMessage = (AccessMessage)message;
                    this.reassembleLowerTransportAccessPDU(accessMessage);
                    byte[] decryptedUpperTransportControlPdu = this.decryptUpperTransportPDU(accessMessage);
                    accessMessage.setAccessPdu(decryptedUpperTransportControlPdu);
                    break;
                }
                case 2: {
                    ControlMessage controlMessage = (ControlMessage)message;
                    if (controlMessage.getLowerTransportControlPdu().size() != 1) break;
                    byte[] lowerTransportControlPdu = (byte[])controlMessage.getLowerTransportControlPdu().get(0);
                    ByteBuffer buffer = ByteBuffer.wrap(lowerTransportControlPdu).order(ByteOrder.BIG_ENDIAN);
                    message.setOpCode(buffer.get());
                    byte[] parameters = new byte[buffer.capacity() - 1];
                    buffer.get(parameters);
                    message.setParameters(parameters);
                }
            }
        }
        catch (InvalidCipherTextException ex) {
            throw new ExtendedInvalidCipherTextException(ex.getMessage(), ex.getCause(), TAG);
        }
    }

    private byte[] encryptUpperTransportPDU(@NonNull AccessMessage message) {
        byte[] nonce;
        byte[] key;
        byte[] accessPDU = message.getAccessPdu();
        int akf = message.getAkf();
        int aszmic = message.getAszmic();
        byte[] sequenceNumber = message.getSequenceNumber();
        int src = message.getSrc();
        int dst = message.getDst();
        byte[] ivIndex = message.getIvIndex();
        if (akf == 0) {
            key = message.getDeviceKey();
            nonce = this.createDeviceNonce(aszmic, sequenceNumber, src, dst, ivIndex);
            Log.v((String)TAG, (String)("Device nonce: " + MeshParserUtils.bytesToHex(nonce, false)));
        } else {
            key = message.getApplicationKey().getKey();
            nonce = this.createApplicationNonce(aszmic, sequenceNumber, src, dst, ivIndex);
            Log.v((String)TAG, (String)("Application nonce: " + MeshParserUtils.bytesToHex(nonce, false)));
        }
        int encryptedPduLength = accessPDU.length + 4;
        int transMicLength = encryptedPduLength <= 15 ? SecureUtils.getTransMicLength(message.getCtl()) : SecureUtils.getTransMicLength(message.getAszmic());
        if (MeshAddress.isValidVirtualAddress(dst)) {
            return SecureUtils.encryptCCM(accessPDU, key, nonce, MeshParserUtils.uuidToBytes(message.getLabel()), transMicLength);
        }
        return SecureUtils.encryptCCM(accessPDU, key, nonce, transMicLength);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] decryptUpperTransportPDU(@NonNull AccessMessage accessMessage) throws InvalidCipherTextException {
        byte[] decryptedUpperTransportPDU;
        int transportMicLength;
        byte[] nonce;
        byte[] key;
        if (0 == accessMessage.getAkf()) {
            key = this.mMeshNode.getDeviceKey();
            nonce = this.createDeviceNonce(accessMessage.getAszmic(), accessMessage.getSequenceNumber(), accessMessage.getSrc(), accessMessage.getDst(), accessMessage.getIvIndex());
        } else {
            key = this.mUpperTransportLayerCallbacks.getApplicationKey(accessMessage.getAid());
            if (key == null) {
                throw new IllegalArgumentException("Unable to find the app key to decrypt the message");
            }
            byte aid = SecureUtils.calculateK4(key);
            if (aid != accessMessage.getAid()) {
                throw new IllegalArgumentException("Unable to decrypt the message, invalid application key identifier");
            }
            nonce = this.createApplicationNonce(accessMessage.getAszmic(), accessMessage.getSequenceNumber(), accessMessage.getSrc(), accessMessage.getDst(), accessMessage.getIvIndex());
        }
        int n = transportMicLength = accessMessage.getAszmic() == 1 ? 8 : 4;
        if (MeshAddress.isValidVirtualAddress(accessMessage.getDst())) {
            UUID label = this.mUpperTransportLayerCallbacks.getLabel(accessMessage.getDst());
            if (label == null) throw new ExtendedInvalidCipherTextException("Label UUID unknown", null, TAG);
            decryptedUpperTransportPDU = SecureUtils.decryptCCM(accessMessage.getUpperTransportPdu(), key, nonce, MeshParserUtils.uuidToBytes(label), transportMicLength);
        } else {
            decryptedUpperTransportPDU = SecureUtils.decryptCCM(accessMessage.getUpperTransportPdu(), key, nonce, transportMicLength);
        }
        byte[] tempBytes = new byte[decryptedUpperTransportPDU.length];
        ByteBuffer decryptedBuffer = ByteBuffer.wrap(tempBytes);
        decryptedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        decryptedBuffer.put(decryptedUpperTransportPDU);
        return decryptedBuffer.array();
    }

    private byte[] createApplicationNonce(int aszmic, @NonNull byte[] sequenceNumber, int src, int dst, @NonNull byte[] ivIndex) {
        ByteBuffer applicationNonceBuffer = ByteBuffer.allocate(13);
        applicationNonceBuffer.put((byte)1);
        applicationNonceBuffer.put((byte)(aszmic << 7 | 0));
        applicationNonceBuffer.put(sequenceNumber);
        applicationNonceBuffer.putShort((short)src);
        applicationNonceBuffer.putShort((short)dst);
        applicationNonceBuffer.put(ivIndex);
        return applicationNonceBuffer.array();
    }

    private byte[] createDeviceNonce(int aszmic, @NonNull byte[] sequenceNumber, int src, int dst, @NonNull byte[] ivIndex) {
        ByteBuffer deviceNonceBuffer = ByteBuffer.allocate(13);
        deviceNonceBuffer.put((byte)2);
        deviceNonceBuffer.put((byte)(aszmic << 7 | 0));
        deviceNonceBuffer.put(sequenceNumber);
        deviceNonceBuffer.putShort((short)src);
        deviceNonceBuffer.putShort((short)dst);
        deviceNonceBuffer.put(ivIndex);
        return deviceNonceBuffer.array();
    }

    final int getTransportLayerSequenceNumber(int networkLayerSequenceNumber, int seqZero) {
        if ((networkLayerSequenceNumber & 0x1FFF) < seqZero) {
            return networkLayerSequenceNumber - ((networkLayerSequenceNumber & 0x1FFF) - seqZero) - 8192;
        }
        return networkLayerSequenceNumber - ((networkLayerSequenceNumber & 0x1FFF) - seqZero);
    }
}

