/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.GenericMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class VendorModelMessageAcked
extends GenericMessage {
    private static final String TAG = VendorModelMessageAcked.class.getSimpleName();
    private static final int VENDOR_MODEL_OPCODE_LENGTH = 4;
    private final int mModelIdentifier;
    private final int mCompanyIdentifier;
    private final int mOpCode;

    public VendorModelMessageAcked(@NonNull ApplicationKey appKey, int modelId, int companyIdentifier, int opCode, @NonNull byte[] parameters) {
        super(appKey);
        this.mModelIdentifier = modelId;
        this.mCompanyIdentifier = companyIdentifier;
        this.mOpCode = (0xC0 | opCode) << 16;
        this.mParameters = parameters;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return this.mOpCode;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
    }

    public final int getCompanyIdentifier() {
        return this.mCompanyIdentifier;
    }

    public int getModelIdentifier() {
        return this.mModelIdentifier;
    }
}

