/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.UUID;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.GenericMessageState;
import no.nordicsemi.android.mesh.transport.InternalMeshMsgHandlerCallbacks;
import no.nordicsemi.android.mesh.transport.MeshMessageState;
import no.nordicsemi.android.mesh.transport.MeshTransport;
import no.nordicsemi.android.mesh.transport.VendorModelMessageAcked;

class VendorModelMessageAckedState
extends GenericMessageState {
    private static final String TAG = VendorModelMessageAckedState.class.getSimpleName();

    VendorModelMessageAckedState(int src, int dst, @NonNull VendorModelMessageAcked vendorModelMessageAcked, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        this(src, dst, null, vendorModelMessageAcked, meshTransport, callbacks);
    }

    VendorModelMessageAckedState(int src, int dst, @Nullable UUID label, @NonNull VendorModelMessageAcked vendorModelMessageAcked, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        super(src, dst, label, vendorModelMessageAcked, meshTransport, callbacks);
    }

    @Override
    public MeshMessageState.MessageState getState() {
        return MeshMessageState.MessageState.VENDOR_MODEL_ACKNOWLEDGED_STATE;
    }

    @Override
    protected final void createAccessMessage() {
        VendorModelMessageAcked vendorModelMessageAcked = (VendorModelMessageAcked)this.mMeshMessage;
        ApplicationKey key = vendorModelMessageAcked.getAppKey();
        int akf = vendorModelMessageAcked.getAkf();
        int aid = vendorModelMessageAcked.getAid();
        int aszmic = vendorModelMessageAcked.getAszmic();
        int opCode = vendorModelMessageAcked.getOpCode();
        byte[] parameters = vendorModelMessageAcked.getParameters();
        int companyIdentifier = vendorModelMessageAcked.getCompanyIdentifier();
        this.message = this.mMeshTransport.createVendorMeshMessage(companyIdentifier, this.mSrc, this.mDst, this.mLabel, key, akf, aid, aszmic, opCode, parameters);
        vendorModelMessageAcked.setMessage(this.message);
    }

    @Override
    public void executeSend() {
        Log.v((String)TAG, (String)"Sending acknowledged vendor model message");
        super.executeSend();
    }
}

