/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.UUID;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.GenericMessageState;
import no.nordicsemi.android.mesh.transport.InternalMeshMsgHandlerCallbacks;
import no.nordicsemi.android.mesh.transport.MeshMessageState;
import no.nordicsemi.android.mesh.transport.MeshTransport;
import no.nordicsemi.android.mesh.transport.VendorModelMessageUnacked;

class VendorModelMessageUnackedState
extends GenericMessageState {
    private static final String TAG = VendorModelMessageUnackedState.class.getSimpleName();

    VendorModelMessageUnackedState(int src, int dst, @NonNull VendorModelMessageUnacked vendorModelMessageUnacked, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        this(src, dst, null, vendorModelMessageUnacked, meshTransport, callbacks);
    }

    VendorModelMessageUnackedState(int src, int dst, @Nullable UUID label, @NonNull VendorModelMessageUnacked vendorModelMessageUnacked, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        super(src, dst, vendorModelMessageUnacked, meshTransport, callbacks);
    }

    @Override
    public MeshMessageState.MessageState getState() {
        return MeshMessageState.MessageState.VENDOR_MODEL_UNACKNOWLEDGED_STATE;
    }

    @Override
    protected final void createAccessMessage() {
        VendorModelMessageUnacked vendorModelMessageUnacked = (VendorModelMessageUnacked)this.mMeshMessage;
        ApplicationKey key = vendorModelMessageUnacked.getAppKey();
        int akf = vendorModelMessageUnacked.getAkf();
        int aid = vendorModelMessageUnacked.getAid();
        int aszmic = vendorModelMessageUnacked.getAszmic();
        int opCode = vendorModelMessageUnacked.getOpCode();
        byte[] parameters = vendorModelMessageUnacked.getParameters();
        int companyIdentifier = vendorModelMessageUnacked.getCompanyIdentifier();
        this.message = this.mMeshTransport.createVendorMeshMessage(companyIdentifier, this.mSrc, this.mDst, this.mLabel, key, akf, aid, aszmic, opCode, parameters);
        vendorModelMessageUnacked.setMessage(this.message);
    }

    @Override
    public void executeSend() {
        Log.v((String)TAG, (String)"Sending acknowledged vendor model message");
        super.executeSend();
    }
}

