/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class Features
implements Parcelable {
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    public static final int UNSUPPORTED = 2;
    @SerializedName(value="friend")
    @Expose
    private int friend;
    @SerializedName(value="lowPower")
    @Expose
    private int lowPower;
    @SerializedName(value="proxy")
    @Expose
    private int proxy;
    @SerializedName(value="relay")
    @Expose
    private int relay;
    public static final Parcelable.Creator<Features> CREATOR = new Parcelable.Creator<Features>(){

        public Features createFromParcel(Parcel in) {
            return new Features(in);
        }

        public Features[] newArray(int size) {
            return new Features[size];
        }
    };

    public Features(int friend, int lowPower, int proxy, int relay) {
        this.friend = friend;
        this.lowPower = lowPower;
        this.proxy = proxy;
        this.relay = relay;
    }

    private Features(Parcel in) {
        this.friend = in.readInt();
        this.lowPower = in.readInt();
        this.proxy = in.readInt();
        this.relay = in.readInt();
    }

    public String toString() {
        return "Features{friend=" + this.friend + ", lowPower=" + this.lowPower + ", proxy=" + this.proxy + ", relay=" + this.relay + '}';
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.friend);
        dest.writeInt(this.lowPower);
        dest.writeInt(this.proxy);
        dest.writeInt(this.relay);
    }

    public int describeContents() {
        return 0;
    }

    public int getFriend() {
        return this.friend;
    }

    public void setFriend(int friend) {
        this.friend = friend;
    }

    public int getLowPower() {
        return this.lowPower;
    }

    public void setLowPower(int lowPower) {
        this.lowPower = lowPower;
    }

    public int getProxy() {
        return this.proxy;
    }

    public void setProxy(int proxy) {
        this.proxy = proxy;
    }

    public int getRelay() {
        return this.relay;
    }

    public void setRelay(int relay) {
        this.relay = relay;
    }

    public boolean isFriendFeatureSupported() {
        switch (this.friend) {
            case 2: {
                return false;
            }
        }
        return true;
    }

    public boolean isRelayFeatureSupported() {
        switch (this.relay) {
            case 2: {
                return false;
            }
        }
        return true;
    }

    public boolean isProxyFeatureSupported() {
        switch (this.proxy) {
            case 2: {
                return false;
            }
        }
        return true;
    }

    public boolean isLowPowerFeatureSupported() {
        switch (this.lowPower) {
            case 2: {
                return false;
            }
        }
        return true;
    }

    public int assembleFeatures() {
        int features = this.bitValue(this.relay) << 15;
        features |= this.bitValue(this.proxy) << 14;
        features |= this.bitValue(this.friend) << 13;
        return features |= this.bitValue(this.lowPower) << 12;
    }

    private short bitValue(int feature) {
        switch (feature) {
            default: {
                return 0;
            }
            case 1: 
        }
        return 1;
    }
}

