/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigHeartbeatSubscriptionSet
extends ConfigMessage {
    private static final String TAG = ConfigHeartbeatSubscriptionSet.class.getSimpleName();
    private static final int OP_CODE = 32827;
    private int srcAddress;
    private int dstAddress;
    private final int periodLog;

    public ConfigHeartbeatSubscriptionSet(int srcAddress, int dstAddress, int periodLog) throws IllegalArgumentException {
        if (MeshAddress.isValidHeartbeatSubscriptionSource(srcAddress)) {
            this.srcAddress = srcAddress;
        }
        if (MeshAddress.isValidHeartbeatSubscriptionDestination(dstAddress)) {
            this.dstAddress = dstAddress;
        }
        if (!MeshParserUtils.isValidHeartbeatPeriodLog(periodLog)) {
            throw new IllegalArgumentException("Period log must be within the range of 0x00 to 0x11!");
        }
        this.periodLog = periodLog;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32827;
    }

    @Override
    void assembleMessageParameters() {
        Log.d((String)TAG, (String)("Source address: " + Integer.toHexString(this.srcAddress)));
        Log.d((String)TAG, (String)("Destination address: " + Integer.toHexString(this.dstAddress)));
        Log.d((String)TAG, (String)("Period Log: " + Integer.toHexString(this.periodLog)));
        ByteBuffer paramsBuffer = ByteBuffer.allocate(5).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.srcAddress);
        paramsBuffer.putShort((short)this.dstAddress);
        paramsBuffer.put((byte)this.periodLog);
        this.mParameters = paramsBuffer.array();
    }
}

