/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Embedded;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import no.nordicsemi.android.mesh.Features;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.NodeKey;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.utils.NetworkTransmitSettings;
import no.nordicsemi.android.mesh.utils.RelaySettings;
import no.nordicsemi.android.mesh.utils.SparseIntArrayParcelable;

abstract class ProvisionedBaseMeshNode
implements Parcelable {
    public static final int LOW = 0;
    public static final int HIGH = 1;
    protected static final String TAG = ProvisionedBaseMeshNode.class.getSimpleName();
    @Expose
    @ColumnInfo(name="timestamp")
    public long mTimeStampInMillis;
    @Expose
    @ColumnInfo(name="name")
    protected String nodeName = "My Node";
    @Expose
    @ColumnInfo(name="ttl")
    protected Integer ttl = 5;
    @Expose
    @ColumnInfo(name="blacklisted")
    protected boolean blackListed = false;
    @Expose
    @ColumnInfo(name="secureNetworkBeacon")
    protected Boolean secureNetworkBeaconSupported;
    @Expose
    @Embedded
    protected NetworkTransmitSettings networkTransmitSettings;
    @Expose
    @Embedded
    protected RelaySettings relaySettings;
    @Expose(serialize=false, deserialize=false)
    @ColumnInfo(name="mesh_uuid")
    String meshUuid;
    @PrimaryKey
    @NonNull
    @ColumnInfo(name="uuid")
    String uuid;
    @Expose
    @ColumnInfo(name="security")
    int security = 0;
    @Expose
    @ColumnInfo(name="unicast_address")
    int unicastAddress;
    @Expose
    @ColumnInfo(name="configured")
    boolean isConfigured;
    @Expose
    @ColumnInfo(name="device_key")
    byte[] deviceKey;
    @Expose
    @ColumnInfo(name="seq_number")
    int sequenceNumber = -1;
    @Expose
    @Ignore
    String bluetoothAddress;
    @Expose(serialize=false, deserialize=false)
    @Ignore
    String nodeIdentifier;
    @Expose
    @ColumnInfo(name="cid")
    @Nullable
    Integer companyIdentifier = null;
    @Expose
    @ColumnInfo(name="pid")
    @Nullable
    Integer productIdentifier = null;
    @Expose
    @ColumnInfo(name="vid")
    @Nullable
    Integer versionIdentifier = null;
    @Expose
    @ColumnInfo(name="crpl")
    @Nullable
    Integer crpl = null;
    @Expose
    @Embedded
    Features nodeFeatures = null;
    @Expose
    @Ignore
    SparseIntArrayParcelable mSeqAuth = new SparseIntArrayParcelable();
    @SerializedName(value="netKeys")
    @Expose
    @TypeConverters(value={MeshTypeConverters.class})
    @ColumnInfo(name="netKeys")
    List<NodeKey> mAddedNetKeys = new ArrayList<NodeKey>();
    @SerializedName(value="appKeys")
    @Expose
    @TypeConverters(value={MeshTypeConverters.class})
    @ColumnInfo(name="appKeys")
    List<NodeKey> mAddedAppKeys = new ArrayList<NodeKey>();
    @Expose
    @Ignore
    byte[] mFlags;
    @Expose
    @TypeConverters(value={MeshTypeConverters.class})
    Map<Integer, Element> mElements = new LinkedHashMap<Integer, Element>();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ProvisionedBaseMeshNode() {
    }

    public String getMeshUuid() {
        return this.meshUuid;
    }

    public void setMeshUuid(String meshUuid) {
        this.meshUuid = meshUuid;
    }

    @NonNull
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(@NonNull String uuid) {
        this.uuid = uuid;
    }

    public final boolean isConfigured() {
        return this.isConfigured;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setConfigured(boolean configured) {
        this.isConfigured = configured;
    }

    public final String getNodeName() {
        return this.nodeName;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setNodeName(String nodeName) {
        if (!TextUtils.isEmpty((CharSequence)nodeName)) {
            this.nodeName = nodeName;
        }
    }

    public final int getUnicastAddress() {
        return this.unicastAddress;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setUnicastAddress(int unicastAddress) {
        this.unicastAddress = unicastAddress;
    }

    public int getNumberOfElements() {
        return this.mElements.size();
    }

    public int getLastUnicastAddress() {
        int elementCount = this.getNumberOfElements();
        return elementCount == 1 ? this.unicastAddress : this.unicastAddress + (elementCount - 1);
    }

    public final Integer getTtl() {
        return this.ttl;
    }

    public final void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public final byte[] getFlags() {
        return this.mFlags;
    }

    public final void setFlags(byte[] flags) {
        this.mFlags = flags;
    }

    public long getTimeStamp() {
        return this.mTimeStampInMillis;
    }

    public void setTimeStamp(long timestamp) {
        this.mTimeStampInMillis = timestamp;
    }

    public int getSecurity() {
        return this.security;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setSecurity(int security) {
        this.security = security;
    }

    public boolean isBlackListed() {
        return this.blackListed;
    }

    public void setBlackListed(boolean blackListed) {
        this.blackListed = blackListed;
    }

    public Boolean isSecureNetworkBeaconSupported() {
        return this.secureNetworkBeaconSupported;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setSecureNetworkBeaconSupported(Boolean secureNetworkBeacon) {
        this.secureNetworkBeaconSupported = secureNetworkBeacon;
    }

    public NetworkTransmitSettings getNetworkTransmitSettings() {
        return this.networkTransmitSettings;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setNetworkTransmitSettings(NetworkTransmitSettings networkTransmitSettings) {
        this.networkTransmitSettings = networkTransmitSettings;
    }

    public RelaySettings getRelaySettings() {
        return this.relaySettings;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setRelaySettings(RelaySettings relaySettings) {
        this.relaySettings = relaySettings;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityState {
    }
}

