/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.gson.annotations.Expose;
import java.util.UUID;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public class PublicationSettings
implements Parcelable {
    private static final int DEFAULT_PUBLISH_TTL = 127;
    private static final int DEFAULT_PUBLICATION_STEPS = 0;
    private static final int DEFAULT_PUBLICATION_RESOLUTION = 0;
    public static final int MIN_PUBLICATION_RETRANSMIT_COUNT = 0;
    public static final int MAX_PUBLICATION_RETRANSMIT_COUNT = 7;
    private static final int DEFAULT_PUBLICATION_RETRANSMIT_INTERVAL_STEPS = 0;
    private static final int MAX_PUBLICATION_RETRANSMIT_INTERVAL_STEPS = 31;
    @Expose
    private int publishAddress;
    @Expose
    private UUID labelUUID;
    @Expose
    private int appKeyIndex;
    @Expose
    private boolean credentialFlag;
    @Expose
    private int publishTtl = 127;
    @Expose
    private int publicationSteps = 0;
    @Expose
    private int publicationResolution = 0;
    @Expose
    private int publishRetransmitCount = 0;
    @Expose
    private int publishRetransmitIntervalSteps = 0;
    public static final Parcelable.Creator<PublicationSettings> CREATOR = new Parcelable.Creator<PublicationSettings>(){

        public PublicationSettings createFromParcel(Parcel in) {
            return new PublicationSettings(in);
        }

        public PublicationSettings[] newArray(int size) {
            return new PublicationSettings[size];
        }
    };

    PublicationSettings() {
    }

    public PublicationSettings(int publishAddress, int appKeyIndex, boolean credentialFlag, int publishRetransmitCount, int publishRetransmitIntervalSteps) {
        this(publishAddress, appKeyIndex, credentialFlag, 127, 0, 0, 0, 0);
    }

    PublicationSettings(int publishAddress, int appKeyIndex, boolean credentialFlag, int publishTtl, int publicationSteps, int publicationResolution, int publishRetransmitCount, int publishRetransmitIntervalSteps) {
        this(publishAddress, null, appKeyIndex, credentialFlag, publishTtl, publicationSteps, publicationResolution, publishRetransmitCount, publishRetransmitIntervalSteps);
    }

    PublicationSettings(int publishAddress, @Nullable UUID labelUUID, int appKeyIndex, boolean credentialFlag, int publishTtl, int publicationSteps, int publicationResolution, int publishRetransmitCount, int publishRetransmitIntervalSteps) {
        this.publishAddress = publishAddress;
        this.labelUUID = labelUUID;
        this.appKeyIndex = appKeyIndex;
        this.credentialFlag = credentialFlag;
        this.publishTtl = publishTtl;
        this.publicationSteps = publicationSteps;
        this.publicationResolution = publicationResolution;
        this.publishRetransmitCount = publishRetransmitCount;
        this.publishRetransmitIntervalSteps = publishRetransmitIntervalSteps;
    }

    private PublicationSettings(Parcel in) {
        ParcelUuid parcelUuid;
        this.publishAddress = in.readInt();
        if (MeshAddress.isValidVirtualAddress(this.publishAddress) && (parcelUuid = (ParcelUuid)in.readParcelable(ParcelUuid.class.getClassLoader())) != null) {
            this.labelUUID = parcelUuid.getUuid();
        }
        this.appKeyIndex = in.readInt();
        this.credentialFlag = in.readInt() == 1;
        this.publishTtl = in.readInt();
        this.publicationSteps = in.readInt();
        this.publicationResolution = in.readInt();
        this.publishRetransmitCount = in.readInt();
        this.publishRetransmitIntervalSteps = in.readInt();
    }

    public int getPublishAddress() {
        return this.publishAddress;
    }

    public void setPublishAddress(int publishAddress) {
        this.publishAddress = publishAddress;
    }

    @Nullable
    public UUID getLabelUUID() {
        return this.labelUUID;
    }

    void setLabelUUID(@Nullable UUID labelUUID) {
        this.labelUUID = labelUUID;
    }

    public int getAppKeyIndex() {
        return this.appKeyIndex;
    }

    public void setAppKeyIndex(int appKeyIndex) {
        this.appKeyIndex = appKeyIndex;
    }

    public boolean getCredentialFlag() {
        return this.credentialFlag;
    }

    void setCredentialFlag(boolean credentialFlag) {
        this.credentialFlag = credentialFlag;
    }

    public int getPublishTtl() {
        return this.publishTtl & 0xFF;
    }

    void setPublishTtl(int publishTtl) {
        this.publishTtl = publishTtl;
    }

    public int getPublishRetransmitCount() {
        return this.publishRetransmitCount;
    }

    void setPublishRetransmitCount(int publishRetransmitCount) {
        this.publishRetransmitCount = publishRetransmitCount;
    }

    public int getPublishRetransmitIntervalSteps() {
        return this.publishRetransmitIntervalSteps;
    }

    void setPublishRetransmitIntervalSteps(int publishRetransmitIntervalSteps) {
        this.publishRetransmitIntervalSteps = publishRetransmitIntervalSteps;
    }

    public int getPublicationSteps() {
        return this.publicationSteps;
    }

    void setPublicationSteps(int publicationSteps) {
        this.publicationSteps = publicationSteps;
    }

    public int getPublicationResolution() {
        return this.publicationResolution;
    }

    void setPublicationResolution(int publicationResolution) {
        this.publicationResolution = publicationResolution;
    }

    int encodePublicationPeriod() {
        switch (this.publicationResolution) {
            default: {
                return this.publicationSteps * 100;
            }
            case 1: {
                return this.publicationSteps * 1000;
            }
            case 2: {
                return this.publicationSteps * 10 * 1000;
            }
            case 3: 
        }
        return this.publicationSteps * 10 * 10000 * 60;
    }

    public int getPublishPeriod() {
        switch (this.publicationResolution) {
            default: {
                return 100 * this.publicationSteps / 1000;
            }
            case 1: {
                return this.publicationSteps;
            }
            case 2: {
                return 10 * this.publicationSteps;
            }
            case 3: 
        }
        return 10 * this.publicationSteps * 60;
    }

    public static int getPublishPeriod(int publicationResolution, int publicationSteps) {
        switch (publicationResolution) {
            default: {
                return 100 * publicationSteps;
            }
            case 1: {
                return publicationSteps;
            }
            case 2: {
                return 10 * publicationSteps;
            }
            case 3: 
        }
        return 10 * publicationSteps * 60;
    }

    public int getRetransmissionInterval() {
        return (this.publishRetransmitIntervalSteps + 1) * 50;
    }

    public static int getRetransmissionInterval(int intervalSteps) {
        if (intervalSteps >= 0 && intervalSteps <= 31) {
            return (intervalSteps + 1) * 50;
        }
        return 0;
    }

    public static int getMinRetransmissionInterval() {
        return 50;
    }

    public static int getMaxRetransmissionInterval() {
        return 1600;
    }

    public static int parseRetransmitIntervalSteps(int retransmitInterval) {
        if (retransmitInterval >= 0 && retransmitInterval <= PublicationSettings.getMaxRetransmissionInterval()) {
            return retransmitInterval / 50 - 1;
        }
        throw new IllegalArgumentException("Invalid retransmit interval");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.publishAddress);
        if (MeshAddress.isValidVirtualAddress(this.publishAddress)) {
            dest.writeParcelable((Parcelable)new ParcelUuid(this.labelUUID), flags);
        }
        dest.writeInt(this.appKeyIndex);
        dest.writeInt(this.credentialFlag ? 1 : 0);
        dest.writeInt(this.publishTtl);
        dest.writeInt(this.publicationSteps);
        dest.writeInt(this.publicationResolution);
        dest.writeInt(this.publishRetransmitCount);
        dest.writeInt(this.publishRetransmitIntervalSteps);
    }
}

