/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import no.nordicsemi.android.mesh.utils.Heartbeat;

public class HeartbeatSubscription
extends Heartbeat
implements Parcelable {
    @Expose
    @SerializedName(value="source")
    private final int src;
    @Expose
    @SerializedName(value="destination")
    private final int dst;
    @Expose
    @SerializedName(value="period")
    private final int periodLog;
    @Expose
    @SerializedName(value="count")
    private final int countLog;
    @Expose
    @SerializedName(value="minHops")
    private final int minHops;
    @Expose
    @SerializedName(value="maxHops")
    private final int maxHops;
    public static final Parcelable.Creator<HeartbeatSubscription> CREATOR = new Parcelable.Creator<HeartbeatSubscription>(){

        public HeartbeatSubscription createFromParcel(Parcel in) {
            return new HeartbeatSubscription(in);
        }

        public HeartbeatSubscription[] newArray(int size) {
            return new HeartbeatSubscription[size];
        }
    };

    public HeartbeatSubscription(int src, int dst, int periodLog, int countLog, int minHops, int maxHops) {
        this.src = src;
        this.dst = dst;
        this.periodLog = periodLog;
        this.countLog = countLog;
        this.minHops = minHops;
        this.maxHops = maxHops;
    }

    private HeartbeatSubscription(Parcel in) {
        this.src = in.readInt();
        this.dst = in.readInt();
        this.periodLog = in.readInt();
        this.countLog = in.readInt();
        this.minHops = in.readInt();
        this.maxHops = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.src);
        dest.writeInt(this.dst);
        dest.writeInt(this.periodLog);
        dest.writeInt(this.countLog);
        dest.writeInt(this.minHops);
        dest.writeInt(this.maxHops);
    }

    @NonNull
    public String toString() {
        return "Source address: " + Integer.toHexString(this.src) + "\nDestination address: " + Integer.toHexString(this.dst) + "\nPeriod Log: " + Integer.toHexString(this.periodLog) + "\nCount Log: " + Integer.toHexString(this.countLog) + "\nMin Hops: " + this.minHops + "\n Max Hops: " + this.maxHops;
    }

    public int getSrc() {
        return this.src;
    }

    public int getDst() {
        return this.dst;
    }

    public int getPeriodLog() {
        return this.periodLog;
    }

    public int getCountLog() {
        return this.countLog;
    }

    public int getMinHops() {
        return this.minHops;
    }

    public int getMaxHops() {
        return this.maxHops;
    }
}

