/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.UUID;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.utils.MeshAddress;

@Entity(tableName="groups", foreignKeys={@ForeignKey(entity=MeshNetwork.class, parentColumns={"mesh_uuid"}, childColumns={"mesh_uuid"}, onUpdate=5, onDelete=5)}, indices={@Index(value={"mesh_uuid"})})
public class Group
implements Parcelable {
    @PrimaryKey(autoGenerate=true)
    public int id = 0;
    @Expose
    @SerializedName(value="name")
    @ColumnInfo(name="name")
    private String name = "Mesh Group";
    @Expose
    @SerializedName(value="address")
    @ColumnInfo(name="group_address")
    private int address;
    @Expose(serialize=false, deserialize=false)
    @TypeConverters(value={MeshTypeConverters.class})
    @ColumnInfo(name="group_address_label")
    private UUID addressLabel;
    @Expose
    @SerializedName(value="parentAddress")
    @ColumnInfo(name="parent_address")
    private int parentAddress;
    @Expose(serialize=false, deserialize=false)
    @TypeConverters(value={MeshTypeConverters.class})
    @ColumnInfo(name="parent_address_label")
    private UUID parentAddressLabel;
    @Expose
    @SerializedName(value="meshUuid")
    @ColumnInfo(name="mesh_uuid")
    private String meshUuid;
    public static final Parcelable.Creator<Group> CREATOR = new Parcelable.Creator<Group>(){

        public Group createFromParcel(Parcel in) {
            return new Group(in);
        }

        public Group[] newArray(int size) {
            return new Group[size];
        }
    };

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Group(int id, int address, @Nullable UUID addressLabel, int parentAddress, @Nullable UUID parentAddressLabel, @NonNull String meshUuid) throws IllegalArgumentException {
        this(address, addressLabel, parentAddress, parentAddressLabel, meshUuid);
        this.id = id;
    }

    @Ignore
    public Group(int address, @NonNull String meshUuid) throws IllegalArgumentException {
        this(address, null, 0, null, meshUuid);
    }

    @Ignore
    public Group(int address, int parentAddress, @NonNull String meshUuid) throws IllegalArgumentException {
        this(address, null, parentAddress, null, meshUuid);
    }

    @Ignore
    public Group(int address, @NonNull UUID parentAddressLabel, @NonNull String meshUuid) throws IllegalArgumentException {
        this(address, null, 0, parentAddressLabel, meshUuid);
    }

    @Ignore
    public Group(@NonNull UUID addressLabel, int parentAddress, @NonNull String meshUuid) throws IllegalArgumentException {
        this(0, addressLabel, parentAddress, null, meshUuid);
    }

    @Ignore
    public Group(@NonNull UUID addressLabel, @Nullable UUID parentAddressLabel, @NonNull String meshUuid) throws IllegalArgumentException {
        this(0, addressLabel, 0, parentAddressLabel, meshUuid);
    }

    private Group(int address, @Nullable UUID addressLabel, int parentAddress, @Nullable UUID parentAddressLabel, @NonNull String meshUuid) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnassignedAddress(address) && MeshAddress.isValidUnassignedAddress(parentAddress) && address == parentAddress) {
            throw new IllegalArgumentException("The value of the parentAddress property shall not be equal to the value of the address property");
        }
        if (addressLabel == null) {
            if (MeshAddress.isValidVirtualAddress(address)) {
                throw new IllegalArgumentException("Please provide a Label UUID when creating groups using virtual addresses");
            }
            if (!MeshAddress.isValidGroupAddress(address)) {
                throw new IllegalArgumentException("Address of the group must be a valid group address or a virtual address");
            }
            this.address = address;
            this.generateParentAddressLabel(parentAddressLabel, parentAddress);
        } else {
            this.addressLabel = addressLabel;
            this.address = MeshAddress.generateVirtualAddress(addressLabel);
            this.generateParentAddressLabel(parentAddressLabel, parentAddress);
        }
        this.meshUuid = meshUuid;
    }

    private void generateParentAddressLabel(@Nullable UUID parentAddressLabel, int parentAddress) throws IllegalArgumentException {
        this.parentAddressLabel = parentAddressLabel;
        if (parentAddressLabel == null) {
            if (MeshAddress.isValidVirtualAddress(parentAddress)) {
                throw new IllegalArgumentException("Please provide a Label UUID for the parent address of this group");
            }
            if (!MeshAddress.isValidGroupAddress(parentAddress) && !MeshAddress.isValidUnassignedAddress(parentAddress)) {
                throw new IllegalArgumentException("parentAddress value must be a group address, virtual address or an unassigned address");
            }
            this.parentAddress = parentAddress;
        } else {
            this.parentAddress = MeshAddress.generateVirtualAddress(parentAddressLabel);
        }
    }

    protected Group(Parcel in) {
        this.id = in.readInt();
        this.name = in.readString();
        this.address = in.readInt();
        this.addressLabel = this.readVirtualLabelFromParcelable(in, this.address);
        this.parentAddress = in.readInt();
        this.parentAddressLabel = this.readVirtualLabelFromParcelable(in, this.parentAddress);
        this.meshUuid = in.readString();
    }

    private UUID readVirtualLabelFromParcelable(Parcel in, int address) {
        ParcelUuid parcelUuid;
        if (MeshAddress.isValidVirtualAddress(address) && (parcelUuid = (ParcelUuid)in.readParcelable(ParcelUuid.class.getClassLoader())) != null) {
            return parcelUuid.getUuid();
        }
        return null;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.id);
        dest.writeString(this.name);
        dest.writeInt(this.address);
        this.writeVirtualLabelToParcel(dest, flags, this.address, this.addressLabel);
        dest.writeInt(this.parentAddress);
        this.writeVirtualLabelToParcel(dest, flags, this.parentAddress, this.parentAddressLabel);
        dest.writeString(this.meshUuid);
    }

    private void writeVirtualLabelToParcel(Parcel dest, int flags, int address, UUID addressLabel) {
        if (MeshAddress.isValidVirtualAddress(address)) {
            dest.writeParcelable((Parcelable)new ParcelUuid(addressLabel), flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public String getMeshUuid() {
        return this.meshUuid;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setMeshUuid(String meshUuid) {
        this.meshUuid = meshUuid;
    }

    public int getAddress() {
        return this.address;
    }

    @Nullable
    public UUID getAddressLabel() {
        return this.addressLabel;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setAddressLabel(@Nullable UUID uuidLabel) {
        this.addressLabel = uuidLabel;
        if (uuidLabel != null) {
            this.address = MeshAddress.generateVirtualAddress(uuidLabel);
        }
    }

    public UUID getParentAddressLabel() {
        return this.parentAddressLabel;
    }

    public void setParentAddressLabel(@Nullable UUID parentAddressLabel) {
        this.parentAddressLabel = parentAddressLabel;
        if (parentAddressLabel != null) {
            this.parentAddress = MeshAddress.generateVirtualAddress(parentAddressLabel);
        }
    }

    public int getParentAddress() {
        return this.parentAddress;
    }

    public void setParentAddress(int parentAddress) {
        if (MeshAddress.isValidVirtualAddress(parentAddress)) {
            throw new IllegalArgumentException("Assigning a virtual address to parentAddress can be done only by setting a parent address label");
        }
        if (!MeshAddress.isValidGroupAddress(parentAddress)) {
            throw new IllegalArgumentException("parentAddress must be a group address value");
        }
        this.parentAddress = parentAddress;
        this.parentAddressLabel = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = name;
    }
}

