/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.google.gson.annotations.Expose;
import java.util.List;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshTypeConverters;

@Entity(tableName="scene", foreignKeys={@ForeignKey(entity=MeshNetwork.class, parentColumns={"mesh_uuid"}, childColumns={"mesh_uuid"}, onUpdate=5, onDelete=5)}, indices={@Index(value={"mesh_uuid"})})
public class Scene {
    @Expose
    @ColumnInfo(name="mesh_uuid")
    private String meshUuid;
    @Expose
    @ColumnInfo(name="name")
    private String name = "nRF Scene";
    @Expose
    @TypeConverters(value={MeshTypeConverters.class})
    private List<Integer> addresses;
    @Expose
    @PrimaryKey
    @ColumnInfo(name="number")
    private int number;

    public Scene(int number, List<Integer> addresses, String meshUuid) {
        this.number = number;
        this.addresses = addresses;
        this.meshUuid = meshUuid;
    }

    public String getMeshUuid() {
        return this.meshUuid;
    }

    public void setMeshUuid(String meshUuid) {
        this.meshUuid = meshUuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Integer> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Integer> addresses) {
        this.addresses = addresses;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public static boolean isValidScene(int scene) {
        return scene >= 0 && scene <= 65535;
    }
}

