/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteStatement;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.data.SceneDao;

public final class SceneDao_Impl
implements SceneDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Scene> __insertionAdapterOfScene;
    private final EntityDeletionOrUpdateAdapter<Scene> __deletionAdapterOfScene;
    private final EntityDeletionOrUpdateAdapter<Scene> __updateAdapterOfScene;

    public SceneDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfScene = new EntityInsertionAdapter<Scene>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `scene` (`mesh_uuid`,`name`,`addresses`,`number`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Scene value) {
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUuid());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                String _tmp = MeshTypeConverters.integerToJson(value.getAddresses());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                stmt.bindLong(4, (long)value.getNumber());
            }
        };
        this.__deletionAdapterOfScene = new EntityDeletionOrUpdateAdapter<Scene>(__db){

            public String createQuery() {
                return "DELETE FROM `scene` WHERE `number` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Scene value) {
                stmt.bindLong(1, (long)value.getNumber());
            }
        };
        this.__updateAdapterOfScene = new EntityDeletionOrUpdateAdapter<Scene>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `scene` SET `mesh_uuid` = ?,`name` = ?,`addresses` = ?,`number` = ? WHERE `number` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Scene value) {
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUuid());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                String _tmp = MeshTypeConverters.integerToJson(value.getAddresses());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                stmt.bindLong(4, (long)value.getNumber());
                stmt.bindLong(5, (long)value.getNumber());
            }
        };
    }

    @Override
    public void insert(Scene scene) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfScene.insert((Object)scene);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(Scene scene) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfScene.handle((Object)scene);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Scene scene) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfScene.handle((Object)scene);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

