/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import no.nordicsemi.android.mesh.models.SigModelParser;
import no.nordicsemi.android.mesh.models.VendorModel;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.utils.DeviceFeatureUtils;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigCompositionDataStatus
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigCompositionDataStatus.class.getSimpleName();
    private static final int OP_CODE = 2;
    private static final int ELEMENTS_OFFSET = 12;
    private int companyIdentifier;
    private int productIdentifier;
    private int versionIdentifier;
    private int crpl;
    private int features;
    private boolean relayFeatureSupported;
    private boolean proxyFeatureSupported;
    private boolean friendFeatureSupported;
    private boolean lowPowerFeatureSupported;
    private Map<Integer, Element> mElements = new LinkedHashMap<Integer, Element>();
    private static final Parcelable.Creator<ConfigCompositionDataStatus> CREATOR = new Parcelable.Creator<ConfigCompositionDataStatus>(){

        public ConfigCompositionDataStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigCompositionDataStatus(message);
        }

        public ConfigCompositionDataStatus[] newArray(int size) {
            return new ConfigCompositionDataStatus[size];
        }
    };

    public ConfigCompositionDataStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        this.parseCompositionDataPages();
    }

    private void parseCompositionDataPages() {
        AccessMessage message = (AccessMessage)this.mMessage;
        byte[] accessPayload = message.getAccessPdu();
        this.companyIdentifier = MeshParserUtils.unsignedBytesToInt(accessPayload[2], accessPayload[3]);
        Log.v((String)TAG, (String)("Company identifier: " + String.format(Locale.US, "%04X", this.companyIdentifier)));
        this.productIdentifier = MeshParserUtils.unsignedBytesToInt(accessPayload[4], accessPayload[5]);
        Log.v((String)TAG, (String)("Product identifier: " + String.format(Locale.US, "%04X", this.productIdentifier)));
        this.versionIdentifier = MeshParserUtils.unsignedBytesToInt(accessPayload[6], accessPayload[7]);
        Log.v((String)TAG, (String)("Version identifier: " + String.format(Locale.US, "%04X", this.versionIdentifier)));
        this.crpl = MeshParserUtils.unsignedBytesToInt(accessPayload[8], accessPayload[9]);
        Log.v((String)TAG, (String)("crpl: " + String.format(Locale.US, "%04X", this.crpl)));
        this.features = MeshParserUtils.unsignedBytesToInt(accessPayload[10], accessPayload[11]);
        Log.v((String)TAG, (String)("Features: " + String.format(Locale.US, "%04X", this.features)));
        this.relayFeatureSupported = DeviceFeatureUtils.supportsRelayFeature(this.features);
        Log.v((String)TAG, (String)("Relay feature: " + this.relayFeatureSupported));
        this.proxyFeatureSupported = DeviceFeatureUtils.supportsProxyFeature(this.features);
        Log.v((String)TAG, (String)("Proxy feature: " + this.proxyFeatureSupported));
        this.friendFeatureSupported = DeviceFeatureUtils.supportsFriendFeature(this.features);
        Log.v((String)TAG, (String)("Friend feature: " + this.friendFeatureSupported));
        this.lowPowerFeatureSupported = DeviceFeatureUtils.supportsLowPowerFeature(this.features);
        Log.v((String)TAG, (String)("Low power feature: " + this.lowPowerFeatureSupported));
        this.parseElements(accessPayload, message.getSrc());
        Log.v((String)TAG, (String)("Number of elements: " + this.mElements.size()));
    }

    private void parseElements(byte[] accessPayload, int src) {
        int tempOffset = 12;
        int counter = 0;
        int elementAddress = 0;
        while (tempOffset < accessPayload.length) {
            int i;
            LinkedHashMap<Integer, MeshModel> models = new LinkedHashMap<Integer, MeshModel>();
            int locationDescriptor = accessPayload[tempOffset + 1] << 8 | accessPayload[tempOffset];
            Log.v((String)TAG, (String)("Location identifier: " + String.format(Locale.US, "%04X", locationDescriptor)));
            int numSigModelIds = accessPayload[tempOffset += 2];
            Log.v((String)TAG, (String)("Number of sig models: " + String.format(Locale.US, "%04X", numSigModelIds)));
            int numVendorModelIds = accessPayload[++tempOffset];
            Log.v((String)TAG, (String)("Number of vendor models: " + String.format(Locale.US, "%04X", numVendorModelIds)));
            ++tempOffset;
            if (numSigModelIds > 0) {
                for (i = 0; i < numSigModelIds; ++i) {
                    int modelId = MeshParserUtils.unsignedBytesToInt(accessPayload[tempOffset], accessPayload[tempOffset + 1]);
                    models.put(modelId, SigModelParser.getSigModel(modelId));
                    Log.v((String)TAG, (String)("Sig model ID " + i + " : " + String.format(Locale.US, "%04X", modelId)));
                    tempOffset += 2;
                }
            }
            if (numVendorModelIds > 0) {
                for (i = 0; i < numVendorModelIds; ++i) {
                    int companyIdentifier = MeshParserUtils.unsignedBytesToInt(accessPayload[tempOffset], accessPayload[tempOffset + 1]);
                    int modelIdentifier = MeshParserUtils.unsignedBytesToInt(accessPayload[tempOffset + 2], accessPayload[tempOffset + 3]);
                    int vendorModelIdentifier = companyIdentifier << 16 | modelIdentifier;
                    models.put(vendorModelIdentifier, new VendorModel(vendorModelIdentifier));
                    Log.v((String)TAG, (String)("Vendor - model ID " + i + " : " + String.format(Locale.US, "%08X", vendorModelIdentifier)));
                    tempOffset += 4;
                }
            }
            elementAddress = counter == 0 ? src : ++elementAddress;
            ++counter;
            Element element = new Element(elementAddress, locationDescriptor, models);
            int unicastAddress = elementAddress;
            this.mElements.put(unicastAddress, element);
        }
    }

    public int getCompanyIdentifier() {
        return this.companyIdentifier;
    }

    public int getProductIdentifier() {
        return this.productIdentifier;
    }

    public int getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public int getCrpl() {
        return this.crpl;
    }

    public int getFeatures() {
        return this.features;
    }

    public boolean isRelayFeatureSupported() {
        return this.relayFeatureSupported;
    }

    public boolean isProxyFeatureSupported() {
        return this.proxyFeatureSupported;
    }

    public boolean isFriendFeatureSupported() {
        return this.friendFeatureSupported;
    }

    public boolean isLowPowerFeatureSupported() {
        return this.lowPowerFeatureSupported;
    }

    public Map<Integer, Element> getElements() {
        return this.mElements;
    }

    private int parseCompanyIdentifier(short companyIdentifier) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(companyIdentifier).getShort(0);
    }

    private int parseProductIdentifier(short productIdentifier) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(productIdentifier).getShort(0);
    }

    private int parseVersionIdentifier(short versionIdentifier) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(versionIdentifier).getShort(0);
    }

    private int parseCrpl(short companyIdentifier) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(companyIdentifier).getShort(0);
    }

    private int parseFeatures(short companyIdentifier) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(companyIdentifier).getShort(0);
    }

    @Override
    int getOpCode() {
        return 2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

