/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import no.nordicsemi.android.mesh.Features;
import no.nordicsemi.android.mesh.NodeKey;
import no.nordicsemi.android.mesh.models.ConfigurationServerModel;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.CompositionDataParser;
import no.nordicsemi.android.mesh.utils.HeartbeatPublication;
import no.nordicsemi.android.mesh.utils.HeartbeatSubscription;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.NetworkTransmitSettings;
import no.nordicsemi.android.mesh.utils.RelaySettings;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class NodeDeserializer
implements JsonSerializer<List<ProvisionedMeshNode>>,
JsonDeserializer<List<ProvisionedMeshNode>> {
    public List<ProvisionedMeshNode> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<ProvisionedMeshNode> nodes = new ArrayList<ProvisionedMeshNode>();
        JsonArray jsonArray = json.getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            int unicastAddress;
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            ProvisionedMeshNode node = new ProvisionedMeshNode();
            String uuid = MeshParserUtils.formatUuid(jsonObject.get("UUID").getAsString());
            if (uuid == null) {
                throw new IllegalArgumentException("Invalid Mesh Provisioning/Configuration Database, invalid node UUID.");
            }
            node.uuid = uuid;
            node.deviceKey = MeshParserUtils.toByteArray(jsonObject.get("deviceKey").getAsString());
            node.unicastAddress = unicastAddress = Integer.parseInt(jsonObject.get("unicastAddress").getAsString(), 16);
            boolean security = jsonObject.get("security").getAsString().equals("high");
            node.security = security ? 1 : 0;
            node.mAddedNetKeys = this.deserializeAddedIndexes(jsonObject.get("netKeys").getAsJsonArray());
            node.isConfigured = jsonObject.get("configComplete").getAsBoolean();
            if (jsonObject.has("cid")) {
                node.companyIdentifier = Integer.parseInt(jsonObject.get("cid").getAsString(), 16);
            }
            if (jsonObject.has("pid")) {
                node.productIdentifier = Integer.parseInt(jsonObject.get("pid").getAsString(), 16);
            }
            if (jsonObject.has("vid")) {
                node.versionIdentifier = Integer.parseInt(jsonObject.get("vid").getAsString(), 16);
            }
            if (jsonObject.has("crpl")) {
                node.crpl = Integer.parseInt(jsonObject.get("crpl").getAsString(), 16);
            }
            if (jsonObject.has("features")) {
                JsonObject featuresJson = jsonObject.get("features").getAsJsonObject();
                node.nodeFeatures = new Features(featuresJson.get("friend").getAsInt(), featuresJson.get("lowPower").getAsInt(), featuresJson.get("relay").getAsInt(), featuresJson.get("proxy").getAsInt());
            }
            if (jsonObject.has("secureNetworkBeacon")) {
                node.setSecureNetworkBeaconSupported(jsonObject.get("secureNetworkBeacon").getAsBoolean());
            }
            if (jsonObject.has("defaultTTL") && !jsonObject.get("defaultTTL").isJsonNull()) {
                node.ttl = jsonObject.get("defaultTTL").getAsInt();
            }
            if (jsonObject.has("networkTransmit")) {
                JsonObject jsonNetTransmit = jsonObject.getAsJsonObject("networkTransmit");
                NetworkTransmitSettings networkTransmitSettings = new NetworkTransmitSettings(jsonNetTransmit.get("count").getAsInt(), jsonNetTransmit.get("interval").getAsInt());
                node.setNetworkTransmitSettings(networkTransmitSettings);
            }
            if (jsonObject.has("relayRetransmit")) {
                JsonObject jsonRelay = jsonObject.getAsJsonObject("relayRetransmit");
                RelaySettings relaySettings = new RelaySettings(jsonRelay.get("count").getAsInt(), jsonRelay.get("interval").getAsInt());
                node.setRelaySettings(relaySettings);
            }
            if (jsonObject.has("appKeys")) {
                node.mAddedAppKeys = this.deserializeAddedIndexes(jsonObject.get("appKeys").getAsJsonArray());
            }
            if (jsonObject.has("elements")) {
                List<Element> elements = this.deserializeElements(context, jsonObject);
                Map<Integer, Element> elementMap = this.populateElements(unicastAddress, elements);
                node.mElements.clear();
                node.mElements.putAll(elementMap);
            }
            if (jsonObject.has("blacklisted")) {
                node.setBlackListed(jsonObject.get("blacklisted").getAsBoolean());
            }
            if (jsonObject.has("name")) {
                node.nodeName = jsonObject.get("name").getAsString();
            }
            this.deserializeHeartbeat(context, jsonObject, node);
            nodes.add(node);
        }
        return nodes;
    }

    public JsonElement serialize(List<ProvisionedMeshNode> nodes, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (ProvisionedMeshNode node : nodes) {
            JsonObject json;
            JsonObject nodeJson = new JsonObject();
            nodeJson.addProperty("UUID", MeshParserUtils.uuidToHex(node.getUuid()));
            nodeJson.addProperty("name", node.getNodeName());
            nodeJson.addProperty("deviceKey", MeshParserUtils.bytesToHex(node.getDeviceKey(), false));
            nodeJson.addProperty("unicastAddress", MeshParserUtils.bytesToHex(MeshAddress.addressIntToBytes(node.getUnicastAddress()), false));
            nodeJson.addProperty("security", node.getSecurity() == 1 ? "high" : "low");
            nodeJson.addProperty("configComplete", Boolean.valueOf(node.isConfigured()));
            if (node.getCompanyIdentifier() != null) {
                nodeJson.addProperty("cid", CompositionDataParser.formatCompanyIdentifier(node.getCompanyIdentifier(), false));
            }
            if (node.getProductIdentifier() != null) {
                nodeJson.addProperty("pid", CompositionDataParser.formatProductIdentifier(node.getProductIdentifier(), false));
            }
            if (node.getVersionIdentifier() != null) {
                nodeJson.addProperty("vid", CompositionDataParser.formatVersionIdentifier(node.getVersionIdentifier(), false));
            }
            if (node.getCrpl() != null) {
                nodeJson.addProperty("crpl", CompositionDataParser.formatReplayProtectionCount(node.getCrpl(), false));
            }
            if (node.getNodeFeatures() != null) {
                json = new JsonObject();
                json.addProperty("friend", (Number)node.getNodeFeatures().getFriend());
                json.addProperty("lowPower", (Number)node.getNodeFeatures().getLowPower());
                json.addProperty("proxy", (Number)node.getNodeFeatures().getProxy());
                json.addProperty("relay", (Number)node.getNodeFeatures().getRelay());
                nodeJson.add("features", (JsonElement)json);
            }
            if (node.isSecureNetworkBeaconSupported() != null) {
                nodeJson.addProperty("secureNetworkBeacon", node.isSecureNetworkBeaconSupported());
            }
            nodeJson.addProperty("defaultTTL", (Number)node.getTtl());
            if (node.getNetworkTransmitSettings() != null) {
                json = new JsonObject();
                json.addProperty("count", (Number)node.getNetworkTransmitSettings().getNetworkTransmitCount());
                json.addProperty("interval", (Number)node.getNetworkTransmitSettings().getNetworkIntervalSteps());
                nodeJson.add("networkTransmit", (JsonElement)json);
            }
            if (node.getRelaySettings() != null) {
                json = new JsonObject();
                json.addProperty("count", (Number)node.getRelaySettings().getRelayTransmitCount());
                json.addProperty("interval", (Number)node.getRelaySettings().getRelayIntervalSteps());
                nodeJson.add("relayRetransmit", (JsonElement)json);
            }
            nodeJson.add("netKeys", this.serializeAddedIndexes(node.getAddedNetKeys()));
            nodeJson.add("appKeys", this.serializeAddedIndexes(node.getAddedAppKeys()));
            nodeJson.add("elements", this.serializeElements(context, node.getElements()));
            nodeJson.addProperty("blacklisted", Boolean.valueOf(node.isBlackListed()));
            this.serializeHeartbeat(context, nodeJson, node);
            jsonArray.add((JsonElement)nodeJson);
        }
        return jsonArray;
    }

    private JsonElement serializeAddedIndexes(List<NodeKey> addedKeyIndexes) {
        JsonArray addedKeys = new JsonArray();
        for (NodeKey nodeKey : addedKeyIndexes) {
            JsonObject keyIndexJson = new JsonObject();
            keyIndexJson.addProperty("index", (Number)nodeKey.getIndex());
            keyIndexJson.addProperty("updated", Boolean.valueOf(nodeKey.isUpdated()));
            addedKeys.add((JsonElement)keyIndexJson);
        }
        return addedKeys;
    }

    private List<NodeKey> deserializeAddedIndexes(JsonArray jsonNetKeyIndexes) {
        ArrayList<NodeKey> addedKeys = new ArrayList<NodeKey>();
        for (int i = 0; i < jsonNetKeyIndexes.size(); ++i) {
            JsonObject jsonAddedKeys = jsonNetKeyIndexes.get(i).getAsJsonObject();
            int index = jsonAddedKeys.get("index").getAsInt();
            boolean updated = false;
            if (jsonAddedKeys.has("updated")) {
                updated = jsonAddedKeys.get("updated").getAsBoolean();
            }
            addedKeys.add(new NodeKey(index, updated));
        }
        return addedKeys;
    }

    private JsonElement serializeElements(JsonSerializationContext context, Map<Integer, Element> elementsMap) {
        Type elementsList = new TypeToken<List<Element>>(){}.getType();
        return context.serialize(this.populateElements(elementsMap), elementsList);
    }

    private List<Element> deserializeElements(JsonDeserializationContext context, JsonObject json) {
        Type elementList = new TypeToken<List<Element>>(){}.getType();
        return (List)context.deserialize((JsonElement)json.getAsJsonArray("elements"), elementList);
    }

    private Map<Integer, Element> populateElements(int unicastAddress, List<Element> elementsList) {
        LinkedHashMap<Integer, Element> elements = new LinkedHashMap<Integer, Element>();
        int address = 0;
        for (int i = 0; i < elementsList.size(); ++i) {
            Element element = elementsList.get(i);
            element.elementAddress = i == 0 ? (address = unicastAddress) : ++address;
            if (TextUtils.isEmpty((CharSequence)element.name)) {
                element.name = "Element: " + MeshAddress.formatAddress(element.elementAddress, true);
            }
            elements.put(element.elementAddress, element);
        }
        return elements;
    }

    private List<Element> populateElements(Map<Integer, Element> elementMap) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Map.Entry<Integer, Element> elementEntry : elementMap.entrySet()) {
            elements.add(elementEntry.getValue());
        }
        return elements;
    }

    private void deserializeHeartbeat(@NonNull JsonDeserializationContext context, @NonNull JsonObject jsonObject, @NonNull ProvisionedMeshNode node) {
        ConfigurationServerModel model = this.getConfigurationServerModel(node);
        if (model != null) {
            if (jsonObject.has("heartbeatPub")) {
                model.setHeartbeatPublication((HeartbeatPublication)context.deserialize(jsonObject.get("heartbeatPub"), HeartbeatPublication.class));
            }
            if (jsonObject.has("heartbeatSub")) {
                model.setHeartbeatSubscription((HeartbeatSubscription)context.deserialize(jsonObject.get("heartbeatSub"), HeartbeatSubscription.class));
            }
        }
    }

    private void serializeHeartbeat(@NonNull JsonSerializationContext context, @NonNull JsonObject jsonObject, @NonNull ProvisionedMeshNode node) {
        ConfigurationServerModel model = this.getConfigurationServerModel(node);
        if (model != null) {
            JsonObject result;
            if (model.getHeartbeatPublication() != null) {
                result = context.serialize((Object)model.getHeartbeatPublication(), HeartbeatPublication.class).getAsJsonObject();
                result.remove("count");
                jsonObject.add("heartbeatPub", (JsonElement)result);
            }
            if (model.getHeartbeatSubscription() != null) {
                result = context.serialize((Object)model.getHeartbeatSubscription(), HeartbeatSubscription.class).getAsJsonObject();
                result.remove("count");
                result.remove("minHops");
                result.remove("maxHops");
                jsonObject.add("heartbeatSub", (JsonElement)result);
            }
        }
    }

    private ConfigurationServerModel getConfigurationServerModel(@NonNull ProvisionedMeshNode node) {
        MeshModel meshModel;
        Element element = node.getElements().get(node.getUnicastAddress());
        if (element != null && (meshModel = element.getMeshModels().get(0)) instanceof ConfigurationServerModel) {
            return (ConfigurationServerModel)meshModel;
        }
        return null;
    }
}

