/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.GenericStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public final class SceneRegisterStatus
extends GenericStatusMessage
implements Parcelable {
    private static final int SCENE_REGISTER_STATUS_MANDATORY_LENGTH = 3;
    private static final String TAG = SceneRegisterStatus.class.getSimpleName();
    private static final int OP_CODE = 33349;
    private int mStatus;
    private int mCurrentScene;
    private int[] mSceneList;
    private static final Parcelable.Creator<SceneRegisterStatus> CREATOR = new Parcelable.Creator<SceneRegisterStatus>(){

        public SceneRegisterStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new SceneRegisterStatus(message);
        }

        public SceneRegisterStatus[] newArray(int size) {
            return new SceneRegisterStatus[size];
        }
    };

    public SceneRegisterStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        Log.v((String)TAG, (String)("Received scene register status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true)));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(0);
        this.mStatus = buffer.get() & 0xFF;
        this.mCurrentScene = buffer.getShort() & 0xFFFF;
        Log.v((String)TAG, (String)("Status: " + this.mStatus));
        Log.v((String)TAG, (String)("Current Scene: " + this.mCurrentScene));
        if (buffer.limit() > 3) {
            int sceneCount = (buffer.limit() - 3) / 2;
            this.mSceneList = new int[sceneCount];
            for (int i = 0; i < sceneCount; ++i) {
                this.mSceneList[i] = buffer.getShort() & 0xFFFF;
            }
            Log.v((String)TAG, (String)("Scenes stored: " + sceneCount));
        }
    }

    @Override
    int getOpCode() {
        return 33349;
    }

    public final int getStatus() {
        return this.mStatus;
    }

    public final int getCurrentScene() {
        return this.mCurrentScene;
    }

    public int[] getSceneList() {
        return this.mSceneList;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

