/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.GenericStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class SceneStatus
extends GenericStatusMessage
implements Parcelable {
    private static final int SCENE_STATUS_MANDATORY_LENGTH = 3;
    private static final String TAG = SceneStatus.class.getSimpleName();
    private static final int OP_CODE = 94;
    private int mStatusCode;
    private int mCurrentScene;
    private Integer mTargetScene;
    private int mRemainingTime;
    private int mTransitionSteps;
    private int mTransitionResolution;
    private static final Parcelable.Creator<SceneStatus> CREATOR = new Parcelable.Creator<SceneStatus>(){

        public SceneStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new SceneStatus(message);
        }

        public SceneStatus[] newArray(int size) {
            return new SceneStatus[size];
        }
    };

    public SceneStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        Log.v((String)TAG, (String)("Received scene status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true)));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(0);
        this.mStatusCode = buffer.get() & 0xFF;
        this.mCurrentScene = buffer.getShort() & 0xFFFF;
        Log.v((String)TAG, (String)("Status: " + this.mStatusCode));
        Log.v((String)TAG, (String)("Current Scene : " + this.mCurrentScene));
        if (buffer.limit() > 3) {
            this.mTargetScene = buffer.getShort() & 0xFFFF;
            this.mRemainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = this.mRemainingTime & 0x3F;
            this.mTransitionResolution = this.mRemainingTime >> 6;
            Log.v((String)TAG, (String)("Target on: " + this.mTargetScene));
            Log.v((String)TAG, (String)("Remaining time, transition number of steps: " + this.mTransitionSteps));
            Log.v((String)TAG, (String)("Remaining time, transition number of step resolution: " + this.mTransitionResolution));
            Log.v((String)TAG, (String)("Remaining time: " + MeshParserUtils.getRemainingTime(this.mRemainingTime)));
        }
    }

    @Override
    int getOpCode() {
        return 94;
    }

    public final int getStatus() {
        return this.mStatusCode;
    }

    public final int getCurrentScene() {
        return this.mCurrentScene;
    }

    public final Integer getTargetScene() {
        return this.mTargetScene;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

